/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.intellij.ui.components.JBTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.IntSupplier;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

final class TranslationsEditorTextField
extends JBTextField {
    private final StringResourceTable myTable;
    private final IntSupplier myColumnSupplier;
    private SetTableValueAtTimer myTimer;

    TranslationsEditorTextField(@NotNull StringResourceTable table, int column) {
        if (table == null) {
            TranslationsEditorTextField.$$$reportNull$$$0(0);
        }
        this(table, () -> column);
    }

    TranslationsEditorTextField(final @NotNull StringResourceTable table, @NotNull IntSupplier columnSupplier) {
        if (table == null) {
            TranslationsEditorTextField.$$$reportNull$$$0(1);
        }
        if (columnSupplier == null) {
            TranslationsEditorTextField.$$$reportNull$$$0(2);
        }
        this.myTable = table;
        this.myColumnSupplier = columnSupplier;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(@NotNull KeyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                int rowCount = table.getSelectedRowCount();
                int columnCount = table.getSelectedColumnCount();
                if (rowCount != 1 || columnCount != 1) {
                    return;
                }
                if (TranslationsEditorTextField.this.myTimer == null || TranslationsEditorTextField.this.myTimer.isDone()) {
                    TranslationsEditorTextField.this.myTimer = new SetTableValueAtTimer(TranslationsEditorTextField.this.myTable, TranslationsEditorTextField.this.myColumnSupplier);
                }
                TranslationsEditorTextField.this.myTimer.setValue(((JTextComponent)event.getSource()).getText());
                TranslationsEditorTextField.this.myTimer.restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/TranslationsEditorTextField$1", "keyReleased"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "columnSupplier";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/editors/strings/TranslationsEditorTextField";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SetTableValueAtTimer
    extends Timer {
        private String myValue;
        private boolean myDone;

        private SetTableValueAtTimer(@NotNull StringResourceTable table, @NotNull IntSupplier columnSupplier) {
            if (table == null) {
                SetTableValueAtTimer.$$$reportNull$$$0(0);
            }
            if (columnSupplier == null) {
                SetTableValueAtTimer.$$$reportNull$$$0(1);
            }
            super(500, null);
            this.setRepeats(false);
            int row = table.getSelectedRowModelIndex();
            int column = columnSupplier.getAsInt();
            this.addActionListener(event -> {
                if (table == null) {
                    SetTableValueAtTimer.$$$reportNull$$$0(3);
                }
                table.getModel().setValueAt(this.myValue, row, column);
                table.refilter();
                this.myDone = true;
            });
        }

        private void setValue(@NotNull String value) {
            if (value == null) {
                SetTableValueAtTimer.$$$reportNull$$$0(2);
            }
            this.myValue = value;
        }

        private boolean isDone() {
            return this.myDone;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnSupplier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/editors/strings/TranslationsEditorTextField$SetTableValueAtTimer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

