/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModel
extends GradleFileModel {
    private static final String INCLUDE = "include";

    @Nullable
    public static GradleSettingsModel get(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleSettingsModel.$$$reportNull$$$0(0);
        }
        return (file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath(project))) != null ? GradleSettingsModel.parseBuildFile(file, project, "settings") : null;
    }

    @NotNull
    public static GradleSettingsModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleSettingsModel.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleSettingsModel.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            GradleSettingsModel.$$$reportNull$$$0(3);
        }
        GradleSettingsDslFile settingsFile = new GradleSettingsDslFile(file, project, moduleName);
        settingsFile.parse();
        GradleSettingsModel gradleSettingsModel = new GradleSettingsModel(settingsFile);
        if (gradleSettingsModel == null) {
            GradleSettingsModel.$$$reportNull$$$0(4);
        }
        return gradleSettingsModel;
    }

    private GradleSettingsModel(@NotNull GradleSettingsDslFile parsedModel) {
        if (parsedModel == null) {
            GradleSettingsModel.$$$reportNull$$$0(5);
        }
        super(parsedModel);
    }

    @NotNull
    public List<String> modulePaths() {
        ArrayList result = Lists.newArrayList();
        result.add(":");
        List<GradleNotNullValue<String>> includePaths = this.myGradleDslFile.getListProperty(INCLUDE, String.class);
        if (includePaths == null) {
            ArrayList arrayList = result;
            if (arrayList == null) {
                GradleSettingsModel.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        for (GradleNotNullValue<String> includePath : includePaths) {
            result.add(GradleSettingsModel.standardiseModulePath(includePath.value()));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GradleSettingsModel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public GradleSettingsModel addModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(8);
        }
        modulePath = GradleSettingsModel.standardiseModulePath(modulePath);
        this.myGradleDslFile.addToNewLiteralList(INCLUDE, modulePath);
        GradleSettingsModel gradleSettingsModel = this;
        if (gradleSettingsModel == null) {
            GradleSettingsModel.$$$reportNull$$$0(9);
        }
        return gradleSettingsModel;
    }

    @NotNull
    public GradleSettingsModel removeModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(10);
        }
        if (!modulePath.startsWith(":")) {
            this.myGradleDslFile.removeFromExpressionList(INCLUDE, ":" + modulePath);
        }
        this.myGradleDslFile.removeFromExpressionList(INCLUDE, modulePath);
        GradleSettingsModel gradleSettingsModel = this;
        if (gradleSettingsModel == null) {
            GradleSettingsModel.$$$reportNull$$$0(11);
        }
        return gradleSettingsModel;
    }

    @NotNull
    public GradleSettingsModel replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        if (oldModulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(12);
        }
        if (newModulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(13);
        }
        if (!newModulePath.startsWith(":")) {
            newModulePath = ":" + newModulePath;
        }
        if (!oldModulePath.startsWith(":")) {
            this.myGradleDslFile.replaceInExpressionList(INCLUDE, ":" + oldModulePath, newModulePath);
        }
        this.myGradleDslFile.replaceInExpressionList(INCLUDE, oldModulePath, newModulePath);
        GradleSettingsModel gradleSettingsModel = this;
        if (gradleSettingsModel == null) {
            GradleSettingsModel.$$$reportNull$$$0(14);
        }
        return gradleSettingsModel;
    }

    @Nullable
    public File moduleDirectory(String modulePath) {
        File parentDir;
        File projectDir;
        modulePath = GradleSettingsModel.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        File rootDirPath = Projects.getBaseDirPath(this.myGradleDslFile.getProject());
        if (modulePath.equals(":")) {
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = this.parentModule(modulePath);
            if (parentModule == null) {
                return null;
            }
            parentDir = this.moduleDirectory(parentModule);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        return new File(parentDir, moduleName);
    }

    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        if (moduleDir == null) {
            GradleSettingsModel.$$$reportNull$$$0(15);
        }
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectory(modulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath;
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(16);
        }
        if ((buildFilePath = this.buildFile(modulePath)) == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)true);
        if (buildFile == null) {
            return null;
        }
        return GradleBuildModel.parseBuildFile(buildFile, this.myGradleDslFile.getProject(), modulePath.substring(modulePath.lastIndexOf(58) + 1));
    }

    @Nullable
    public String parentModule(@NotNull String modulePath) {
        String parentModulePath;
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(17);
        }
        modulePath = GradleSettingsModel.standardiseModulePath(modulePath);
        List<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        if (modulePath.equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        String string = parentModulePath = lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
        if (allModulePaths.contains(parentModulePath)) {
            return parentModulePath;
        }
        return null;
    }

    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule;
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(18);
        }
        if ((parentModule = this.parentModule(modulePath)) == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory;
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(19);
        }
        if ((moduleDirectory = this.moduleDirectory(modulePath)) == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = (String)projectProperties.buildFileName().value();
        }
        if (buildFileName == null) {
            buildFileName = "build.gradle";
        }
        return new File(moduleDirectory, buildFileName);
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModel.$$$reportNull$$$0(20);
        }
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedModel";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModulePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModulePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "modulePaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addModulePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModulePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeModulePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceModulePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moduleModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parentModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentModuleModel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "standardiseModulePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleSettingsDslFile
    extends GradleDslFile {
        private GradleSettingsDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (file == null) {
                GradleSettingsDslFile.$$$reportNull$$$0(0);
            }
            if (project == null) {
                GradleSettingsDslFile.$$$reportNull$$$0(1);
            }
            if (moduleName == null) {
                GradleSettingsDslFile.$$$reportNull$$$0(2);
            }
            super(file, project, moduleName);
        }

        @Override
        public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
            if (property == null) {
                GradleSettingsDslFile.$$$reportNull$$$0(3);
            }
            if (element == null) {
                GradleSettingsDslFile.$$$reportNull$$$0(4);
            }
            if (property.equals(GradleSettingsModel.INCLUDE)) {
                this.addToParsedExpressionList(property, element);
                return;
            }
            super.addParsedElement(property, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModel$GradleSettingsDslFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addParsedElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

