/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class FixGradleVersionInWrapperHyperlink
extends NotificationHyperlink {
    @NotNull
    private final GradleWrapper myGradleWrapper;
    @NotNull
    private final String myGradleVersion;

    @Nullable
    public static NotificationHyperlink createIfProjectUsesGradleWrapper(@NotNull Project project, @Nullable String gradleVersion) {
        GradleWrapper gradleWrapper;
        if (project == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(0);
        }
        if ((gradleWrapper = GradleWrapper.find(project)) != null) {
            String version = gradleVersion != null ? gradleVersion : "4.1";
            return new FixGradleVersionInWrapperHyperlink(gradleWrapper, version);
        }
        return null;
    }

    private FixGradleVersionInWrapperHyperlink(@NotNull GradleWrapper gradleWrapper, @NotNull String gradleVersion) {
        if (gradleWrapper == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(1);
        }
        if (gradleVersion == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(2);
        }
        super("fixGradleVersionInWrapper", "Fix Gradle wrapper and re-import project");
        this.myGradleWrapper = gradleWrapper;
        this.myGradleVersion = gradleVersion;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(3);
        }
        this.myGradleWrapper.updateDistributionUrlAndDisplayFailure(this.myGradleVersion);
        FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
    }

    @Override
    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        boolean updated;
        if (project == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(4);
        }
        if (event == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(5);
        }
        if (updated = this.myGradleWrapper.updateDistributionUrlAndDisplayFailure(this.myGradleVersion)) {
            EditableNotificationMessageElement.disableLink((HyperlinkEvent)event);
            FixGradleVersionInWrapperHyperlink.setDistributionTypeAndSync(project);
        }
        return updated;
    }

    private static void setDistributionTypeAndSync(@NotNull Project project) {
        GradleProjectSettings settings;
        if (project == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(6);
        }
        if ((settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project)) != null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
        FixGradleVersionInWrapperHyperlink.requestSync(project);
    }

    private static void requestSync(@NotNull Project project) {
        if (project == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(7);
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
    }

    @VisibleForTesting
    @NotNull
    public String getGradleVersion() {
        String string = this.myGradleVersion;
        if (string == null) {
            FixGradleVersionInWrapperHyperlink.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/FixGradleVersionInWrapperHyperlink";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createIfProjectUsesGradleWrapper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeIfClicked";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDistributionTypeAndSync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestSync";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

