/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public ProjectStructureCleanupStep(@NotNull AndroidSdks androidSdks) {
        if (androidSdks == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(0);
        }
        this.myAndroidSdks = androidSdks;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(1);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectStructureCleanupStep.$$$reportNull$$$0(2);
        }
        HashSet<Sdk> androidSdks = new HashSet<Sdk>();
        for (Module module : ideModifiableModelsProvider.getModules()) {
            ModifiableRootModel rootModel = ideModifiableModelsProvider.getModifiableRootModel(module);
            Sdk sdk = rootModel.getSdk();
            if (sdk != null) {
                if (!this.myAndroidSdks.isAndroidSdk(sdk)) continue;
                androidSdks.add(sdk);
                continue;
            }
            NativeAndroidProject nativeAndroidProject = GradleUtil.getNativeAndroidProject(module);
            if (nativeAndroidProject != null) continue;
            Sdk jdk = IdeSdks.getInstance().getJdk();
            rootModel.setSdk(jdk);
        }
        for (final Sdk sdk : androidSdks) {
            ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                public void execute() {
                    ProjectStructureCleanupStep.this.myAndroidSdks.refreshLibrariesIn(sdk);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModifiableModelsProvider";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/cleanup/ProjectStructureCleanupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

