/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.scene.decorator.NavSceneDecoratorFactory;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.targets.NavScreenTargetProvider;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.UIUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavSceneManager
extends SceneManager {
    private static final int SUBNAV_WIDTH = 100;
    private static final int SUBNAV_HEIGHT = 25;
    private final NavScreenTargetProvider myScreenTargetProvider;
    private NavSceneLayoutAlgorithm myLayoutAlgorithm;
    private SceneDecoratorFactory myDecoratorFactory;
    private static final String ENABLE_NAV_PROPERTY = "enable.nav.editor";

    public NavSceneManager(@NotNull NlModel model, @NotNull NavDesignSurface surface) {
        if (model == null) {
            NavSceneManager.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            NavSceneManager.$$$reportNull$$$0(1);
        }
        super(model, surface);
        NavigationSchema schema = surface.getSchema();
        this.myLayoutAlgorithm = new ManualLayoutAlgorithm(model.getModule());
        surface.zoomActual();
        this.myScreenTargetProvider = new NavScreenTargetProvider(this.myLayoutAlgorithm, schema);
    }

    public static boolean enableNavigationEditor() {
        return Boolean.getBoolean(ENABLE_NAV_PROPERTY);
    }

    @Override
    @NotNull
    public Scene build() {
        NavSceneManager.updateHierarchy(this.getModel(), null);
        Scene scene = super.build();
        this.getModel().addListener(new ModelChangeListener());
        this.getDesignSurface().getSelectionModel().addListener((model, selection) -> scene.needsRebuildList());
        this.requestRender();
        Scene scene2 = scene;
        if (scene2 == null) {
            NavSceneManager.$$$reportNull$$$0(2);
        }
        return scene2;
    }

    @Override
    @NotNull
    public NavDesignSurface getDesignSurface() {
        NavDesignSurface navDesignSurface = (NavDesignSurface)super.getDesignSurface();
        if (navDesignSurface == null) {
            NavSceneManager.$$$reportNull$$$0(3);
        }
        return navDesignSurface;
    }

    @Override
    protected void updateFromComponent(@NotNull SceneComponent sceneComponent) {
        if (sceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(4);
        }
        super.updateFromComponent(sceneComponent);
        NavigationSchema.DestinationType type = this.getDesignSurface().getSchema().getDestinationType(sceneComponent.getNlComponent().getTagName());
        if (type != null) {
            sceneComponent.setTargetProvider(this.myScreenTargetProvider, false);
            switch (type) {
                case NAVIGATION: {
                    if (sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
                        sceneComponent.setSize(-1, -1, false);
                        break;
                    }
                    sceneComponent.setSize(100, 25, false);
                    break;
                }
                case FRAGMENT: 
                case ACTIVITY: {
                    State state = this.getModel().getConfiguration().getDeviceState();
                    assert (state != null);
                    Screen screen = state.getHardware().getScreen();
                    sceneComponent.setSize(screen.getXDimension() / 4, screen.getYDimension() / 4, true);
                    break;
                }
            }
        }
    }

    @Override
    protected void postUpdateFromComponent(@NotNull SceneComponent sceneComponent) {
        NavigationSchema.DestinationType type;
        if (sceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(5);
        }
        if ((type = this.getDesignSurface().getSchema().getDestinationType(sceneComponent.getNlComponent().getTagName())) == NavigationSchema.DestinationType.NAVIGATION && sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
            this.layoutAll(sceneComponent);
            this.updateRootBounds(sceneComponent);
        }
    }

    private void updateRootBounds(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(6);
        }
        Rectangle bounds = new Rectangle(0, 0, -1, -1);
        Rectangle temp = new Rectangle();
        Rectangle rootBounds = root.fillRect(null);
        root.flatten().filter(c -> {
            if (root == null) {
                NavSceneManager.$$$reportNull$$$0(14);
            }
            return c != root;
        }).forEach(component2 -> {
            if (component2.isDragging()) {
                if (bounds.width < 0) {
                    bounds.setBounds(rootBounds);
                } else {
                    bounds.add(rootBounds);
                }
                bounds.add(component2.getCenterX(), component2.getCenterY());
            } else {
                Rectangle componentBounds = component2.fillDrawRect(0L, temp);
                componentBounds.setLocation(componentBounds.x - 50, componentBounds.y - 50);
                componentBounds.setSize(componentBounds.width + 100, componentBounds.height + 100);
                if (bounds.width < 0) {
                    bounds.setBounds(componentBounds);
                } else {
                    bounds.add(componentBounds);
                }
            }
        });
        NavDesignSurface surface = this.getDesignSurface();
        SceneView view = surface.getCurrentSceneView();
        if (view != null) {
            surface.getCurrentSceneView().setLocation(Math.max(0, Coordinates.getSwingXDip(view, bounds.x)), Math.max(0, Coordinates.getSwingYDip(view, bounds.y)));
        }
        root.setPosition(bounds.x, bounds.y);
        root.setSize(bounds.width, bounds.height, false);
    }

    @Override
    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = this.getDesignSurface().getCurrentNavigation();
        if (nlComponent == null) {
            NavSceneManager.$$$reportNull$$$0(7);
        }
        return nlComponent;
    }

    @Override
    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component2) {
        NavigationSchema.DestinationType type;
        if (component2 == null) {
            NavSceneManager.$$$reportNull$$$0(8);
        }
        if ((type = this.getDesignSurface().getSchema().getDestinationType(component2.getTagName())) != null) {
            switch (type) {
                case NAVIGATION: {
                    if (component2 != this.getRoot()) {
                        SceneComponent sceneComponent = this.getScene().getSceneComponent(component2);
                        if (sceneComponent == null) {
                            sceneComponent = new SceneComponent(this.getScene(), component2);
                        }
                        return sceneComponent;
                    }
                    return super.createHierarchy(component2);
                }
                case FRAGMENT: 
                case ACTIVITY: {
                    return super.createHierarchy(component2);
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component2) {
        if (component2 == null) {
            NavSceneManager.$$$reportNull$$$0(9);
        }
        TemporarySceneComponent temporarySceneComponent = new TemporarySceneComponent(this.getScene(), component2);
        if (temporarySceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(10);
        }
        return temporarySceneComponent;
    }

    @Override
    public void requestRender() {
        this.update();
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            root.updateTargets(true);
            this.layoutAll(root);
        }
    }

    private void layoutAll(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(11);
        }
        root.flatten().filter(component2 -> component2.getParent() != null).forEach(component2 -> component2.setPosition(0, 0));
        root.flatten().filter(component2 -> component2.getParent() != null).forEach(this.myLayoutAlgorithm::layout);
    }

    @Override
    public void layout(boolean animate) {
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            this.updateRootBounds(root);
        }
        this.getDesignSurface().updateScrolledAreaSize();
        this.getScene().needsRebuildList();
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        if (this.myDecoratorFactory == null) {
            this.myDecoratorFactory = new NavSceneDecoratorFactory(this.getDesignSurface().getSchema());
        }
        SceneDecoratorFactory sceneDecoratorFactory = this.myDecoratorFactory;
        if (sceneDecoratorFactory == null) {
            NavSceneManager.$$$reportNull$$$0(12);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public Map<Object, PropertiesMap> getDefaultProperties() {
        return ImmutableMap.of();
    }

    public static void updateHierarchy(@NotNull NlModel model, @Nullable NlModel newModel) {
        if (model == null) {
            NavSceneManager.$$$reportNull$$$0(13);
        }
        Object roots = ImmutableList.of();
        XmlTag newRoot = AndroidPsiUtils.getRootTagSafely(model.getFile());
        if (newModel != null) {
            newRoot = AndroidPsiUtils.getRootTagSafely(newModel.getFile());
            roots = NavSceneManager.buildTree((XmlTag[])newModel.getComponents().stream().map(NlComponent::getTag).toArray(XmlTag[]::new));
        }
        if (newRoot != null) {
            model.syncWithPsi(newRoot, (List<NlModel.TagSnapshotTreeNode>)roots);
        }
    }

    private static List<NlModel.TagSnapshotTreeNode> buildTree(XmlTag[] roots) {
        ArrayList<NlModel.TagSnapshotTreeNode> result = new ArrayList<NlModel.TagSnapshotTreeNode>();
        for (final XmlTag root : roots) {
            NlModel.TagSnapshotTreeNode node = new NlModel.TagSnapshotTreeNode(){

                @Override
                public TagSnapshot getTagSnapshot() {
                    return TagSnapshot.createTagSnapshot(root, null);
                }

                @Override
                @NotNull
                public List<NlModel.TagSnapshotTreeNode> getChildren() {
                    List list = NavSceneManager.buildTree(root.getSubTags());
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/naveditor/scene/NavSceneManager$1", "getChildren"));
                }
            };
            result.add(node);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/NavSceneManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/NavSceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "postUpdateFromComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRootBounds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "layoutAll";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateRootBounds$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            NavSceneManager.updateHierarchy(model, model);
            NavSceneManager.this.requestRender();
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            UIUtil.invokeLaterIfNeeded(NavSceneManager.this::update);
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            boolean previous = NavSceneManager.this.getScene().isAnimated();
            UIUtil.invokeLaterIfNeeded(() -> {
                NavSceneManager.this.getScene().setAnimated(animate);
                NavSceneManager.this.update();
                NavSceneManager.this.getScene().setAnimated(previous);
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(4);
            }
            NavSceneManager.updateHierarchy(model, model);
        }

        @Override
        public void modelDeactivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/naveditor/scene/NavSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelRendered";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelActivated";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDeactivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

