/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import com.android.tools.idea.naveditor.scene.targets.ActionTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.sherpa.drawing.ColorSet;
import com.google.common.collect.ImmutableMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DrawAction
extends NavBaseDrawCommand {
    private static final Map<RenderingHints.Key, Object> HQ_RENDERING_HITS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private static final GeneralPath PATH = new GeneralPath();
    private final ActionTarget.ConnectionType myConnectionType;
    private Rectangle mySource;
    private Rectangle myDest;
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(8.0f);
    private final DrawMode myMode;

    @Override
    @NotNull
    protected Object[] getProperties() {
        Object[] objectArray = new Object[]{this.myConnectionType, DrawAction.rectToString(this.mySource), DrawAction.rectToString(this.myDest), this.myMode};
        if (objectArray == null) {
            DrawAction.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private static String rectToString(@NotNull Rectangle r) {
        if (r == null) {
            DrawAction.$$$reportNull$$$0(1);
        }
        return r.x + "x" + r.y + "x" + r.width + "x" + r.height;
    }

    private static Rectangle stringToRect(@NotNull String s) {
        if (s == null) {
            DrawAction.$$$reportNull$$$0(2);
        }
        String[] sp = s.split("x");
        int c = 0;
        Rectangle r = new Rectangle();
        r.x = Integer.parseInt(sp[c++]);
        r.y = Integer.parseInt(sp[c++]);
        r.width = Integer.parseInt(sp[c++]);
        r.height = Integer.parseInt(sp[c++]);
        return r;
    }

    public DrawAction(@NotNull String s) {
        if (s == null) {
            DrawAction.$$$reportNull$$$0(3);
        }
        this.mySource = new Rectangle();
        this.myDest = new Rectangle();
        String[] sp = s.split(",");
        int c = 0;
        this.myConnectionType = ActionTarget.ConnectionType.valueOf(sp[c++]);
        this.mySource = DrawAction.stringToRect(sp[c++]);
        this.myDest = DrawAction.stringToRect(sp[c++]);
        this.myMode = DrawMode.valueOf(sp[c++]);
    }

    @Override
    public int getLevel() {
        return 21;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        if (g == null) {
            DrawAction.$$$reportNull$$$0(4);
        }
        if (sceneContext == null) {
            DrawAction.$$$reportNull$$$0(5);
        }
        g.setRenderingHints(HQ_RENDERING_HITS);
        Color previousColor = g.getColor();
        ColorSet color = sceneContext.getColorSet();
        g.setColor(color.getConstraints());
        DrawAction.draw(g, color, this.myConnectionType, this.mySource, this.myDest, this.myMode);
        g.setColor(previousColor);
    }

    private DrawAction(@NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            DrawAction.$$$reportNull$$$0(7);
        }
        this.mySource = new Rectangle();
        this.myDest = new Rectangle();
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myMode = mode;
    }

    public static void buildDisplayList(@NotNull DisplayList list, @NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        if (list == null) {
            DrawAction.$$$reportNull$$$0(8);
        }
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            DrawAction.$$$reportNull$$$0(10);
        }
        list.add(new DrawAction(connectionType, source, dest, mode));
    }

    private static void draw(@NotNull Graphics2D g, @NotNull ColorSet color, @NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        if (g == null) {
            DrawAction.$$$reportNull$$$0(11);
        }
        if (color == null) {
            DrawAction.$$$reportNull$$$0(12);
        }
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(13);
        }
        if (mode == null) {
            DrawAction.$$$reportNull$$$0(14);
        }
        Color actionColor = mode == DrawMode.SELECTED ? color.getSelectedFrames() : color.getFrames();
        ActionTarget.CurvePoints points = ActionTarget.getCurvePoints(source, dest);
        PATH.reset();
        PATH.moveTo(points.p1.x, points.p1.y);
        switch (connectionType) {
            case SELF: {
                break;
            }
            case NORMAL: {
                g.setColor(actionColor);
                PATH.curveTo(points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
                Stroke defaultStroke = g.getStroke();
                g.setStroke(BACKGROUND_STROKE);
                g.setColor(color.getBackground());
                int[] xPoints = new int[3];
                int[] yPoints = new int[3];
                int arrowX = points.p4.x - ActionTarget.getDestinationDx(points.dir);
                int arrowY = points.p4.y - ActionTarget.getDestinationDy(points.dir);
                DrawConnectionUtils.getArrow(points.dir.ordinal(), arrowX, arrowY, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(PATH);
                g.setStroke(defaultStroke);
                g.setColor(actionColor);
                DrawConnectionUtils.getArrow(points.dir.ordinal(), arrowX, arrowY, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(PATH);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/draw/DrawAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/draw/DrawAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rectToString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stringToRect";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DrawMode {
        NORMAL,
        SELECTED;

    }
}

