/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class DrawActionHandle
extends NavBaseDrawCommand {
    public static final int BACKGROUND_RADIUS = 6;
    public static final int SMALL_RADIUS = 8;
    public static final int LARGE_RADIUS = 12;
    public static final int BORDER_THICKNESS = 3;
    public static final int MAX_DURATION = 200;
    private final int myX;
    private final int myY;
    private final int myInitialRadius;
    private final int myFinalRadius;
    private final Color myBorderColor;
    private final Color myFillColor;
    private long myStartTime;

    public DrawActionHandle(int x, int y, int initialRadius, int finalRadius, @NotNull Color borderColor, @NotNull Color fillColor) {
        if (borderColor == null) {
            DrawActionHandle.$$$reportNull$$$0(0);
        }
        if (fillColor == null) {
            DrawActionHandle.$$$reportNull$$$0(1);
        }
        this.myStartTime = -1L;
        this.myX = x;
        this.myY = y;
        this.myInitialRadius = initialRadius;
        this.myFinalRadius = finalRadius;
        this.myBorderColor = borderColor;
        this.myFillColor = fillColor;
    }

    @Override
    public int getLevel() {
        return 24;
    }

    @Override
    @NotNull
    protected Object[] getProperties() {
        Object[] objectArray = new Object[]{this.myX, this.myY, this.myInitialRadius, this.myFinalRadius, String.format("%x", this.myBorderColor.getRGB()), String.format("%x", this.myFillColor.getRGB())};
        if (objectArray == null) {
            DrawActionHandle.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        if (g == null) {
            DrawActionHandle.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            DrawActionHandle.$$$reportNull$$$0(4);
        }
        long currentTime = sceneContext.getTime();
        if (this.myStartTime == -1L) {
            this.myStartTime = currentTime;
        }
        int delta = this.myFinalRadius - this.myInitialRadius;
        int duration = Math.abs(delta) * 200 / 12;
        int elapsed = (int)(currentTime - this.myStartTime);
        int r = this.myFinalRadius;
        if (elapsed < duration) {
            r = this.myInitialRadius + delta * elapsed / duration;
        }
        DrawActionHandle.fillCircle(g, this.myX, this.myY, Math.max(r, 6), this.myBorderColor);
        DrawActionHandle.fillCircle(g, this.myX, this.myY, r - 3, this.myFillColor);
        if (r != this.myFinalRadius) {
            sceneContext.repaint();
        }
    }

    private static void fillCircle(Graphics2D g, int x, int y, int r, Color color) {
        g.setColor(color);
        g.fillOval(x - r, y - r, 2 * r, 2 * r);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "borderColor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/draw/DrawActionHandle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/draw/DrawActionHandle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

