/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.navigator.nodes.apk.ndk.PathTrees;
import com.android.tools.idea.navigator.nodes.apk.ndk.SourceCodeFilter;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NdkSourceNode
extends ProjectViewNode<File> {
    @NotNull
    private final File myNdkPath;
    @NotNull
    private final List<PsiDirectory> mySourceFolders;
    @NotNull
    private final SourceCodeFilter myFilter;

    public NdkSourceNode(@NotNull Project project, @NotNull File ndkPath, @NotNull PathTree ndkPathTree, @NotNull SourceCodeFilter filter, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            NdkSourceNode.$$$reportNull$$$0(0);
        }
        if (ndkPath == null) {
            NdkSourceNode.$$$reportNull$$$0(1);
        }
        if (ndkPathTree == null) {
            NdkSourceNode.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            NdkSourceNode.$$$reportNull$$$0(3);
        }
        if (viewSettings == null) {
            NdkSourceNode.$$$reportNull$$$0(4);
        }
        super(project, (Object)ndkPath, viewSettings);
        this.myNdkPath = ndkPath;
        this.myFilter = filter;
        this.mySourceFolders = PathTrees.findSourceFolders(ndkPathTree, ndkPath.getPath(), project);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            NdkSourceNode.$$$reportNull$$$0(5);
        }
        for (PsiDirectory sourceFolder : this.mySourceFolders) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceFolder.getVirtualFile(), (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<PsiDirectoryNode> children = new ArrayList<PsiDirectoryNode>();
        ViewSettings settings = this.getSettings();
        for (PsiDirectory folder : this.mySourceFolders) {
            children.add(new PsiDirectoryNode(this.myProject, folder, settings, (PsiFileSystemItemFilter)this.myFilter));
        }
        ArrayList<PsiDirectoryNode> arrayList = children;
        if (arrayList == null) {
            NdkSourceNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.setIcon(AndroidIcons.Android);
        presentation.addText("NDK ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(this.myNdkPath.getPath(), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NdkSourceNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NdkSourceNode that = (NdkSourceNode)((Object)o);
        return Objects.equals(this.myNdkPath, that.myNdkPath) && Objects.equals(this.mySourceFolders, that.mySourceFolders) && Objects.equals(this.myFilter, that.myFilter);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myNdkPath, this.mySourceFolders, this.myFilter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkPathTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/ndk/NdkSourceNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/ndk/NdkSourceNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

