/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.ndk.ExternalBuildFileNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFilesGroupNode
extends ProjectViewNode<Project> {
    public ExternalBuildFilesGroupNode(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(1);
        }
        super(project, (Object)project, settings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(2);
        }
        return this.getBuildFilesWithModuleNames().containsKey(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Map<VirtualFile, String> buildFiles = this.getBuildFilesWithModuleNames();
        ArrayList<PsiFileNode> children = new ArrayList<PsiFileNode>(buildFiles.size());
        for (Map.Entry<VirtualFile, String> buildFileWithModuleName : buildFiles.entrySet()) {
            this.addPsiFile(children, buildFileWithModuleName.getKey(), buildFileWithModuleName.getValue());
        }
        ArrayList<PsiFileNode> arrayList = children;
        if (arrayList == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private Map<VirtualFile, String> getBuildFilesWithModuleNames() {
        HashMap<VirtualFile, String> buildFiles = new HashMap<VirtualFile, String>();
        assert (this.myProject != null);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
            if (ndkModuleModel == null) continue;
            for (File file : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (virtualFile == null) continue;
                buildFiles.put(virtualFile, module.getName());
            }
        }
        HashMap<VirtualFile, String> hashMap = buildFiles;
        if (hashMap == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @NotNull VirtualFile file, @NotNull String moduleName) {
        if (psiFileNodes == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(6);
        }
        if (moduleName == null) {
            ExternalBuildFilesGroupNode.$$$reportNull$$$0(7);
        }
        assert (this.myProject != null);
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null) {
            psiFileNodes.add(new ExternalBuildFileNode(this.myProject, psiFile, this.getSettings(), moduleName));
        }
    }

    public int getWeight() {
        return 200;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText("External Build Files");
        presentation.setIcon(AllIcons.General.ExternalToolsSmall);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "External Build Files";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/ExternalBuildFilesGroupNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileNodes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/ExternalBuildFilesGroupNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFilesWithModuleNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

