/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DynamicResourceValueRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceRepositories;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceFolderManager.ResourceFolderListener myResourceFolderListener;

    @Nullable
    public static LocalResourceRepository getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ModuleResourceRepository.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ModuleResourceRepository.getOrCreateInstance(facet) : null;
    }

    @NotNull
    public static LocalResourceRepository getOrCreateInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(1);
        }
        LocalResourceRepository localResourceRepository = ModuleResourceRepository.findModuleResources(facet, true);
        if (localResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(2);
        }
        return localResourceRepository;
    }

    @Nullable
    public static LocalResourceRepository findExistingInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(3);
        }
        return ModuleResourceRepository.findModuleResources(facet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static LocalResourceRepository findModuleResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(4);
        }
        ResourceRepositories repositories = ResourceRepositories.getOrCreateInstance(facet);
        return repositories.getModuleResources(createIfNecessary);
    }

    @NotNull
    static LocalResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(5);
        }
        if (!facet.requiresAndroidModel()) {
            VirtualFile primaryResourceDir = facet.getPrimaryResourceDir();
            if (primaryResourceDir == null) {
                EmptyRepository emptyRepository = new EmptyRepository();
                if (emptyRepository == null) {
                    ModuleResourceRepository.$$$reportNull$$$0(6);
                }
                return emptyRepository;
            }
            ResourceFolderRepository resourceFolderRepository = ResourceFolderRegistry.get(facet, primaryResourceDir);
            if (resourceFolderRepository == null) {
                ModuleResourceRepository.$$$reportNull$$$0(7);
            }
            return resourceFolderRepository;
        }
        ResourceFolderManager folderManager = facet.getResourceFolderManager();
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)(resourceDirectories.size() + 1));
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        ModuleResourceRepository repository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        Disposer.register((Disposable)repository, (Disposable)dynamicResources);
        ModuleResourceRepository moduleResourceRepository = repository;
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(8);
        }
        return moduleResourceRepository;
    }

    private ModuleResourceRepository(@NotNull AndroidFacet facet2, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet2 == null) {
            ModuleResourceRepository.$$$reportNull$$$0(9);
        }
        if (delegates == null) {
            ModuleResourceRepository.$$$reportNull$$$0(10);
        }
        super(facet2.getModule().getName(), delegates);
        this.myResourceFolderListener = (facet, folders, added, removed) -> this.updateRoots();
        this.myFacet = facet2;
        this.myFacet.getResourceFolderManager().addListener(this.myResourceFolderListener);
    }

    private void updateRoots() {
        this.updateRoots(this.myFacet.getResourceFolderManager().getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        List other = null;
        HashMap map = Maps.newHashMap();
        for (LocalResourceRepository localResourceRepository : this.getChildren()) {
            if (localResourceRepository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)localResourceRepository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map.put(resourceDir, folderRepository);
                continue;
            }
            assert (localResourceRepository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = Lists.newArrayList();
            }
            other.add(localResourceRepository);
        }
        HashSet newDirs = Sets.newHashSet(resourceDirectories);
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)(newDirs.size() + (other != null ? other.size() : 0)));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map.get(dir));
            if (repository == null) {
                repository = ResourceFolderRegistry.get(this.myFacet, dir);
            } else {
                map.remove(dir);
            }
            arrayList.add(repository);
        }
        if (other != null) {
            arrayList.addAll(other);
        }
        if (arrayList.equals(this.getChildren())) {
            assert (map.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map.values()) {
            removed.removeParent(this);
        }
        this.setChildren(arrayList);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myFacet.getResourceFolderManager().removeListener(this.myResourceFolderListener);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(11);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(12);
        }
        ModuleResourceRepository moduleResourceRepository = ModuleResourceRepository.createForTest(facet, resourceDirectories, null, null);
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(13);
        }
        return moduleResourceRepository;
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories, @Nullable String namespace, @Nullable DynamicResourceValueRepository dynamicResourceValueRepository) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(14);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(15);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<LocalResourceRepository> delegates = new ArrayList<LocalResourceRepository>(resourceDirectories.size() + 1);
        for (VirtualFile resourceDirectory : resourceDirectories) {
            delegates.add(ResourceFolderRegistry.get(facet, resourceDirectory, namespace));
        }
        if (dynamicResourceValueRepository != null) {
            delegates.add(dynamicResourceValueRepository);
        }
        ModuleResourceRepository moduleResourceRepository = new ModuleResourceRepository(facet, delegates);
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(16);
        }
        return moduleResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstance";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateInstance";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModuleResources";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyRepository
    extends LocalResourceRepository {
        protected EmptyRepository() {
            super("");
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                EmptyRepository.$$$reportNull$$$0(0);
            }
            return set;
        }

        protected ResourceTable getFullTable() {
            return new ResourceTable();
        }

        protected ListMultimap<String, ResourceItem> getMap(String namespace, ResourceType type, boolean create) {
            return create ? ArrayListMultimap.create() : null;
        }

        public Set<String> getNamespaces() {
            return Collections.emptySet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ModuleResourceRepository$EmptyRepository", "computeResourceDirs"));
        }
    }
}

