/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.ResourceClassGenerator;
import com.android.xml.AndroidManifest;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClassRegistry
implements ProjectComponent {
    private final Map<AppResourceRepository, ResourceClassGenerator> myGeneratorMap = Maps.newHashMap();
    private final Project myProject;
    private Collection<String> myPackages;

    public ResourceClassRegistry(Project project) {
        this.myProject = project;
    }

    public void addLibrary(@NotNull AppResourceRepository appResources, @Nullable String pkg) {
        if (appResources == null) {
            ResourceClassRegistry.$$$reportNull$$$0(0);
        }
        if (pkg != null && !pkg.isEmpty()) {
            if (this.myPackages == null) {
                this.myPackages = new HashSet();
            }
            this.myPackages.add(pkg);
            if (!this.myGeneratorMap.containsKey((Object)appResources)) {
                ResourceClassGenerator generator = ResourceClassGenerator.create(appResources);
                this.myGeneratorMap.put(appResources, generator);
            }
        }
    }

    public void addAarLibrary(@NotNull AppResourceRepository appResources, @NotNull File aarDir) {
        FileResourceRepository repository;
        String path;
        if (appResources == null) {
            ResourceClassRegistry.$$$reportNull$$$0(1);
        }
        if (aarDir == null) {
            ResourceClassRegistry.$$$reportNull$$$0(2);
        }
        if (((path = aarDir.getPath()).endsWith(".aar") || path.contains("exploded-aar")) && (repository = appResources.findRepositoryFor(aarDir)) != null) {
            this.addLibrary(appResources, this.getAarPackage(aarDir));
        }
    }

    @Nullable
    public String getAarPackage(@NotNull File aarDir) {
        File manifest;
        if (aarDir == null) {
            ResourceClassRegistry.$$$reportNull$$$0(3);
        }
        if ((manifest = new File(aarDir, "AndroidManifest.xml")).exists()) {
            try {
                return AndroidManifest.getPackage((IAbstractFile)new FileWrapper(manifest));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String name, @NotNull AppResourceRepository appRepo) {
        int index;
        if (name == null) {
            ResourceClassRegistry.$$$reportNull$$$0(4);
        }
        if (appRepo == null) {
            ResourceClassRegistry.$$$reportNull$$$0(5);
        }
        if ((index = name.lastIndexOf(46)) != -1 && name.charAt(index + 1) == 'R' && (index == name.length() - 2 || name.charAt(index + 2) == '$') && index > 1) {
            ResourceClassGenerator generator;
            String pkg = name.substring(0, index);
            if (this.myPackages != null && this.myPackages.contains(pkg) && (generator = this.myGeneratorMap.get((Object)appRepo)) != null) {
                return generator.generate(name);
            }
        }
        return null;
    }

    public void clearCache() {
        this.myGeneratorMap.clear();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AppResourceRepository appResources = AppResourceRepository.findExistingInstance(module);
            if (appResources == null) continue;
            appResources.resetDynamicIds(false);
        }
    }

    void clearCache(AppResourceRepository appResources) {
        this.myGeneratorMap.remove((Object)appResources);
    }

    public static ResourceClassRegistry get(@NotNull Project project) {
        if (project == null) {
            ResourceClassRegistry.$$$reportNull$$$0(6);
        }
        return (ResourceClassRegistry)project.getComponent(ResourceClassRegistry.class);
    }

    @NotNull
    public String getComponentName() {
        String string = ResourceClassRegistry.class.getName();
        if (string == null) {
            ResourceClassRegistry.$$$reportNull$$$0(7);
        }
        return string;
    }

    Collection<String> getPackages() {
        return this.myPackages;
    }

    Map<AppResourceRepository, ResourceClassGenerator> getGeneratorMap() {
        return this.myGeneratorMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appResources";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appRepo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceClassRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceClassRegistry";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAarLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAarPackage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

