/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployTargetContext
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(DeployTargetContext.class);
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    private final List<DeployTargetProvider> myDeployTargetProviders = DeployTargetProvider.getProviders();
    private final Map<String, DeployTargetState> myDeployTargetStates;

    public DeployTargetContext() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider provider : this.myDeployTargetProviders) {
            builder.put((Object)provider.getId(), provider.createState());
        }
        this.myDeployTargetStates = builder.build();
    }

    @NotNull
    public List<DeployTargetProvider> getDeployTargetProviders() {
        List<DeployTargetProvider> list = this.myDeployTargetProviders;
        if (list == null) {
            DeployTargetContext.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        DeployTargetProvider target = this.getDeployTargetProvider(this.TARGET_SELECTION_MODE);
        if (target == null) {
            target = this.getDeployTargetProvider(TargetSelectionMode.SHOW_DIALOG.name());
        }
        assert (target != null);
        DeployTargetProvider deployTargetProvider = target;
        if (deployTargetProvider == null) {
            DeployTargetContext.$$$reportNull$$$0(1);
        }
        return deployTargetProvider;
    }

    @Nullable
    private DeployTargetProvider getDeployTargetProvider(@NotNull String id) {
        if (id == null) {
            DeployTargetContext.$$$reportNull$$$0(2);
        }
        for (DeployTargetProvider target : this.myDeployTargetProviders) {
            if (!target.getId().equals(id)) continue;
            return target;
        }
        return null;
    }

    @NotNull
    public Map<String, DeployTargetState> getDeployTargetStates() {
        Map<String, DeployTargetState> map = this.myDeployTargetStates;
        if (map == null) {
            DeployTargetContext.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(currentTarget.getId());
        if (deployTargetState == null) {
            DeployTargetContext.$$$reportNull$$$0(4);
        }
        return deployTargetState;
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target) {
        if (target == null) {
            DeployTargetContext.$$$reportNull$$$0(5);
        }
        DeployTargetState deployTargetState = this.myDeployTargetStates.get(target.getId());
        if (deployTargetState == null) {
            DeployTargetContext.$$$reportNull$$$0(6);
        }
        return deployTargetState;
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        if (mode == null) {
            DeployTargetContext.$$$reportNull$$$0(7);
        }
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target) {
        if (target == null) {
            DeployTargetContext.$$$reportNull$$$0(8);
        }
        this.TARGET_SELECTION_MODE = target.getId();
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        TargetSelectionMode targetSelectionMode;
        try {
            targetSelectionMode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            TargetSelectionMode targetSelectionMode2 = TargetSelectionMode.EMULATOR;
            if (targetSelectionMode2 == null) {
                DeployTargetContext.$$$reportNull$$$0(10);
            }
            return targetSelectionMode2;
        }
        if (targetSelectionMode == null) {
            DeployTargetContext.$$$reportNull$$$0(9);
        }
        return targetSelectionMode;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/DeployTargetContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDeployTargetProvider";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/DeployTargetContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetStates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDeployTargetState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSelectionMode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTargetProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTargetState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTargetSelectionMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

