/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.builder.model.SourceProvider;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public final class Parameter {
    private static final String URI_AUTHORITY_REGEX = "[a-zA-Z][a-zA-Z0-9-_.]*(:\\d+)?";
    public static final EnumSet<Constraint> TYPE_CONSTRAINTS = EnumSet.of(Constraint.ACTIVITY, new Constraint[]{Constraint.APILEVEL, Constraint.CLASS, Constraint.PACKAGE, Constraint.APP_PACKAGE, Constraint.MODULE, Constraint.LAYOUT, Constraint.DRAWABLE, Constraint.ID, Constraint.SOURCE_SET_FOLDER, Constraint.STRING, Constraint.URI_AUTHORITY});
    public final TemplateMetadata template;
    @NotNull
    public final Type type;
    @Nullable
    public final String id;
    @Nullable
    public final String name;
    @Nullable
    public final String initial;
    @Nullable
    public final String suggest;
    @Nullable
    public final String visibility;
    @Nullable
    public final String enabled;
    @Nullable
    public final String help;
    @NotNull
    public final Element element;
    @NotNull
    public final EnumSet<Constraint> constraints;

    private static Logger getLog() {
        return Logger.getInstance(Parameter.class);
    }

    Parameter(@NotNull TemplateMetadata template, @NotNull Element parameter) {
        if (template == null) {
            Parameter.$$$reportNull$$$0(0);
        }
        if (parameter == null) {
            Parameter.$$$reportNull$$$0(1);
        }
        this.template = template;
        this.element = parameter;
        String typeName = parameter.getAttribute("type");
        assert (typeName != null && !typeName.isEmpty()) : "type";
        this.type = Type.get(typeName);
        this.id = parameter.getAttribute("id");
        this.initial = parameter.getAttribute("default");
        this.suggest = parameter.getAttribute("suggest");
        this.visibility = parameter.getAttribute("visibility");
        this.enabled = parameter.getAttribute("enabled");
        this.name = parameter.getAttribute("name");
        this.help = parameter.getAttribute("help");
        String constraintString = parameter.getAttribute("constraints");
        if (constraintString != null && !constraintString.isEmpty()) {
            ArrayList constraintsList = Lists.newArrayListWithExpectedSize((int)1);
            for (String s : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)constraintString)) {
                constraintsList.add(Constraint.get(s));
            }
            this.constraints = EnumSet.copyOf(constraintsList);
        } else {
            this.constraints = EnumSet.noneOf(Constraint.class);
        }
    }

    public List<Element> getOptions() {
        return TemplateUtils.getChildren(this.element);
    }

    @Nullable
    public String validate(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable Object value, Set<Object> relatedValues) {
        switch (this.type) {
            case STRING: {
                return this.getErrorMessageForStringType(project, module, provider, packageName, String.valueOf(value), relatedValues);
            }
        }
        return null;
    }

    @Nullable
    private String getErrorMessageForStringType(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable String value, @Nullable Set<Object> relatedValues) {
        Collection<Constraint> violations = this.validateStringType(project, module, provider, packageName, value, relatedValues);
        if (violations.contains((Object)Constraint.NONEMPTY)) {
            return "Please specify " + this.name;
        }
        if (violations.contains((Object)Constraint.ACTIVITY)) {
            return this.name + " is not set to a valid activity name";
        }
        if (!violations.contains((Object)Constraint.APILEVEL)) {
            if (violations.contains((Object)Constraint.CLASS)) {
                return this.name + " is not set to a valid class name";
            }
            if (violations.contains((Object)Constraint.PACKAGE)) {
                return this.name + " is not set to a valid package name";
            }
            if (violations.contains((Object)Constraint.MODULE)) {
                return this.name + " is not set to a valid module name";
            }
            if (violations.contains((Object)Constraint.APP_PACKAGE) && value != null) {
                String message = AndroidUtils.validateAndroidPackageName(value);
                if (message != null) {
                    return message;
                }
            } else if (violations.contains((Object)Constraint.LAYOUT) && value != null) {
                String resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.LAYOUT).getErrorText(value);
                if (resourceNameError != null) {
                    return this.name + " is not set to a valid resource name. " + resourceNameError;
                }
            } else if (violations.contains((Object)Constraint.DRAWABLE)) {
                String resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE).getErrorText(value);
                if (resourceNameError != null) {
                    return this.name + " is not set to a valid resource name: " + resourceNameError;
                }
            } else {
                String resourceNameError;
                if (violations.contains((Object)Constraint.ID)) {
                    return this.name + " is not set to a valid id.";
                }
                if (violations.contains((Object)Constraint.STRING)) {
                    String resourceNameError2 = IdeResourceNameValidator.forFilename(ResourceFolderType.VALUES).getErrorText(value);
                    if (resourceNameError2 != null) {
                        return this.name + " is not set to a valid resource name: " + resourceNameError2;
                    }
                } else if (violations.contains((Object)Constraint.VALUES) && (resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.VALUES).getErrorText(value)) != null) {
                    return this.name + " is not set to a valid resource name: " + resourceNameError;
                }
            }
        }
        if (violations.contains((Object)Constraint.UNIQUE)) {
            return this.name + " must be unique";
        }
        if (violations.contains((Object)Constraint.EXISTS)) {
            return this.name + " must already exist";
        }
        if (violations.contains((Object)Constraint.URI_AUTHORITY)) {
            return this.name + " must be a valid URI authority";
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    Collection<Constraint> validateStringType(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable String value, @Nullable Set<Object> relatedValues) {
        String modulePath;
        AndroidFacet facet;
        String resourceNameError;
        GlobalSearchScope searchScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.EMPTY_SCOPE;
        HashSet violations = Sets.newHashSet();
        if (value == null || value.isEmpty()) {
            if (this.constraints.contains((Object)Constraint.NONEMPTY)) {
                violations.add(Constraint.NONEMPTY);
            }
            HashSet hashSet = violations;
            if (hashSet == null) {
                Parameter.$$$reportNull$$$0(2);
            }
            return hashSet;
        }
        boolean exists = false;
        String fqName = (packageName != null && value.indexOf(46) == -1 ? packageName + "." : "") + value;
        if (this.constraints.contains((Object)Constraint.ACTIVITY)) {
            if (!Parameter.isValidFullyQualifiedJavaIdentifier(fqName)) {
                violations.add(Constraint.ACTIVITY);
            }
            if (project != null) {
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqName, searchScope);
                PsiClass activityClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", GlobalSearchScope.allScope((Project)project));
                boolean bl = exists = aClass != null && activityClass != null && aClass.isInheritor(activityClass, true);
            }
        }
        if (this.constraints.contains((Object)Constraint.APILEVEL)) {
            // empty if block
        }
        if (this.constraints.contains((Object)Constraint.CLASS)) {
            if (!Parameter.isValidFullyQualifiedJavaIdentifier(fqName)) {
                violations.add(Constraint.CLASS);
            }
            if (project != null) {
                exists = Parameter.existsClassFile(project, searchScope, provider, fqName);
            }
        }
        if (this.constraints.contains((Object)Constraint.PACKAGE)) {
            if (!Parameter.isValidFullyQualifiedJavaIdentifier(value)) {
                violations.add(Constraint.PACKAGE);
            }
            if (project != null) {
                exists = Parameter.existsPackage(project, provider, value);
            }
        }
        if (this.constraints.contains((Object)Constraint.MODULE) && project != null) {
            boolean bl = exists = ModuleManager.getInstance((Project)project).findModuleByName(value) != null;
        }
        if (this.constraints.contains((Object)Constraint.APP_PACKAGE)) {
            String message = AndroidUtils.validateAndroidPackageName(value);
            if (message != null) {
                violations.add(Constraint.APP_PACKAGE);
            }
            if (project != null) {
                exists = Parameter.existsPackage(project, provider, value);
            }
        }
        if (this.constraints.contains((Object)Constraint.LAYOUT)) {
            resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.LAYOUT).getErrorText(value);
            if (resourceNameError != null) {
                violations.add(Constraint.LAYOUT);
            }
            boolean bl = exists = provider != null ? Parameter.existsResourceFile(provider, module, ResourceFolderType.LAYOUT, ResourceType.LAYOUT, value) : Parameter.existsResourceFile(module, ResourceType.LAYOUT, value);
        }
        if (this.constraints.contains((Object)Constraint.DRAWABLE)) {
            resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE).getErrorText(value);
            if (resourceNameError != null) {
                violations.add(Constraint.DRAWABLE);
            }
            boolean bl = exists = provider != null ? Parameter.existsResourceFile(provider, module, ResourceFolderType.DRAWABLE, ResourceType.DRAWABLE, value) : Parameter.existsResourceFile(module, ResourceType.DRAWABLE, value);
        }
        if (this.constraints.contains((Object)Constraint.ID)) {
            // empty if block
        }
        if (this.constraints.contains((Object)Constraint.VALUES)) {
            resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.VALUES).getErrorText(value);
            if (resourceNameError != null) {
                violations.add(Constraint.VALUES);
            }
            if (provider != null) {
                for (File resDir : provider.getResDirectories()) {
                    if (!Parameter.existsResourceFile(resDir, ResourceFolderType.VALUES, value)) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (this.constraints.contains((Object)Constraint.STRING) && (resourceNameError = IdeResourceNameValidator.forFilename(ResourceFolderType.VALUES).getErrorText(value)) != null) {
            violations.add(Constraint.STRING);
        }
        if (this.constraints.contains((Object)Constraint.SOURCE_SET_FOLDER) && module != null && (facet = AndroidFacet.getInstance(module)) != null && (modulePath = AndroidRootUtil.getModuleDirPath(module)) != null) {
            File file = new File(FileUtil.toSystemDependentName((String)modulePath), value);
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            boolean bl = exists = !IdeaSourceProvider.getSourceProvidersForFile(facet, vFile, null).isEmpty();
        }
        if (relatedValues != null && relatedValues.contains(value)) {
            exists = true;
        }
        if (this.constraints.contains((Object)Constraint.UNIQUE) && exists) {
            violations.add(Constraint.UNIQUE);
        } else if (this.constraints.contains((Object)Constraint.EXISTS) && !exists) {
            violations.add(Constraint.EXISTS);
        }
        if (this.constraints.contains((Object)Constraint.URI_AUTHORITY) && !value.matches("[a-zA-Z][a-zA-Z0-9-_.]*(:\\d+)?(;[a-zA-Z][a-zA-Z0-9-_.]*(:\\d+)?)*")) {
            violations.add(Constraint.URI_AUTHORITY);
        }
        HashSet hashSet = violations;
        if (hashSet == null) {
            Parameter.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public boolean uniquenessSatisfied(@Nullable Project project, @Nullable Module module, @Nullable SourceProvider provider, @Nullable String packageName, @Nullable String value, @Nullable Set<Object> relatedValues) {
        return !this.validateStringType(project, module, provider, packageName, value, relatedValues).contains((Object)Constraint.UNIQUE);
    }

    private static boolean isValidFullyQualifiedJavaIdentifier(String value) {
        return AndroidUtils.isValidJavaPackageName(value) && value.indexOf(46) != -1;
    }

    public static boolean existsResourceFile(@Nullable Module module, @NotNull ResourceType resourceType, @Nullable String name) {
        if (resourceType == null) {
            Parameter.$$$reportNull$$$0(4);
        }
        if (name == null || name.isEmpty() || module == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            AppResourceRepository repository = AppResourceRepository.getOrCreateInstance(facet);
            return repository.hasResourceItem(resourceType, name);
        }
        return false;
    }

    public static boolean existsResourceFile(@Nullable SourceProvider sourceProvider, @Nullable Module module, @NotNull ResourceFolderType resourceFolderType, @NotNull ResourceType resourceType, @Nullable String name) {
        if (resourceFolderType == null) {
            Parameter.$$$reportNull$$$0(5);
        }
        if (resourceType == null) {
            Parameter.$$$reportNull$$$0(6);
        }
        if (name == null || name.isEmpty() || sourceProvider == null) {
            return false;
        }
        AndroidFacet facet = module != null ? AndroidFacet.getInstance(module) : null;
        for (File resDir : sourceProvider.getResDirectories()) {
            ResourceFolderRepository folderRepository;
            List resourceItemList;
            VirtualFile virtualResDir;
            if (!(facet != null ? (virtualResDir = VfsUtil.findFileByIoFile((File)resDir, (boolean)false)) != null && (resourceItemList = (folderRepository = ResourceFolderRegistry.get(facet, virtualResDir)).getResourceItem(resourceType, name)) != null && !resourceItemList.isEmpty() : Parameter.existsResourceFile(resDir, resourceFolderType, name))) continue;
            return true;
        }
        return false;
    }

    public static boolean existsResourceFile(File resDir, ResourceFolderType resourceType, String name) {
        File[] resTypes = resDir.listFiles();
        if (resTypes != null) {
            for (File resTypeDir : resTypes) {
                File[] files;
                if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files = resTypeDir.listFiles()) == null) continue;
                for (File f : files) {
                    if (!Parameter.getNameWithoutExtensions(f).equalsIgnoreCase(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static String getNameWithoutExtensions(@NotNull File f) {
        if (f == null) {
            Parameter.$$$reportNull$$$0(7);
        }
        if (f.getName().indexOf(46) == -1) {
            String string = f.getName();
            if (string == null) {
                Parameter.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = f.getName().substring(0, f.getName().indexOf(46));
        if (string == null) {
            Parameter.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean existsClassFile(@Nullable Project project, @NotNull GlobalSearchScope searchScope, @Nullable SourceProvider sourceProvider, @NotNull String fullyQualifiedClassName) {
        if (searchScope == null) {
            Parameter.$$$reportNull$$$0(10);
        }
        if (fullyQualifiedClassName == null) {
            Parameter.$$$reportNull$$$0(11);
        }
        if (project == null) {
            return false;
        }
        if (sourceProvider != null) {
            for (File javaDir : sourceProvider.getJavaDirectories()) {
                String base;
                File javaFile = new File(javaDir, (base = fullyQualifiedClassName.replace('.', File.separatorChar)) + ".java");
                if (javaFile.exists()) {
                    return true;
                }
                File ktFile = new File(javaDir, base + ".kt");
                if (!ktFile.exists()) continue;
                return true;
            }
            return false;
        }
        if (searchScope != GlobalSearchScope.EMPTY_SCOPE) {
            return JavaPsiFacade.getInstance((Project)project).findClass(fullyQualifiedClassName, searchScope) != null;
        }
        return false;
    }

    private static boolean existsPackage(@Nullable Project project, @Nullable SourceProvider sourceProvider, @NotNull String packageName) {
        if (packageName == null) {
            Parameter.$$$reportNull$$$0(12);
        }
        if (project == null) {
            return false;
        }
        if (sourceProvider != null) {
            for (File javaDir : sourceProvider.getJavaDirectories()) {
                File classFile = new File(javaDir, packageName.replace('.', File.separatorChar));
                if (!classFile.exists() || !classFile.isDirectory()) continue;
                return true;
            }
            return false;
        }
        return JavaPsiFacade.getInstance((Project)project).findPackage(packageName) != null;
    }

    public boolean isRelated(Parameter p) {
        Sets.SetView types = Sets.intersection((Set)Sets.intersection(p.constraints, this.constraints), TYPE_CONSTRAINTS);
        return !types.isEmpty();
    }

    public String toString() {
        return "(parameter id: " + this.id + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/Parameter";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedClassName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/Parameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validateStringType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "existsResourceFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtensions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "existsClassFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "existsPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Constraint {
        UNIQUE,
        EXISTS,
        NONEMPTY,
        EMPTY,
        ACTIVITY,
        APILEVEL,
        CLASS,
        PACKAGE,
        APP_PACKAGE,
        MODULE,
        LAYOUT,
        DRAWABLE,
        VALUES,
        ID,
        SOURCE_SET_FOLDER,
        STRING,
        URI_AUTHORITY;


        public static Constraint get(@NotNull String name) {
            if (name == null) {
                Constraint.$$$reportNull$$$0(0);
            }
            name = name.toUpperCase(Locale.US);
            try {
                return Constraint.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                Parameter.getLog().error(String.format("Unexpected template constraint: %1$s.\nExpected one or more of: (%2$s)", name, Joiner.on((char)'|').join((Object[])Constraint.values())));
                return NONEMPTY;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/Parameter$Constraint", "get"));
        }
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        ENUM,
        SEPARATOR;


        public static Type get(@NotNull String name) {
            if (name == null) {
                Type.$$$reportNull$$$0(0);
            }
            name = name.toUpperCase(Locale.US);
            try {
                return Type.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                Parameter.getLog().error(String.format("Unexpected template type: %1$s.\nExpected one of: (%2$s)", name, Joiner.on((char)',').join((Object[])Constraint.values())));
                return STRING;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/Parameter$Type", "get"));
        }
    }
}

