/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes
implements Disposable {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;
    private final Object myLock;
    private DependencySet myMainDependencies;
    private DependencySet myUnitTestDependencies;
    private DependencySet myAndroidTestDependencies;
    private boolean myAlreadyResolved;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(1);
        }
        if (GradleSyncState.getInstance(project).lastSyncFailed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(2);
        }
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScope(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(3);
        }
        TestArtifactSearchScopes scopes = (androidModel = AndroidModuleModel.get(module)) != null ? new TestArtifactSearchScopes(module) : null;
        module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
    }

    private TestArtifactSearchScopes(@NotNull Module module) {
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(4);
        }
        this.myLock = new Object();
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
        module.putUserData(SEARCH_SCOPES_KEY, (Object)this);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(5);
        }
        return module;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(6);
        }
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(7);
        }
        return this.getUnitTestSourceScope().accept(file);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestSourceScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(8);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestSourceScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(9);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        if (artifactName == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(10);
        }
        Set<File> roots = Collections.emptySet();
        AndroidModuleModel androidModel = this.getAndroidModel();
        if (androidModel != null) {
            roots = new HashSet();
            if (artifactName.equals("_android_test_") && androidModel.getAndroidProject().getProjectType() == 2) {
                for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                    roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
                }
            } else {
                for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                    roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
                }
            }
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), roots);
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(11);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.merge(this.getAndroidTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(12);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(13);
        }
        return fileRootSearchScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        FileRootSearchScope fileRootSearchScope = this.mySharedTestsExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(14);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(15);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(16);
        }
        return fileRootSearchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        Set<File> excluded;
        if (artifactName == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(17);
        }
        if (this.getAndroidModel() == null) {
            FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
            if (fileRootSearchScope == null) {
                TestArtifactSearchScopes.$$$reportNull$$$0(18);
            }
            return fileRootSearchScope;
        }
        this.resolveDependencies();
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        Object object = this.myLock;
        synchronized (object) {
            DependencySet dependenciesToInclude = isAndroidTest ? this.myAndroidTestDependencies : this.myUnitTestDependencies;
            DependencySet dependenciesToExclude = isAndroidTest ? this.myUnitTestDependencies : this.myAndroidTestDependencies;
            ExcludedModules excludedModules = new ExcludedModules(this.myModule);
            excludedModules.add(dependenciesToExclude);
            excludedModules.remove(dependenciesToInclude);
            excludedModules.remove(this.myMainDependencies);
            ExcludedRoots excludedRoots = new ExcludedRoots(this.myModule, excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
            excludedRoots.removeLibraryPaths(this.myMainDependencies);
            excluded = excludedRoots.get();
        }
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(this.myModule.getProject(), excluded);
        if (fileRootSearchScope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(19);
        }
        return fileRootSearchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void resolveDependencies() {
        AndroidModuleModel androidModel = this.getAndroidModel();
        Object object = this.myLock;
        synchronized (object) {
            if (androidModel == null || this.myAlreadyResolved) {
                return;
            }
            this.myAlreadyResolved = true;
            this.extractMainDependencies(androidModel);
            this.extractAndroidTestDependencies(androidModel);
            this.extractUnitTestDependencies(androidModel);
            this.mergeSubmoduleDependencies(this.myMainDependencies, this.myMainDependencies, null, null);
            this.mergeSubmoduleDependencies(this.myAndroidTestDependencies, this.myAndroidTestDependencies, this.myAndroidTestDependencies, null);
            this.mergeSubmoduleDependencies(this.myUnitTestDependencies, this.myUnitTestDependencies, null, this.myUnitTestDependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMainDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(20);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myMainDependencies == null) {
                this.myMainDependencies = TestArtifactSearchScopes.extractDependencies(DependencyScope.COMPILE, androidModel.getMainArtifact());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractUnitTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(21);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnitTestDependencies == null) {
                IdeJavaArtifact artifact = androidModel.getSelectedVariant().getUnitTestArtifact();
                this.myUnitTestDependencies = TestArtifactSearchScopes.extractTestDependencies(artifact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAndroidTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(22);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myAndroidTestDependencies == null) {
                IdeAndroidArtifact artifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
                this.myAndroidTestDependencies = TestArtifactSearchScopes.extractTestDependencies(artifact);
            }
        }
    }

    @NotNull
    private static DependencySet extractTestDependencies(@Nullable IdeBaseArtifact artifact) {
        DependencySet dependencySet = TestArtifactSearchScopes.extractDependencies(DependencyScope.TEST, artifact);
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(23);
        }
        return dependencySet;
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull DependencyScope scope, @Nullable IdeBaseArtifact artifact) {
        if (scope == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(24);
        }
        DependencySet dependencySet = artifact != null ? DependenciesExtractor.getInstance().extractFrom(artifact, scope) : DependencySet.EMPTY;
        if (dependencySet == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(25);
        }
        return dependencySet;
    }

    @Nullable
    private AndroidModuleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidModuleModel.get(this.myModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeSubmoduleDependencies(@NotNull DependencySet original, @Nullable DependencySet toMergeMain, @Nullable DependencySet toMergeAndroid, @Nullable DependencySet toMergeUnit) {
        if (original == null) {
            TestArtifactSearchScopes.$$$reportNull$$$0(26);
        }
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>((Collection<ModuleDependency>)original.onModules());
        Object object = this.myLock;
        synchronized (object) {
            for (ModuleDependency moduleDependency : moduleDependencies) {
                TestArtifactSearchScopes moduleScope;
                Module module = moduleDependency.getModule(this.myModule.getProject());
                if (module == null || (moduleScope = TestArtifactSearchScopes.get(module)) == null) continue;
                moduleScope.resolveDependencies();
                if (toMergeMain != null) {
                    toMergeMain.addAll(moduleScope.myMainDependencies);
                }
                if (toMergeAndroid != null) {
                    toMergeAndroid.addAll(moduleScope.myAndroidTestDependencies);
                }
                if (toMergeUnit == null) continue;
                toMergeUnit.addAll(moduleScope.myUnitTestDependencies);
            }
        }
    }

    public void dispose() {
        this.myModule.putUserData(SEARCH_SCOPES_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getMainDependencies() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myMainDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getUnitTestDependencies() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myUnitTestDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getAndroidTestDependencies() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myAndroidTestDependencies;
        }
    }

    public String toString() {
        return this.myModule.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/TestArtifactSearchScopes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestSourceScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestSourceScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestExcludeScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestExcludeScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedTestsExcludeScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestDependencyExcludeScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestDependencyExcludeScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedDependenciesScope";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTestDependencies";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initializeScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidTestSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSourceScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedDependenciesScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractMainDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractUnitTestDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractAndroidTestDependencies";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "extractDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mergeSubmoduleDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

