/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.module.Module;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragHandler {
    @NotNull
    protected final ViewEditor editor;
    @NotNull
    protected final ViewGroupHandler handler;
    @NotNull
    protected final List<NlComponent> components;
    @NotNull
    protected SceneComponent layout;
    @NotNull
    protected DragType type;
    protected int startX;
    protected int startY;
    protected int lastX;
    protected int lastY;
    protected int lastModifiers;

    protected DragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            DragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            DragHandler.$$$reportNull$$$0(1);
        }
        if (layout == null) {
            DragHandler.$$$reportNull$$$0(2);
        }
        if (components == null) {
            DragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            DragHandler.$$$reportNull$$$0(4);
        }
        this.type = DragType.COPY;
        this.editor = editor;
        this.handler = handler;
        this.layout = layout;
        this.components = components;
        this.type = type;
    }

    public void setDragType(@NotNull DragType type) {
        if (type == null) {
            DragHandler.$$$reportNull$$$0(5);
        }
        this.type = type;
    }

    public void cancel() {
    }

    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            DragHandler.$$$reportNull$$$0(6);
        }
        this.insertComponents(-1, insertType);
    }

    public void start(int x, int y, int modifiers) {
        this.startX = x;
        this.startY = y;
        this.lastModifiers = modifiers;
    }

    @Nullable
    public String update(int x, int y, int modifiers) {
        this.lastX = x;
        this.lastY = y;
        this.lastModifiers = modifiers;
        return null;
    }

    public void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            DragHandler.$$$reportNull$$$0(7);
        }
    }

    protected final boolean canInsertComponents(int insertIndex, @NotNull InsertType insertType) {
        NlModel model;
        if (insertType == null) {
            DragHandler.$$$reportNull$$$0(8);
        }
        if (!(model = this.editor.getModel()).canAddComponents(this.components, this.layout.getNlComponent(), this.getChild(insertIndex))) {
            return false;
        }
        List<GradleCoordinate> dependencies2 = this.getMissingDependencies(this.components);
        if (dependencies2.isEmpty()) {
            return true;
        }
        return GradleDependencyManager.userWantToAddDependencies(model.getModule(), dependencies2);
    }

    protected final void insertComponents(int insertIndex, @NotNull InsertType insertType) {
        if (insertType == null) {
            DragHandler.$$$reportNull$$$0(9);
        }
        this.addMissingDependencies();
        this.editor.getModel().addComponents(this.components, this.layout.getNlComponent(), this.getChild(insertIndex), insertType);
    }

    private void addMissingDependencies() {
        List<GradleCoordinate> dependencies2 = this.getMissingDependencies(this.components);
        if (dependencies2.isEmpty()) {
            return;
        }
        Module module = this.editor.getModel().getModule();
        GradleBuildModel model = GradleBuildModel.get(module);
        if (model == null) {
            return;
        }
        GradleDependencyManager.addDependenciesInTransaction(model, module, dependencies2, null);
    }

    @Nullable
    private NlComponent getChild(int i) {
        return 0 <= i && i < this.layout.getChildCount() ? this.layout.getNlComponent().getChild(i) : null;
    }

    @NotNull
    private List<GradleCoordinate> getMissingDependencies(@NotNull Iterable<NlComponent> components) {
        if (components == null) {
            DragHandler.$$$reportNull$$$0(10);
        }
        HashSet artifacts = new HashSet();
        components.forEach(component2 -> NlComponentHelperKt.getDependencies(component2, artifacts));
        List<GradleCoordinate> dependencies2 = artifacts.stream().map(artifact -> GradleCoordinate.parseCoordinateString((String)(artifact + ":+"))).filter(Objects::nonNull).collect(Collectors.toList());
        if (dependencies2.isEmpty()) {
            List<GradleCoordinate> list = dependencies2;
            if (list == null) {
                DragHandler.$$$reportNull$$$0(11);
            }
            return list;
        }
        Module module = this.editor.getModel().getModule();
        List<GradleCoordinate> list = GradleDependencyManager.getInstance(module.getProject()).findMissingDependencies(module, dependencies2);
        if (list == null) {
            DragHandler.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/api/DragHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/api/DragHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDragType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canInsertComponents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insertComponents";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMissingDependencies";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

