/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.startup.DelayedInitialization;
import com.android.tools.idea.uibuilder.editor.AnimationToolbar;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.palette.NlPaletteDefinition;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewForm
implements Disposable,
CaretListener {
    public static final String PREVIEW_DESIGN_SURFACE = "NlPreviewFormDesignSurface";
    private final NlPreviewManager myManager;
    private final Project myProject;
    private final NlDesignSurface mySurface;
    private final WorkBench<DesignSurface> myWorkBench;
    private final MergingUpdateQueue myRenderingQueue = new MergingUpdateQueue("android.layout.preview.caret", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    private boolean myUseInteractiveSelector = true;
    private boolean myIgnoreListener;
    private RenderResult myRenderResult;
    private XmlFile myFile;
    private boolean isActive = true;
    private ActionsToolbar myActionsToolbar;
    private JComponent myContentPanel;
    private final AnimationToolbar myAnimationToolbar;
    private NlModel myModel;
    private Pending myPendingFile;
    private TextEditor myEditor;
    private CaretModel myCaretModel;
    private NlDesignSurface.ScreenMode myScreenMode;

    public NlPreviewForm(NlPreviewManager manager) {
        this.myManager = manager;
        this.myProject = this.myManager.getProject();
        this.mySurface = new NlDesignSurface(this.myProject, true, this);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.mySurface.setCentered(true);
        this.mySurface.setScreenMode(NlDesignSurface.ScreenMode.SCREEN_ONLY, false);
        this.mySurface.setName(PREVIEW_DESIGN_SURFACE);
        this.myRenderingQueue.setRestartTimerOnAdd(true);
        this.myAnimationToolbar = StudioFlags.NELE_ANIMATIONS_PREVIEW.get() != false ? new AnimationToolbar(this, timeMs -> {
            NlModel model;
            ScreenView screenView = this.mySurface.getCurrentSceneView();
            NlModel nlModel = model = screenView != null ? screenView.getModel() : null;
            if (model != null) {
                screenView.getSceneManager().setElapsedFrameTimeMs(timeMs);
                screenView.getSceneManager().requestRender();
            }
        }, 16L) : null;
        this.myWorkBench = new WorkBench(this.myProject, "Preview", null);
        this.myWorkBench.setLoadingText("Waiting for build to finish...");
        Disposer.register((Disposable)this, this.myWorkBench);
    }

    private void createContentPanel() {
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add((Component)this.mySurface, "Center");
        if (this.myAnimationToolbar != null) {
            this.myContentPanel.add((Component)this.myAnimationToolbar, "South");
        }
    }

    private void setEditor(@Nullable TextEditor editor) {
        if (editor != this.myEditor) {
            this.myEditor = editor;
            this.mySurface.setFileEditorDelegate((FileEditor)editor);
            if (this.myCaretModel != null) {
                this.myCaretModel.removeCaretListener((CaretListener)this);
                this.myCaretModel = null;
            }
            if (editor != null) {
                this.myCaretModel = this.myEditor.getEditor().getCaretModel();
                this.myCaretModel.addCaretListener((CaretListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaret() {
        int offset;
        ScreenView screenView;
        if (this.myCaretModel != null && !this.myIgnoreListener && this.myUseInteractiveSelector && (screenView = this.mySurface.getCurrentSceneView()) != null && (offset = this.myCaretModel.getOffset()) != -1) {
            ImmutableList<NlComponent> views = screenView.getModel().findByOffset(offset);
            if (views.isEmpty()) {
                views = screenView.getModel().getComponents();
            }
            try {
                this.myIgnoreListener = true;
                SelectionModel selectionModel = screenView.getSelectionModel();
                selectionModel.setSelection((List<NlComponent>)views);
                this.myRenderingQueue.queue(new Update("Preview update"){

                    public void run() {
                        NlPreviewForm.this.mySurface.repaint();
                    }

                    public boolean canEat(Update update) {
                        return true;
                    }
                });
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    @Nullable
    public JComponent getToolbarComponent() {
        return this.myActionsToolbar.getToolbarComponent();
    }

    @Nullable
    public XmlFile getFile() {
        return this.myFile;
    }

    @NotNull
    public JComponent getComponent() {
        WorkBench<DesignSurface> workBench = this.myWorkBench;
        if (workBench == null) {
            NlPreviewForm.$$$reportNull$$$0(0);
        }
        return workBench;
    }

    public void dispose() {
        this.deactivate();
        this.disposeActionsToolbar();
        if (this.myModel != null) {
            Disposer.dispose((Disposable)this.myModel);
            this.myModel = null;
        }
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myUseInteractiveSelector = useInteractiveSelector;
    }

    public void setFile(@Nullable PsiFile file) {
        XmlFile xmlFile;
        if (this.myAnimationToolbar != null) {
            this.myAnimationToolbar.stop();
        }
        if ((xmlFile = this.myManager.getBoundXmlFile(file)) == this.myFile) {
            return;
        }
        this.myFile = xmlFile;
        if (this.myPendingFile != null) {
            this.myPendingFile.invalidate();
        }
        if (this.myContentPanel == null && Projects.isBuildWithGradle(this.myProject)) {
            DelayedInitialization.getInstance(this.myProject).runAfterBuild(this::initPreviewForm, this::buildError);
        } else {
            this.initNeleModel();
        }
    }

    private void initPreviewForm() {
        UIUtil.invokeLaterIfNeeded(this::initPreviewFormOnEventDispatchThread);
    }

    private void buildError() {
        this.myWorkBench.loadingStopped("Preview is unavailable until a successful build");
    }

    private void initPreviewFormOnEventDispatchThread() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myContentPanel == null) {
            this.createContentPanel();
            this.myWorkBench.init(this.myContentPanel, (Object)this.mySurface, Collections.singletonList(new NlPaletteDefinition(this.myProject, Side.LEFT, Split.TOP, AutoHide.AUTO_HIDE)));
        }
        this.initNeleModel();
    }

    private void initNeleModel() {
        AndroidFacet facet;
        XmlFile xmlFile = this.myFile;
        AndroidFacet androidFacet = facet = xmlFile != null ? AndroidFacet.getInstance((PsiElement)xmlFile) : null;
        if (!this.isActive || facet == null || xmlFile.getVirtualFile() == null) {
            this.myPendingFile = null;
            this.setActiveModel(null);
        } else {
            Device device;
            if (this.myModel != null) {
                Disposer.dispose((Disposable)this.myModel);
            }
            this.myModel = NlModel.create(this.mySurface, null, facet, xmlFile);
            this.mySurface.setModel(this.myModel);
            this.myPendingFile = new Pending(xmlFile, this.myModel);
            if (this.myModel.getType() == NlLayoutType.ADAPTIVE_ICON && (device = this.myModel.getConfiguration().getDevice()) != null && !"Custom Density".equals(device.getId())) {
                NlModelHelperKt.overrideConfigurationDensity(this.myModel, Density.XXXHIGH);
            }
        }
    }

    public void setActiveModel(@Nullable NlModel model) {
        NlModel oldModel;
        this.myPendingFile = null;
        ScreenView currentScreenView = this.mySurface.getCurrentSceneView();
        if (currentScreenView != null && model != (oldModel = currentScreenView.getModel())) {
            oldModel.deactivate(this);
            Disposer.dispose((Disposable)oldModel);
        }
        if (model == null) {
            this.setEditor(null);
            this.disposeActionsToolbar();
            this.myWorkBench.setToolContext(null);
        } else {
            this.myFile = model.getFile();
            if (!this.mySurface.isCanvasResizing()) {
                this.mySurface.zoomToFit();
            } else {
                this.mySurface.updateScrolledAreaSize();
            }
            this.setEditor(this.myManager.getActiveLayoutXmlEditor((PsiFile)this.myFile));
            model.activate(this);
            this.myWorkBench.setToolContext((Object)this.mySurface);
            this.myWorkBench.setFileEditor((FileEditor)this.myEditor);
            this.disposeActionsToolbar();
            this.myActionsToolbar = new ActionsToolbar(this.mySurface);
            this.myActionsToolbar.setModel(model);
            this.myContentPanel.add((Component)this.myActionsToolbar.getToolbarComponent(), "North");
            if (!model.getType().isSupportedByDesigner()) {
                this.myScreenMode = this.mySurface.getScreenMode();
                this.mySurface.setScreenMode(NlDesignSurface.ScreenMode.SCREEN_ONLY, false);
                this.myWorkBench.setMinimizePanelsVisible(false);
            } else if (this.myScreenMode != null && this.mySurface.getScreenMode() == NlDesignSurface.ScreenMode.SCREEN_ONLY) {
                this.mySurface.setScreenMode(this.myScreenMode, false);
                this.myWorkBench.setMinimizePanelsVisible(true);
            }
        }
    }

    private void disposeActionsToolbar() {
        if (this.myActionsToolbar == null) {
            return;
        }
        this.myContentPanel.remove(this.myActionsToolbar.getToolbarComponent());
        Disposer.dispose((Disposable)this.myActionsToolbar);
        this.myActionsToolbar = null;
    }

    @Nullable
    public RenderResult getRenderResult() {
        return this.myRenderResult;
    }

    public void setRenderResult(@NotNull RenderResult renderResult) {
        if (renderResult == null) {
            NlPreviewForm.$$$reportNull$$$0(1);
        }
        this.myRenderResult = renderResult;
    }

    @NotNull
    public NlDesignSurface getSurface() {
        NlDesignSurface nlDesignSurface = this.mySurface;
        if (nlDesignSurface == null) {
            NlPreviewForm.$$$reportNull$$$0(2);
        }
        return nlDesignSurface;
    }

    public void caretPositionChanged(CaretEvent e) {
        if (!this.myIgnoreListener) {
            this.updateCaret();
        }
    }

    public void caretAdded(CaretEvent e) {
    }

    public void caretRemoved(CaretEvent e) {
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        if (this.myContentPanel != null) {
            this.initNeleModel();
        }
        this.mySurface.activate();
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        this.mySurface.deactivate();
        this.isActive = false;
        if (this.myContentPanel != null) {
            this.initNeleModel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRenderResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Pending
    implements ModelListener,
    Runnable {
        public final XmlFile file;
        public final NlModel model;
        public boolean valid = true;

        public Pending(XmlFile file, NlModel model) {
            this.file = file;
            this.model = model;
            model.addListener(this);
            ScreenView view = NlPreviewForm.this.mySurface.getCurrentSceneView();
            if (view != null) {
                view.getSceneManager().requestRender();
            }
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                Pending.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            if (model == null) {
                Pending.$$$reportNull$$$0(1);
            }
            model.removeListener(this);
            if (this.valid) {
                this.valid = false;
                ApplicationManager.getApplication().invokeLater((Runnable)this, model.getProject().getDisposed());
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            NlPreviewForm.this.setActiveModel(this.model);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm$Pending";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelRendered";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

