/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.SingleWidgetView;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;

public class WidgetConstraintPanel
extends JPanel {
    private static final String HORIZONTAL_TOOL_TIP_TEXT = "Horizontal Bias";
    private static final String VERTICAL_TOOL_TIP_TEXT = "Vertical Bias";
    private final SingleWidgetView mMain;
    private final JSlider mVerticalSlider;
    private final JSlider mHorizontalSlider;
    private boolean mConfiguringUI;
    NlComponent mComponent;
    private static final int UNCONNECTED = -1;
    private Runnable myWriteAction;
    private static final int SLIDER_DEFAULT = 50;
    public static final String VERTICAL_BIAS_SLIDER = "verticalBiasSlider";
    public static final String HORIZONTAL_BIAS_SLIDER = "horizontalBiasSlider";
    private static final int DELAY_BEFORE_COMMIT = 400;
    private Timer myTimer;
    private ChangeListener myChangeLiveListener;
    MouseListener mDoubleClickListener;
    private static final int CONNECTION_LEFT = 0;
    private static final int CONNECTION_RIGHT = 1;
    private static final int CONNECTION_TOP = 2;
    private static final int CONNECTION_BOTTOM = 3;
    private static final int CONNECTION_BASELINE = 4;
    private static String[][] ourConstraintString_ltr = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static String[][] ourConstraintString_rtl = new String[][]{{"layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static String[][] ourMarginString_ltr = new String[][]{{"layout_marginLeft", "layout_marginStart"}, {"layout_marginRight", "layout_marginEnd"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static String[][] ourMarginString_rtl = new String[][]{{"layout_marginLeft", "layout_marginEnd"}, {"layout_marginRight", "layout_marginStart"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static String[][] ourDeleteAttributes = new String[][]{{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_marginLeft", "layout_marginStart", "layout_constraintHorizontal_bias"}, {"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_marginRight", "layout_marginEnd", "layout_constraintHorizontal_bias"}, {"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_marginTop", "layout_constraintVertical_bias"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_marginBottom", "layout_constraintVertical_bias"}, {"layout_constraintBaseline_toBaselineOf"}};
    private static String[][] ourDeleteNamespace = new String[][]{{"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res-auto", "http://schemas.android.com/apk/res/android", "http://schemas.android.com/apk/res-auto"}, {"http://schemas.android.com/apk/res-auto"}};
    public static final int UNKNOWN = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public void setProperty(NlProperty property) {
        this.updateComponents(property.getComponents());
    }

    public void setAspect(String aspect) {
        this.setSherpaAttribute("layout_constraintDimensionRatio", aspect);
    }

    public WidgetConstraintPanel(@NotNull List<NlComponent> components) {
        if (components == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.mVerticalSlider = new JSlider(1);
        this.mHorizontalSlider = new JSlider(0);
        this.mConfiguringUI = false;
        this.myTimer = new Timer(400, c -> {
            if (this.myWriteAction != null) {
                ApplicationManager.getApplication().invokeLater(this.myWriteAction);
            }
        });
        this.myChangeLiveListener = e -> this.configureUI();
        this.mDoubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ((JSlider)e.getSource()).setValue(50);
                }
            }
        };
        super.setBorder(new EmptyBorder(4, 0, 0, 0));
        InspectorColorSet colorSet = new InspectorColorSet();
        this.setBackground(colorSet.getInspectorBackgroundColor());
        this.mMain = new SingleWidgetView(this, (ColorSet)colorSet);
        this.setPreferredSize(new Dimension(200, 216));
        this.mVerticalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setMajorTickSpacing(50);
        this.mVerticalSlider.setBackground(colorSet.getInspectorBackgroundColor());
        this.mHorizontalSlider.setBackground(colorSet.getInspectorBackgroundColor());
        this.mHorizontalSlider.setToolTipText(HORIZONTAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setToolTipText(VERTICAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setName(VERTICAL_BIAS_SLIDER);
        this.mHorizontalSlider.setName(HORIZONTAL_BIAS_SLIDER);
        this.updateComponents(components);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.add((Component)this.mVerticalSlider, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        this.add((Component)this.mMain, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        this.add((Component)this.mHorizontalSlider, gbc);
        this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, (ColorSet)colorSet));
        this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, (ColorSet)colorSet));
        this.mHorizontalSlider.addChangeListener(e -> this.setHorizontalBias());
        this.mVerticalSlider.addChangeListener(e -> this.setVerticalBias());
        this.mHorizontalSlider.addMouseListener(this.mDoubleClickListener);
        this.mVerticalSlider.addMouseListener(this.mDoubleClickListener);
    }

    private int getMargin(int type) {
        boolean rtl = ConstraintUtilities.isInRTL(this.mComponent);
        String[][] marginsAttr = rtl ? ourMarginString_rtl : ourMarginString_ltr;
        String marginString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][0]);
        for (int i = 1; marginString == null && marginsAttr[type].length > i; ++i) {
            marginString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", marginsAttr[type][i]);
        }
        int margin = 0;
        if (marginString != null) {
            margin = ConstraintUtilities.getDpValue(this.mComponent, marginString);
        }
        String[][] ourConstraintString = rtl ? ourConstraintString_rtl : ourConstraintString_ltr;
        String connection = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][0]);
        for (int i = 1; connection == null && i < ourConstraintString[type].length; ++i) {
            connection = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", ourConstraintString[type][i]);
        }
        if (connection == null) {
            margin = -1;
        }
        return margin;
    }

    private void configureUI() {
        float bias;
        NlComponent source;
        boolean showHorizontalSlider;
        if (this.mComponent == null) {
            return;
        }
        this.mConfiguringUI = true;
        String sherpaNamespace = "http://schemas.android.com/apk/res-auto";
        int top = this.getMargin(2);
        int left = this.getMargin(0);
        int right = this.getMargin(1);
        int bottom = this.getMargin(3);
        String ratioString = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintDimensionRatio");
        boolean baseline = this.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            source = WidgetConstraintPanel.findInHorizontalChain(this.mComponent);
            if (source == null) {
                source = this.mComponent;
            }
            String horizontalBias = source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias");
            bias = WidgetConstraintPanel.parseFloat(horizontalBias, 0.5f);
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
        }
        if (showVerticalSlider) {
            source = WidgetConstraintPanel.findInVerticalChain(this.mComponent);
            if (source == null) {
                source = this.mComponent;
            }
            String verticalBias = source.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias");
            bias = WidgetConstraintPanel.parseFloat(verticalBias, 0.5f);
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        int widthValue = this.convertFromNL("layout_width");
        int heightValue = this.convertFromNL("layout_height");
        this.mMain.configureUi(bottom, top, left, right, baseline, widthValue, heightValue, ratioString);
        this.mConfiguringUI = false;
    }

    private static float parseFloat(String string, float defaultValue) {
        if (string != null && !string.isEmpty()) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static int getDimension(NlComponent component2, String nameSpace, String attribute) {
        String v = component2.getLiveAttribute(nameSpace, attribute);
        if ("wrap_content".equalsIgnoreCase(v)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(component2, v);
    }

    private void setDimension(NlComponent component2, String attribute, int currentValue) {
        String marginString = component2.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = ConstraintComponentUtilities.getDpValue(component2, component2.getLiveAttribute("http://schemas.android.com/apk/res/android", attribute));
        }
        if (marginValue != -1 && marginValue == currentValue) {
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
        } else {
            String marginY = String.format("%ddp", currentValue);
            this.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
        }
    }

    private void setAndroidAttribute(String attribute, String value) {
        this.setAttribute("http://schemas.android.com/apk/res/android", attribute, value);
    }

    private void setSherpaAttribute(String attribute, String value) {
        this.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value);
    }

    private void setAttribute(String nameSpace, String attribute, String value) {
        this.setAttribute(this.mComponent, nameSpace, attribute, value);
    }

    private void setAttribute(NlComponent component2, String nameSpace, String attribute, String value) {
        if (this.mConfiguringUI) {
            return;
        }
        NlModel model = component2.getModel();
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute(nameSpace, attribute, value);
        transaction.apply();
        model.notifyLiveUpdate(false);
        this.myTimer.setRepeats(false);
        this.myWriteAction = new NlWriteCommandAction(Collections.singletonList(component2), "Change Widget", () -> {
            AttributesTransaction transaction2 = component2.startAttributeTransaction();
            transaction2.setAttribute(nameSpace, attribute, value);
            transaction2.commit();
        });
        this.myTimer.restart();
    }

    private void removeAttribute(int type) {
        String label = "Constraint Disconnected";
        String[] attribute = ourDeleteAttributes[type];
        String[] namespace = ourDeleteNamespace[type];
        AttributesTransaction transaction = this.mComponent.startAttributeTransaction();
        for (int i = 0; i < attribute.length; ++i) {
            transaction.setAttribute(namespace[i], attribute[i], null);
        }
        ConstraintComponentUtilities.ensureHorizontalPosition(this.mComponent, transaction);
        ConstraintComponentUtilities.ensureVerticalPosition(this.mComponent, transaction);
        transaction.apply();
        NlWriteCommandAction.run(this.mComponent, label, transaction::commit);
    }

    private int convertFromNL(String attribute) {
        int dimen = WidgetConstraintPanel.getDimension(this.mComponent, "http://schemas.android.com/apk/res/android", attribute);
        switch (dimen) {
            default: {
                return 0;
            }
            case -1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private boolean hasBaseline() {
        return null != this.getSherpaAttribute("layout_constraintBaseline_toBaselineOf");
    }

    private String getSherpaAttribute(String attr) {
        return this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr);
    }

    public void updateComponents(@NotNull List<NlComponent> components) {
        if (components == null) {
            WidgetConstraintPanel.$$$reportNull$$$0(1);
        }
        NlComponent nlComponent = this.mComponent = components.isEmpty() ? null : components.get(0);
        if (this.mComponent != null) {
            this.mComponent.addLiveChangeListener(this.myChangeLiveListener);
            this.configureUI();
        }
    }

    public boolean isApplicable() {
        if (this.mComponent == null) {
            return false;
        }
        NlComponent parent = this.mComponent.getParent();
        return parent != null && NlComponentHelperKt.isOrHasSuperclass(parent, "android.support.constraint.ConstraintLayout");
    }

    private void killConstraint(ConstraintAnchor.Type type) {
        switch (type) {
            case LEFT: {
                this.removeAttribute(0);
                break;
            }
            case TOP: {
                this.removeAttribute(2);
                break;
            }
            case RIGHT: {
                this.removeAttribute(1);
                break;
            }
            case BOTTOM: {
                this.removeAttribute(3);
                break;
            }
            case BASELINE: {
                this.removeAttribute(4);
                break;
            }
        }
    }

    private void setHorizontalBias() {
        int biasVal = this.mHorizontalSlider.getValue();
        float bias = (float)biasVal / 100.0f;
        String biasString = biasVal == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintPanel.findInHorizontalChain(this.mComponent);
        if (chain != null && chain != this.mComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintHorizontal_bias", biasString);
        }
    }

    private static NlComponent findInHorizontalChain(NlComponent component2) {
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourLeftAttributes, component2) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes, component2)) {
            return ConstraintComponentUtilities.findChainHead(component2, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourRightAttributes);
        }
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes, component2) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourEndAttributes, ConstraintComponentUtilities.ourStartAttributes, component2)) {
            return ConstraintComponentUtilities.findChainHead(component2, ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes);
        }
        return null;
    }

    private static NlComponent findInVerticalChain(NlComponent component2) {
        if (ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, component2) || ConstraintComponentUtilities.isInChain(ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes, component2)) {
            return ConstraintComponentUtilities.findChainHead(component2, ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBottomAttributes);
        }
        return null;
    }

    private void setVerticalBias() {
        int biasVal = this.mVerticalSlider.getValue();
        float bias = 1.0f - (float)biasVal / 100.0f;
        String biasString = biasVal == 50 ? null : Float.toString(bias);
        NlComponent chain = WidgetConstraintPanel.findInVerticalChain(this.mComponent);
        if (chain != null && chain != this.mComponent) {
            this.setAttribute(chain, "http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasString);
        } else {
            this.setSherpaAttribute("layout_constraintVertical_bias", biasString);
        }
    }

    public void setTopMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginTop", margin);
    }

    public void setLeftMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginStart", margin);
    }

    public void setRightMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginEnd", margin);
    }

    public void setBottomMargin(int margin) {
        this.setDimension(this.mComponent, "layout_marginBottom", margin);
    }

    public void killTopConstraint() {
        this.killConstraint(ConstraintAnchor.Type.TOP);
    }

    public void killLeftConstraint() {
        this.killConstraint(ConstraintAnchor.Type.LEFT);
    }

    public void killRightConstraint() {
        this.killConstraint(ConstraintAnchor.Type.RIGHT);
    }

    public void killBottomConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BOTTOM);
    }

    public void killBaselineConstraint() {
        this.killConstraint(ConstraintAnchor.Type.BASELINE);
    }

    public void setHorizontalConstraint(int horizontalConstraint) {
        String width = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        assert (width != null);
        if (width.endsWith("dp") && !width.equals("0dp")) {
            this.mComponent.putClientProperty("layout_width", width);
        }
        switch (horizontalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_width", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.mComponent.getClientProperty("layout_width");
                if (oldValue == null) {
                    float dipValue = (float)this.mComponent.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                    oldValue = (int)(0.5f + (float)NlComponentHelperKt.getW(this.mComponent) / dipValue) + "dp";
                }
                this.setAndroidAttribute("layout_width", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_width", "wrap_content");
            }
        }
    }

    public void setVerticalConstraint(int verticalConstraint) {
        String height = this.mComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        assert (height != null);
        if (height.endsWith("dp") && !height.equals("0dp")) {
            this.mComponent.putClientProperty("layout_height", height);
        }
        switch (verticalConstraint) {
            case 1: {
                this.setAndroidAttribute("layout_height", "0dp");
                break;
            }
            case 0: {
                String oldValue = (String)this.mComponent.getClientProperty("layout_height");
                if (oldValue == null) {
                    float dipValue = (float)this.mComponent.getModel().getConfiguration().getDensity().getDpiValue() / 160.0f;
                    oldValue = (int)(0.5f + (float)NlComponentHelperKt.getH(this.mComponent) / dipValue) + "dp";
                }
                this.setAndroidAttribute("layout_height", oldValue);
                break;
            }
            case 2: {
                this.setAndroidAttribute("layout_height", "wrap_content");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "components";
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/WidgetConstraintPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateComponents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class WidgetSliderUI
    extends BasicSliderUI {
        static final int thumbSize = 22;
        private static Font sSmallFont = new Font("Helvetica", 0, 10);
        ColorSet mColorSet;

        WidgetSliderUI(JSlider s, ColorSet colorSet) {
            super(s);
            this.mColorSet = colorSet;
        }

        @Override
        protected Dimension getThumbSize() {
            return new Dimension(22, 22);
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.slider.isEnabled()) {
                super.paintTrack(g);
            }
        }

        @Override
        protected Color getShadowColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getHighlightColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getFocusColor() {
            return new Color(0, 0, 0, 0);
        }

        @Override
        public void paintThumb(Graphics g) {
            String percentText = this.slider.getOrientation() == 1 ? Integer.toString(100 - this.slider.getValue()) : Integer.toString(this.slider.getValue());
            if (!this.slider.isEnabled()) {
                return;
            }
            g.setColor(this.mColorSet.getInspectorFillColor());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2, this.thumbRect.width - 2, this.thumbRect.height - 2);
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawRoundRect(this.thumbRect.x + 1, this.thumbRect.y + 1, this.thumbRect.width - 2, this.thumbRect.height - 2, this.thumbRect.width - 2, this.thumbRect.height - 2);
            int x = this.thumbRect.x + this.thumbRect.width / 2;
            int y = this.thumbRect.y + this.thumbRect.height / 2 - 1;
            g.setFont(sSmallFont);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(percentText, g);
            double tw = bounds.getWidth();
            g.setColor(this.mColorSet.getInspectorStrokeColor());
            g.drawString(percentText, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        }
    }

    static class InspectorColorSet
    extends BlueprintColorSet {
        InspectorColorSet() {
            this.mDrawBackground = false;
            this.mDrawWidgetInfos = true;
            this.mInspectorBackgroundColor = new JBColor(0xE8E8E8, 3948353);
            this.mInspectorFillColor = new JBColor(0xDCDCDC, 4540746);
            this.mInspectorHighlightsStrokeColor = JBColor.border();
            this.mInspectorStrokeColor = JBColor.foreground();
            this.mInspectorConstraintColor = new JBColor(4489688, 4751560);
        }
    }
}

