/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.splitter.ComponentsSplitter;
import com.android.tools.adtui.splitter.SplitterUtil;
import com.android.tools.adtui.treegrid.TreeGrid;
import com.android.tools.adtui.workbench.StartFilteringListener;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.actions.ComponentHelpAction;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.ItemTransferHandler;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.palette.SelectionListener;
import com.android.tools.idea.uibuilder.palette.SingleListTreeProvider;
import com.android.tools.idea.uibuilder.palette.TreeCategoryProvider;
import com.android.tools.idea.uibuilder.palette.TreeProvider;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteTreeGrid
extends JPanel
implements Disposable {
    static final String PALETTE_CATEGORY_WIDTH = "palette.category.width";
    static final int DEFAULT_CATEGORY_WIDTH = 100;
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 20;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 40;
    private final Project myProject;
    private final DependencyManager myDependencyManager;
    private final Runnable myCloseAutoHideCallback;
    private final JList<Palette.Group> myCategoryList;
    private final TreeGrid<Palette.Item> myTree;
    private final MyFilter myFilter;
    private final IconPreviewFactory myIconPreviewFactory;
    private final ComponentsSplitter mySplitter;
    private PaletteMode myMode;
    private SelectionListener myListener;
    private NlDesignSurface mySurface;
    private Palette myPalette;
    private StartFilteringListener myStartFilteringCallback;

    public NlPaletteTreeGrid(@NotNull Project project, @NotNull PaletteMode initialMode, @NotNull DependencyManager dependencyManager, @NotNull Runnable closeAutoHideCallback, @Nullable NlDesignSurface designSurface, @NotNull IconPreviewFactory iconFactory) {
        if (project == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(0);
        }
        if (initialMode == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(1);
        }
        if (dependencyManager == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(2);
        }
        if (closeAutoHideCallback == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(3);
        }
        if (iconFactory == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myDependencyManager = dependencyManager;
        this.myCloseAutoHideCallback = closeAutoHideCallback;
        this.mySurface = designSurface;
        this.myMode = initialMode;
        this.myIconPreviewFactory = iconFactory;
        this.myTree = NlPaletteTreeGrid.createItemTreeGrid(project);
        this.myTree.addListSelectionListener(event -> this.fireSelectionChanged((Palette.Item)this.myTree.getSelectedElement()));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                NlPaletteTreeGrid.this.handleKeyEvent(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$1", "keyTyped"));
            }
        });
        this.myCategoryList = new JBList();
        this.myCategoryList.setBackground(UIUtil.getPanelBackground());
        this.myCategoryList.setForeground(UIManager.getColor("Panel.foreground"));
        this.myCategoryList.addListSelectionListener(this::categorySelectionChanged);
        this.myCategoryList.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.myCategoryList.setCellRenderer((ListCellRenderer<Palette.Group>)((Object)new MyCategoryCellRenderer()));
        this.myFilter = new MyFilter();
        JScrollPane categoryPane = ScrollPaneFactory.createScrollPane(this.myCategoryList, (int)20, (int)31);
        categoryPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane paletteScrollPane = ScrollPaneFactory.createScrollPane(this.myTree, (int)20, (int)31);
        paletteScrollPane.setFocusable(false);
        paletteScrollPane.setBorder(BorderFactory.createEmptyBorder());
        paletteScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        paletteScrollPane.getVerticalScrollBar().setBlockIncrement(40);
        this.mySplitter = new ComponentsSplitter(false, true);
        this.mySplitter.setFirstComponent((JComponent)categoryPane);
        this.mySplitter.setInnerComponent((JComponent)paletteScrollPane);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstSize(JBUI.scale((int)NlPaletteTreeGrid.getInitialCategoryWidth()));
        this.mySplitter.setFocusCycleRoot(false);
        this.myCategoryList.addComponentListener(this.createCategoryWidthUpdater());
        SplitterUtil.setMinimumWidth((JComponent)categoryPane, (int)JBUI.scale((int)20));
        SplitterUtil.setMinimumWidth((JComponent)paletteScrollPane, (int)JBUI.scale((int)20));
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySplitter, "Center");
        this.setFocusTraversalPolicyProvider(true);
    }

    private static TreeGrid<Palette.Item> createItemTreeGrid(@NotNull Project project) {
        if (project == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(5);
        }
        TreeGrid grid = new TreeGrid();
        grid.setName("itemTreeGrid");
        ComponentHelpAction help = new ComponentHelpAction(project, () -> {
            Palette.Item item = (Palette.Item)grid.getSelectedElement();
            return item != null ? item.getTagName() : null;
        });
        help.registerCustomShortcutSet(112, 1, (JComponent)grid);
        return grid;
    }

    @Override
    public void requestFocus() {
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_PALETTE);
        this.myTree.requestFocus();
    }

    @NotNull
    public PaletteMode getMode() {
        PaletteMode paletteMode = this.myMode;
        if (paletteMode == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(6);
        }
        return paletteMode;
    }

    public void setMode(@NotNull PaletteMode mode) {
        if (mode == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(7);
        }
        this.myMode = mode;
        int fixedCellWidth = -1;
        int fixedCellHeight = -1;
        int border = JBUI.scale((int)mode.getBorder());
        int orientation = 2;
        switch (mode) {
            case ICON_AND_NAME: {
                orientation = 0;
                break;
            }
            case LARGE_ICONS: {
                fixedCellWidth = fixedCellHeight = border + JBUI.scale((int)24) + border;
                break;
            }
            case SMALL_ICONS: {
                fixedCellWidth = fixedCellHeight = border + JBUI.scale((int)16) + border;
            }
        }
        this.myTree.setFixedCellWidth(fixedCellWidth);
        this.myTree.setFixedCellHeight(fixedCellHeight);
        this.myTree.setLayoutOrientation(orientation);
        this.myTree.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer(this.myDependencyManager, mode)));
    }

    public void setStartFiltering(@NotNull StartFilteringListener listener) {
        if (listener == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(8);
        }
        this.myStartFilteringCallback = listener;
    }

    public void populateUiModel(@NotNull Palette palette, @NotNull NlDesignSurface designSurface) {
        if (palette == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(9);
        }
        if (designSurface == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(10);
        }
        this.mySurface = designSurface;
        this.myPalette = palette;
        this.myCategoryList.setModel(new TreeCategoryProvider(palette));
        if (this.myCategoryList.getSelectedValue() == null) {
            this.myCategoryList.setSelectedValue(TreeCategoryProvider.ALL, true);
        }
        this.updateTreeModel();
    }

    private void updateTreeModel() {
        AbstractTreeStructure provider = this.myCategoryList.getModel().getSize() > 1 && this.myFilter.getPattern().isEmpty() ? new TreeProvider(this.myProject, this.myPalette) : new SingleListTreeProvider(this.myProject, this.myPalette);
        this.myTree.setModel(provider);
        this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
        this.myTree.setTransferHandler((TransferHandler)new MyItemTransferHandler(this.mySurface, this.myDependencyManager, this::getSelectedItem, this.myIconPreviewFactory));
        this.setMode(this.myMode);
    }

    public void setFilter(@NotNull String pattern) {
        if (pattern == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(11);
        }
        String oldPattern = this.myFilter.getPattern();
        this.myFilter.setPattern(pattern);
        if (pattern.isEmpty()) {
            if (!oldPattern.isEmpty()) {
                this.updateTreeModel();
                this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
            }
            this.myTree.setFilter(null);
        } else {
            if (oldPattern.isEmpty()) {
                this.updateTreeModel();
                this.myTree.setVisibleSection((Object)TreeCategoryProvider.ALL.getName());
            }
            this.myTree.setFilter((Condition)this.myFilter);
            this.myTree.selectIfUnique();
        }
    }

    @NotNull
    public String getFilter() {
        String string = this.myFilter.getPattern();
        if (string == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void categorySelectionChanged(@Nullable ListSelectionEvent event) {
        if (this.myFilter.getPattern().isEmpty()) {
            this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
            Palette.Item selected = (Palette.Item)this.myTree.getSelectedVisibleElement();
            if (selected == null) {
                this.myTree.getFocusRecipient();
            }
        }
    }

    public void setSelectionListener(@NotNull SelectionListener listener) {
        if (listener == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(13);
        }
        this.myListener = listener;
    }

    public void fireSelectionChanged(@Nullable Palette.Item item) {
        if (this.myListener != null) {
            this.myListener.selectionChanged(item);
        }
    }

    public void handleKeyEvent(@NotNull KeyEvent event) {
        if (event == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(14);
        }
        if (this.myStartFilteringCallback != null) {
            this.myStartFilteringCallback.startFiltering(event.getKeyChar());
        }
    }

    @Nullable
    public Palette.Item getSelectedItem() {
        return (Palette.Item)this.myTree.getSelectedElement();
    }

    @NotNull
    private ComponentListener createCategoryWidthUpdater() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                PropertiesComponent.getInstance().setValue(NlPaletteTreeGrid.PALETTE_CATEGORY_WIDTH, String.valueOf(AdtUiUtils.unscale((int)NlPaletteTreeGrid.this.mySplitter.getFirstSize())));
            }
        };
        if (componentAdapter == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(15);
        }
        return componentAdapter;
    }

    private static int getInitialCategoryWidth() {
        try {
            return Integer.parseInt(PropertiesComponent.getInstance().getValue(PALETTE_CATEGORY_WIDTH, String.valueOf(100)));
        }
        catch (NumberFormatException unused) {
            return 100;
        }
    }

    @NotNull
    public JList<Palette.Group> getCategoryList() {
        JList<Palette.Group> jList = this.myCategoryList;
        if (jList == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(16);
        }
        return jList;
    }

    @NotNull
    public TreeGrid<Palette.Item> getComponentTree() {
        TreeGrid<Palette.Item> treeGrid = this.myTree;
        if (treeGrid == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(17);
        }
        return treeGrid;
    }

    @NotNull
    public ComponentsSplitter getSplitter() {
        ComponentsSplitter componentsSplitter = this.mySplitter;
        if (componentsSplitter == null) {
            NlPaletteTreeGrid.$$$reportNull$$$0(18);
        }
        return componentsSplitter;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeAutoHideCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFactory";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCategoryWidthUpdater";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTree";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createItemTreeGrid";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStartFiltering";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateUiModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFilter
    implements Condition<Palette.Item> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern = "";

        public void setPattern(@NotNull String filter) {
            if (filter == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            this.myPattern = filter;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean value(@NotNull Palette.Item item) {
            if (item == null) {
                MyFilter.$$$reportNull$$$0(2);
            }
            return this.myComparator.matchingFragments(this.myPattern, item.getTitle()) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFilter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setPattern";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "value";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer<Palette.Item> {
        private final DependencyManager myDependencyManager;
        private final PaletteMode myMode;

        private MyCellRenderer(@NotNull DependencyManager dependencyManager, @NotNull PaletteMode mode) {
            if (dependencyManager == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                MyCellRenderer.$$$reportNull$$$0(1);
            }
            this.myDependencyManager = dependencyManager;
            this.myMode = mode;
            int padding = mode.getBorder();
            this.setIpad((Insets)new JBInsets(padding, Math.max(4, padding), padding, padding));
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        protected void customizeCellRenderer(@NotNull JList list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MyCellRenderer.$$$reportNull$$$0(2);
            }
            if (item == null) {
                MyCellRenderer.$$$reportNull$$$0(3);
            }
            if (selected) {
                this.setBackground(UIUtil.getTreeSelectionBackground((boolean)hasFocus));
                this.mySelectionForeground = UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus);
            }
            switch (this.myMode) {
                case ICON_AND_NAME: {
                    this.setIcon(this.myDependencyManager.createItemIcon(item, list));
                    this.append(item.getTitle());
                    break;
                }
                case LARGE_ICONS: {
                    this.setIcon(this.myDependencyManager.createLargeItemIcon(item, list));
                    this.setToolTipText(item.getTitle());
                    break;
                }
                case SMALL_ICONS: {
                    this.setIcon(this.myDependencyManager.createItemIcon(item, list));
                    this.setToolTipText(item.getTitle());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCategoryCellRenderer
    extends ColoredListCellRenderer<Palette.Group> {
        private MyCategoryCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, @NotNull Palette.Group group, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MyCategoryCellRenderer.$$$reportNull$$$0(0);
            }
            if (group == null) {
                MyCategoryCellRenderer.$$$reportNull$$$0(1);
            }
            if (selected) {
                this.setBackground(UIUtil.getTreeSelectionBackground((boolean)hasFocus));
                this.mySelectionForeground = UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus);
            }
            this.append(group.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyCategoryCellRenderer";
            objectArray[2] = "customizeCellRenderer";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyItemTransferHandler
    extends ItemTransferHandler {
        public MyItemTransferHandler(@NotNull DesignSurface designSurface, @NotNull DependencyManager dependencyManager, @NotNull Supplier<Palette.Item> itemSupplier, IconPreviewFactory iconPreviewFactory) {
            if (designSurface == null) {
                MyItemTransferHandler.$$$reportNull$$$0(0);
            }
            if (dependencyManager == null) {
                MyItemTransferHandler.$$$reportNull$$$0(1);
            }
            if (itemSupplier == null) {
                MyItemTransferHandler.$$$reportNull$$$0(2);
            }
            if (iconPreviewFactory == null) {
                MyItemTransferHandler.$$$reportNull$$$0(3);
            }
            super(designSurface, dependencyManager, itemSupplier, iconPreviewFactory);
        }

        @Override
        protected Transferable createTransferable(@NotNull JComponent component2) {
            if (component2 == null) {
                MyItemTransferHandler.$$$reportNull$$$0(4);
            }
            Transferable transferable = super.createTransferable(component2);
            NlPaletteTreeGrid.this.myCloseAutoHideCallback.run();
            return transferable;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data, int action) {
            DnDTransferComponent component2;
            if (source == null) {
                MyItemTransferHandler.$$$reportNull$$$0(5);
            }
            if (action != 0 && data != null && (component2 = this.getDndComponent(data)) != null) {
                NlUsageTrackerManager.getInstance(NlPaletteTreeGrid.this.mySurface).logDropFromPalette(component2.getTag(), component2.getRepresentation(), NlPaletteTreeGrid.this.myMode, this.getGroupName(), NlPaletteTreeGrid.this.myTree.getFilterMatchCount());
            }
        }

        @NotNull
        private String getGroupName() {
            Palette.Group group = (Palette.Group)NlPaletteTreeGrid.this.myCategoryList.getSelectedValue();
            String string = group != null ? group.getName() : "";
            if (string == null) {
                MyItemTransferHandler.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        private DnDTransferComponent getDndComponent(@NotNull Transferable data) {
            if (data == null) {
                MyItemTransferHandler.$$$reportNull$$$0(7);
            }
            try {
                ImmutableList<DnDTransferComponent> components;
                DnDTransferItem item = (DnDTransferItem)data.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                if (item != null && (components = item.getComponents()).size() == 1) {
                    return (DnDTransferComponent)components.get(0);
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getInstance(NlPaletteTreeGrid.class).warn("Could not un-serialize a transferable", (Throwable)ex);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "designSurface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemSupplier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconPreviewFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyItemTransferHandler";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteTreeGrid$MyItemTransferHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createTransferable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "exportDone";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDndComponent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

