/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableGroupItem;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.PTableModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPTable;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyTableBuilder;
import com.android.tools.idea.uibuilder.property.NlXmlPropertyBuilder;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.util.PropertiesMap;
import com.google.common.collect.Table;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.CausedFocusEvent;

public class NlPropertiesPanel
extends JPanel
implements ViewAllPropertiesAction.Model,
Disposable,
DataProvider,
DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    static final String PROPERTY_MODE = "properties.mode";
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 50;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 25;
    private final TableRowSorter<PTableModel> myRowSorter;
    private final MyFilter myFilter;
    private final MyFilterKeyListener myFilterKeyListener;
    private final PTable myTable;
    private final JPanel myTablePanel;
    private final PTableModel myModel;
    private final InspectorPanel myInspectorPanel;
    private final JBCardLayout myCardLayout;
    private final JPanel myCardPanel;
    private final PropertyChangeListener myPropertyChangeListener;
    private List<NlComponent> myComponents;
    private List<NlPropertyItem> myProperties;
    @NotNull
    private PropertiesViewMode myPropertiesViewMode;
    private Runnable myRestoreToolWindowCallback;

    public NlPropertiesPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlPropertiesPanel.$$$reportNull$$$0(1);
        }
        this(propertiesManager, parentDisposable, new NlPTable(new PTableModel()), null);
    }

    NlPropertiesPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable, @NotNull PTable table, @Nullable InspectorPanel inspectorPanel) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            NlPropertiesPanel.$$$reportNull$$$0(3);
        }
        if (table == null) {
            NlPropertiesPanel.$$$reportNull$$$0(4);
        }
        super(new BorderLayout());
        this.myPropertyChangeListener = this::scrollIntoView;
        this.setOpaque(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myRowSorter = new TableRowSorter();
        this.myFilter = new MyFilter();
        this.myFilterKeyListener = new MyFilterKeyListener();
        this.myModel = table.getModel();
        this.myTable = table;
        this.myTable.getEmptyText().setText("No selected component");
        JComponent fewerPropertiesLink = this.createViewAllPropertiesLinkPanel(false);
        fewerPropertiesLink.setBorder(BorderFactory.createEmptyBorder(8, 4, 2, 0));
        this.myTablePanel = new JPanel(new BorderLayout());
        this.myTablePanel.setVisible(false);
        this.myTablePanel.setBackground(this.myTable.getBackground());
        this.myTablePanel.add((Component)this.myTable, "North");
        this.myTablePanel.add((Component)fewerPropertiesLink, "South");
        this.myTablePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                NlPropertiesPanel.this.myTable.editingStopped(new ChangeEvent(NlPropertiesPanel.this.myTablePanel));
            }
        });
        this.myInspectorPanel = inspectorPanel != null ? inspectorPanel : new InspectorPanel(propertiesManager, parentDisposable, this.createViewAllPropertiesLinkPanel(true));
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myCardLayout = new JBCardLayout();
        this.myCardPanel = new JPanel((LayoutManager)this.myCardLayout);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myInspectorPanel, (int)20, (int)31);
        scrollPane.setBorder(null);
        this.myCardPanel.add(PropertiesViewMode.INSPECTOR.name(), scrollPane);
        JScrollPane tableScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTablePanel);
        tableScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        tableScrollPane.getVerticalScrollBar().setBlockIncrement(25);
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myCardPanel.add(PropertiesViewMode.TABLE.name(), tableScrollPane);
        this.myPropertiesViewMode = NlPropertiesPanel.getPropertiesViewModeInitially();
        this.myCardLayout.show((Container)this.myCardPanel, this.myPropertiesViewMode.name());
        this.myComponents = Collections.emptyList();
        this.myProperties = Collections.emptyList();
        this.add((Component)this.myCardPanel, "Center");
    }

    public void dispose() {
        JBCardLayout layout = (JBCardLayout)this.myCardPanel.getLayout();
        layout.first((Container)this.myCardPanel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.myPropertyChangeListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.myPropertyChangeListener);
    }

    public void setRestoreToolWindow(@NotNull Runnable restoreToolWindowCallback) {
        if (restoreToolWindowCallback == null) {
            NlPropertiesPanel.$$$reportNull$$$0(5);
        }
        this.myRestoreToolWindowCallback = restoreToolWindowCallback;
    }

    public int getFilterMatchCount() {
        if (this.myTable.getRowSorter() == null) {
            return -1;
        }
        return this.myTable.getRowCount();
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            NlPropertiesPanel.$$$reportNull$$$0(6);
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        if (filter.isEmpty()) {
            this.myTable.setRowSorter(null);
        } else {
            this.myFilter.setPattern(filter);
            this.myRowSorter.setModel(this.myModel);
            this.myRowSorter.setRowFilter(this.myFilter);
            this.myRowSorter.setSortKeys(null);
            this.myTable.setRowSorter(this.myRowSorter);
        }
        this.myTable.restoreSelection(selectedRow, selectedItem);
        this.myInspectorPanel.setFilter(filter);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        MyFilterKeyListener myFilterKeyListener = this.myFilterKeyListener;
        if (myFilterKeyListener == null) {
            NlPropertiesPanel.$$$reportNull$$$0(7);
        }
        return myFilterKeyListener;
    }

    private void enterInFilter(@NotNull KeyEvent event) {
        PTableItem item;
        if (event == null) {
            NlPropertiesPanel.$$$reportNull$$$0(8);
        }
        if (!(this.myTable.getRowCount() == 1 || (item = (PTableItem)this.myTable.getValueAt(0, 1)).isExpanded() && this.myTable.getRowCount() == item.getChildren().size() + 1)) {
            return;
        }
        if (this.myTable.isCellEditable(0, 1)) {
            this.myTable.editCellAt(0, 1);
            this.myTable.transferFocus();
            event.consume();
        } else {
            this.myModel.expand(this.myTable.convertRowIndexToModel(0));
            this.myTable.requestFocus();
            this.myTable.setRowSelectionInterval(0, 0);
            event.consume();
        }
    }

    public void activatePropertySheet() {
        this.setAllPropertiesPanelVisible(true);
    }

    public void activateInspector() {
        this.setAllPropertiesPanelVisible(false);
    }

    public void setItems(@NotNull List<NlComponent> components, @NotNull Table<String, String, NlPropertyItem> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            NlPropertiesPanel.$$$reportNull$$$0(9);
        }
        if (properties == null) {
            NlPropertiesPanel.$$$reportNull$$$0(10);
        }
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(11);
        }
        this.myComponents = components;
        this.myProperties = NlPropertiesPanel.extractPropertiesForTable(properties);
        Project project = propertiesManager.getProject();
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor")) {
            this.myTablePanel.setVisible(new NlXmlPropertyBuilder(propertiesManager, this.myTable, components, properties).build());
        } else {
            this.myTablePanel.setVisible(new NlPropertyTableBuilder(project, this.myTable, components, this.myProperties).build());
        }
        this.updateDefaultProperties(propertiesManager);
        this.myInspectorPanel.setComponent(components, properties, propertiesManager);
    }

    @NotNull
    private static List<NlPropertyItem> extractPropertiesForTable(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlPropertiesPanel.$$$reportNull$$$0(12);
        }
        Map androidProperties = properties.row((Object)"http://schemas.android.com/apk/res/android");
        Map autoProperties = properties.row((Object)"http://schemas.android.com/apk/res-auto");
        Map designProperties = properties.row((Object)"http://schemas.android.com/tools");
        Map bareProperties = properties.row((Object)"");
        ArrayList<NlPropertyItem> result = new ArrayList<NlPropertyItem>(properties.size());
        result.addAll(autoProperties.values());
        for (Map.Entry entry : androidProperties.entrySet()) {
            if (autoProperties.containsKey(entry.getKey())) continue;
            result.add((NlPropertyItem)entry.getValue());
        }
        result.addAll(designProperties.values());
        result.addAll(bareProperties.values());
        ArrayList<NlPropertyItem> arrayList = result;
        if (arrayList == null) {
            NlPropertiesPanel.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public void modelRendered(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (propertiesManager == null) {
                NlPropertiesPanel.$$$reportNull$$$0(38);
            }
            if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor")) {
                propertiesManager.updateSelection();
            } else {
                this.updateDefaultProperties(propertiesManager);
            }
            this.myInspectorPanel.refresh();
        });
    }

    private void updateDefaultProperties(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(15);
        }
        if (this.myComponents.isEmpty() || this.myProperties.isEmpty()) {
            return;
        }
        PropertiesMap defaultValues = propertiesManager.getDefaultProperties(this.myComponents);
        if (defaultValues.isEmpty()) {
            return;
        }
        for (NlPropertyItem property : this.myProperties) {
            property.setDefaultValue(NlPropertiesPanel.getDefaultProperty(defaultValues, property));
        }
    }

    @Nullable
    private static PropertiesMap.Property getDefaultProperty(@NotNull PropertiesMap defaultValues, @NotNull NlProperty property) {
        if (defaultValues == null) {
            NlPropertiesPanel.$$$reportNull$$$0(16);
        }
        if (property == null) {
            NlPropertiesPanel.$$$reportNull$$$0(17);
        }
        if ("http://schemas.android.com/apk/res/android".equals(property.getNamespace())) {
            PropertiesMap.Property defaultValue = (PropertiesMap.Property)defaultValues.get((Object)("android:" + property.getName()));
            if (defaultValue != null) {
                return defaultValue;
            }
            return (PropertiesMap.Property)defaultValues.get((Object)("@android:" + property.getName()));
        }
        return (PropertiesMap.Property)defaultValues.get((Object)property.getName());
    }

    @NotNull
    private JComponent createViewAllPropertiesLinkPanel(boolean viewAllProperties) {
        HyperlinkLabel textLink = new HyperlinkLabel();
        textLink.setHyperlinkText(viewAllProperties ? "View all attributes" : "View fewer attributes");
        textLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        textLink.setFocusable(false);
        HyperlinkLabel iconLink = new HyperlinkLabel();
        iconLink.setIcon(StudioIcons.LayoutEditor.Properties.TOGGLE_PROPERTIES);
        iconLink.setFocusable(false);
        iconLink.setUseIconAsLink(true);
        iconLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        JPanel linkPanel = new JPanel(new FlowLayout(0, 0, 0));
        linkPanel.setOpaque(false);
        linkPanel.add((Component)textLink);
        linkPanel.add((Component)iconLink);
        JPanel jPanel = linkPanel;
        if (jPanel == null) {
            NlPropertiesPanel.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    private void setAllPropertiesPanelVisible(@NotNull HyperlinkEvent event, boolean viewAllProperties) {
        if (event == null) {
            NlPropertiesPanel.$$$reportNull$$$0(19);
        }
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setAllPropertiesPanelVisible(viewAllProperties);
        }
    }

    @Override
    public boolean isAllPropertiesPanelVisible() {
        return this.myPropertiesViewMode == PropertiesViewMode.TABLE;
    }

    @Override
    public void setAllPropertiesPanelVisible(boolean viewAllProperties) {
        Object next = viewAllProperties ? this.myTable : this.myInspectorPanel;
        this.setAllPropertiesPanelVisibleInternal(viewAllProperties, ((Component)next)::requestFocus);
    }

    private void setAllPropertiesPanelVisibleInternal(boolean viewAllProperties, @Nullable Runnable onDone) {
        this.myPropertiesViewMode = viewAllProperties ? PropertiesViewMode.TABLE : PropertiesViewMode.INSPECTOR;
        this.myCardLayout.swipe((Container)this.myCardPanel, this.myPropertiesViewMode.name(), JBCardLayout.SwipeDirection.AUTO, onDone);
        PropertiesComponent.getInstance().setValue(PROPERTY_MODE, this.myPropertiesViewMode.name());
    }

    @NotNull
    public PropertiesViewMode getPropertiesViewMode() {
        PropertiesViewMode propertiesViewMode = this.myPropertiesViewMode;
        if (propertiesViewMode == null) {
            NlPropertiesPanel.$$$reportNull$$$0(20);
        }
        return propertiesViewMode;
    }

    @NotNull
    private static PropertiesViewMode getPropertiesViewModeInitially() {
        PropertiesViewMode mode;
        String name = PropertiesComponent.getInstance().getValue(PROPERTY_MODE, PropertiesViewMode.INSPECTOR.name());
        try {
            mode = PropertiesViewMode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            mode = PropertiesViewMode.INSPECTOR;
            Logger.getInstance(NlPropertiesPanel.class).warn("There is no PropertiesViewMode called " + name + ", uses " + mode.name() + " instead", (Throwable)e);
            PropertiesComponent.getInstance().setValue(PROPERTY_MODE, mode.name());
        }
        PropertiesViewMode propertiesViewMode = mode;
        if (propertiesViewMode == null) {
            NlPropertiesPanel.$$$reportNull$$$0(21);
        }
        return propertiesViewMode;
    }

    public void activatePreferredEditor(@NotNull String propertyName, boolean afterload) {
        if (propertyName == null) {
            NlPropertiesPanel.$$$reportNull$$$0(22);
        }
        Runnable selectEditor = () -> {
            if (propertyName == null) {
                NlPropertiesPanel.$$$reportNull$$$0(37);
            }
            if (this.myRestoreToolWindowCallback != null) {
                this.myRestoreToolWindowCallback.run();
            }
            this.myInspectorPanel.activatePreferredEditor(propertyName, afterload);
        };
        if (!this.isAllPropertiesPanelVisible()) {
            selectEditor.run();
        } else {
            this.setAllPropertiesPanelVisibleInternal(false, selectEditor);
        }
    }

    private void scrollIntoView(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            NlPropertiesPanel.$$$reportNull$$$0(23);
        }
        if (this.needToScrollInView(event)) {
            Component newFocusedComponent = (Component)event.getNewValue();
            JComponent parent = (JComponent)newFocusedComponent.getParent();
            Rectangle bounds = newFocusedComponent.getBounds();
            if (newFocusedComponent == this.myTable) {
                bounds = this.myTable.getCellRect(this.myTable.getSelectedRow(), 1, true);
                bounds.x = 0;
            }
            parent.scrollRectToVisible(bounds);
        }
    }

    private boolean needToScrollInView(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            NlPropertiesPanel.$$$reportNull$$$0(24);
        }
        AWTEvent awtEvent = EventQueue.getCurrentEvent();
        if (!"focusOwner".equals(event.getPropertyName()) || !(event.getNewValue() instanceof Component)) {
            return false;
        }
        Component newFocusedComponent = (Component)event.getNewValue();
        if (!(this.isAncestorOf(newFocusedComponent) && newFocusedComponent.getParent() instanceof JComponent && awtEvent instanceof CausedFocusEvent)) {
            return false;
        }
        CausedFocusEvent focusEvent = (CausedFocusEvent)awtEvent;
        switch (focusEvent.getCause()) {
            case TRAVERSAL: 
            case TRAVERSAL_UP: 
            case TRAVERSAL_DOWN: 
            case TRAVERSAL_FORWARD: 
            case TRAVERSAL_BACKWARD: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public InspectorPanel getInspector() {
        InspectorPanel inspectorPanel = this.myInspectorPanel;
        if (inspectorPanel == null) {
            NlPropertiesPanel.$$$reportNull$$$0(25);
        }
        return inspectorPanel;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(26);
        }
        return false;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(27);
        }
        return false;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(28);
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(29);
        }
        return false;
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(30);
        }
        return false;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(31);
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(32);
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(33);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(34);
        }
        return false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(35);
        }
        return false;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(36);
        }
    }

    public PTable getTable() {
        return this.myTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoreToolWindowCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel";
                break;
            }
            case 8: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterKeyListener";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPropertiesForTable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewAllPropertiesLinkPanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesViewMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesViewModeInitially";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRestoreToolWindow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 25: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enterInFilter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractPropertiesForTable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setAllPropertiesPanelVisible";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "scrollIntoView";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "needToScrollInView";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$activatePreferredEditor$3";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modelRendered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFilterKeyListener
    extends KeyAdapter {
        private MyFilterKeyListener() {
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (event == null) {
                MyFilterKeyListener.$$$reportNull$$$0(0);
            }
            if (!NlPropertiesPanel.this.myFilter.myPattern.isEmpty() && event.getKeyCode() == 10 && event.getModifiers() == 0) {
                if (NlPropertiesPanel.this.myPropertiesViewMode == PropertiesViewMode.TABLE) {
                    NlPropertiesPanel.this.enterInFilter(event);
                } else {
                    NlPropertiesPanel.this.myInspectorPanel.enterInFilter(event);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFilterKeyListener", "keyPressed"));
        }
    }

    static class MyFilter
    extends RowFilter<PTableModel, Integer> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern = "";

        MyFilter() {
        }

        void setPattern(@NotNull String pattern) {
            if (pattern == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            this.myPattern = pattern;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends PTableModel, ? extends Integer> entry) {
            PTableItem item = (PTableItem)entry.getValue(0);
            if (this.isMatch(item.getName())) {
                return true;
            }
            if (item.getParent() != null && this.isMatch(item.getParent().getName())) {
                return true;
            }
            if (!(item instanceof PTableGroupItem)) {
                return false;
            }
            PTableGroupItem group = (PTableGroupItem)item;
            for (PTableItem child : group.getChildren()) {
                if (!this.isMatch(child.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean isMatch(@NotNull String text) {
            if (text == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            return this.myComparator.matchingFragments(this.myPattern, text) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PropertiesViewMode {
        TABLE,
        INSPECTOR;

    }
}

