/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.StarState;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableNameRenderer
extends PTableCellRenderer
implements PNameRenderer {
    private static final int BEFORE_STAR_SPACING = 2;
    private static final int STAR_SIZE = 16;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JLabel myStarLabel = new JBLabel();

    public NlTableNameRenderer() {
        this.myStarLabel.setPreferredSize(new Dimension(18, 16));
        this.myStarLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.myPanel.add((Component)this.myStarLabel, "West");
        this.myPanel.add((Component)((Object)this), "Center");
    }

    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            NlTableNameRenderer.$$$reportNull$$$0(0);
        }
        if (value == null) {
            NlTableNameRenderer.$$$reportNull$$$0(1);
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.myPanel.setBackground(this.getBackground());
        return this.myPanel;
    }

    @Nullable
    private static Icon getStar(@NotNull StarState state, boolean isSelected, boolean isHovering) {
        if (state == null) {
            NlTableNameRenderer.$$$reportNull$$$0(2);
        }
        switch (state) {
            case STARRED: {
                return isSelected ? StudioIcons.LayoutEditor.Properties.FAVORITES_SELECTED : StudioIcons.LayoutEditor.Properties.FAVORITES;
            }
            case STAR_ABLE: {
                return isHovering ? StudioIcons.LayoutEditor.Properties.FAVORITES_HOVER : null;
            }
        }
        return null;
    }

    protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem item, boolean selected, boolean hasFocus, int row, int col) {
        if (table == null) {
            NlTableNameRenderer.$$$reportNull$$$0(3);
        }
        if (item == null) {
            NlTableNameRenderer.$$$reportNull$$$0(4);
        }
        String label = item.getParent() != null ? item.getParent().getChildLabel(item) : item.getName();
        this.append(label, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setToolTipText(item.getTooltipText());
        Point hoverPos = table.getHoverPosition();
        boolean hoveringOnStar = table.isHover(row, col) && this.hitTestStarIcon(hoverPos.x, hoverPos.y);
        this.myStarLabel.setIcon(NlTableNameRenderer.getStar(item.getStarState(), selected, hoveringOnStar));
        this.setIcon(item, selected, hasFocus);
        this.setPaintFocusBorder(false);
        this.setFocusBorderAroundIcon(true);
    }

    private void setIcon(PTableItem item, boolean selected, boolean hasFocus) {
        int textGap;
        int indent;
        Icon icon;
        Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
        int beforeGroupIcon = NlTableNameRenderer.getBeforeIconSpacing(NlTableNameRenderer.getDepth(item), groupIcon.getIconWidth());
        int afterGroupIcon = NlTableNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
        if (item.hasChildren()) {
            icon = groupIcon;
            indent = beforeGroupIcon;
            textGap = afterGroupIcon;
        } else {
            icon = null;
            indent = beforeGroupIcon + groupIcon.getIconWidth() + afterGroupIcon;
            textGap = 0;
        }
        if ("http://schemas.android.com/tools".equals(item.getNamespace())) {
            if (icon == null) {
                icon = AndroidIcons.NeleIcons.DesignProperty;
            } else {
                LayeredIcon layered = new LayeredIcon(new Icon[]{icon, AndroidIcons.NeleIcons.DesignProperty});
                layered.setIcon(AndroidIcons.NeleIcons.DesignProperty, 1, afterGroupIcon + icon.getIconWidth(), 0);
                icon = layered;
            }
            textGap = 4;
        }
        super.setIcon(icon);
        this.setIconTextGap(textGap);
        this.setIpad((Insets)JBUI.insetsLeft((int)indent));
    }

    public boolean hitTestStarIcon(int x, int y) {
        return x >= 2 && x < 18;
    }

    public boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x, int y) {
        if (item == null) {
            NlTableNameRenderer.$$$reportNull$$$0(5);
        }
        Icon icon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = 18 + NlTableNameRenderer.getBeforeIconSpacing(NlTableNameRenderer.getDepth(item), icon.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        if (item == null) {
            NlTableNameRenderer.$$$reportNull$$$0(6);
        }
        int result = 0;
        while (item.getParent() != null) {
            ++result;
            item = item.getParent();
            assert (item != null);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/renderer/NlTableNameRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableCellRendererComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hitTestTreeNodeIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDepth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

