/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.Stack;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizard
implements Disposable {
    private final List<ModelWizardStep> mySteps;
    private final Map<ModelWizardStep, ModelWizardStep> myStepOwners;
    private final BindingsManager myBindings;
    private final BoolProperty myCanGoBack;
    private final BoolProperty myCanGoForward;
    private final BoolProperty myOnLastStep;
    private final OptionalProperty<Action> myExtraAction;
    private final Stack<ModelWizardStep> myPrevSteps;
    private final TitleHeader myTitleHeader;
    private final JPanel myContentPanel;
    private final List<WizardListener> myWizardListeners;
    private int myCurrIndex;

    private ModelWizard(@NotNull Collection<ModelWizardStep> steps) {
        boolean bl;
        if (steps == null) {
            ModelWizard.$$$reportNull$$$0(0);
        }
        this.myStepOwners = Maps.newHashMap();
        this.myBindings = new BindingsManager();
        this.myCanGoBack = new BoolValueProperty();
        this.myCanGoForward = new BoolValueProperty();
        this.myOnLastStep = new BoolValueProperty();
        this.myExtraAction = new OptionalValueProperty<Action>();
        this.myPrevSteps = new Stack();
        this.myTitleHeader = new TitleHeader();
        this.myContentPanel = new JPanel(new CardLayout());
        this.myWizardListeners = Lists.newArrayListWithExpectedSize((int)1);
        this.myCurrIndex = -1;
        this.mySteps = Lists.newArrayListWithExpectedSize((int)steps.size());
        for (ModelWizardStep modelWizardStep : steps) {
            this.addStep(modelWizardStep);
        }
        if (this.mySteps.isEmpty()) {
            throw new IllegalStateException("Can't create a wizard with no steps");
        }
        this.myCanGoForward.addListener(sender -> {
            if (((Boolean)this.myCanGoForward.get()).booleanValue()) {
                this.myOnLastStep.set(this.isOnLastVisibleStep());
            }
        });
        HashSet seenModels = Sets.newHashSet();
        for (ModelWizardStep modelWizardStep : this.mySteps) {
            Disposer.register((Disposable)this, (Disposable)modelWizardStep);
            Object model = modelWizardStep.getModel();
            if (seenModels.contains(model)) continue;
            Disposer.register((Disposable)this, model);
            seenModels.add(model);
        }
        Facade facade = new Facade();
        for (ModelWizardStep step : this.mySteps) {
            step.onWizardStarting(facade);
        }
        boolean bl2 = false;
        for (ModelWizardStep step : this.mySteps) {
            if (!this.shouldShowStep(step)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.myCurrIndex = 1;
            Disposer.dispose((Disposable)this);
            throw new IllegalStateException("Trying to create a wizard but no steps are visible");
        }
        this.goForward();
    }

    @NotNull
    public ObservableBool canGoBack() {
        BoolProperty boolProperty = this.myCanGoBack;
        if (boolProperty == null) {
            ModelWizard.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myCanGoForward;
        if (boolProperty == null) {
            ModelWizard.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    @NotNull
    public ObservableBool onLastStep() {
        BoolProperty boolProperty = this.myOnLastStep;
        if (boolProperty == null) {
            ModelWizard.$$$reportNull$$$0(3);
        }
        return boolProperty;
    }

    @NotNull
    public TitleHeader getTitleHeader() {
        TitleHeader titleHeader = this.myTitleHeader;
        if (titleHeader == null) {
            ModelWizard.$$$reportNull$$$0(4);
        }
        return titleHeader;
    }

    @Nullable
    public JComponent getPreferredFocusComponent() {
        if (this.isFinished()) {
            return null;
        }
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        return step.getPreferredFocusComponent();
    }

    private void addStep(@NotNull ModelWizardStep<?> step) {
        if (step == null) {
            ModelWizard.$$$reportNull$$$0(5);
        }
        this.myContentPanel.add((Component)step.getComponent(), Integer.toString(this.mySteps.size()));
        this.mySteps.add(step);
        for (ModelWizardStep subStep : step.createDependentSteps()) {
            this.myStepOwners.put(subStep, step);
            this.addStep(subStep);
        }
    }

    @NotNull
    ModelWizardStep getCurrentStep() {
        ModelWizardStep modelWizardStep = this.mySteps.get(this.myCurrIndex);
        if (modelWizardStep == null) {
            ModelWizard.$$$reportNull$$$0(6);
        }
        return modelWizardStep;
    }

    @NotNull
    ObservableOptional<Action> getExtraAction() {
        OptionalProperty<Action> optionalProperty = this.myExtraAction;
        if (optionalProperty == null) {
            ModelWizard.$$$reportNull$$$0(7);
        }
        return optionalProperty;
    }

    @NotNull
    public JPanel getContentPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            ModelWizard.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void goForward() {
        this.ensureWizardIsRunning();
        ModelWizardStep prevStep = null;
        if (this.myCurrIndex >= 0) {
            ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
            if (!((Boolean)currStep.canGoForward().get()).booleanValue()) {
                throw new IllegalStateException("Can't call goForward on wizard when the step prevents it");
            }
            prevStep = currStep;
            try {
                prevStep.onProceeding();
            }
            catch (Exception e) {
                for (WizardListener listener : this.getListeners()) {
                    listener.onWizardAdvanceError(e);
                }
                throw e;
            }
        }
        ModelWizardStep nextStep = null;
        int nextIndex = this.myCurrIndex;
        while (++nextIndex < this.mySteps.size()) {
            ModelWizardStep step = this.mySteps.get(nextIndex);
            if (!this.shouldShowStep(step)) continue;
            nextStep = step;
            break;
        }
        try {
            if (nextStep != null) {
                nextStep.onEntering();
            }
        }
        catch (Exception e) {
            for (WizardListener listener : this.getListeners()) {
                listener.onWizardAdvanceError(e);
            }
            throw e;
        }
        if (prevStep != null) {
            this.myPrevSteps.add((Object)prevStep);
        }
        if (nextStep != null) {
            this.myCurrIndex = nextIndex;
            this.updateNavigationProperties();
            this.showCurrentStep();
        } else {
            this.handleFinished(WizardResult.FINISHED);
        }
    }

    public void goBack() {
        this.ensureWizardIsRunning();
        if (this.myPrevSteps.empty()) {
            throw new IllegalStateException("Calling back on wizard without any previous pages");
        }
        ModelWizardStep currStep = this.mySteps.get(this.myCurrIndex);
        if (!currStep.canGoBack()) {
            throw new IllegalStateException("Can't call goBack on wizard when the step prevents it");
        }
        this.myCurrIndex = this.mySteps.indexOf(this.myPrevSteps.pop());
        this.updateNavigationProperties();
        this.showCurrentStep();
    }

    public void cancel() {
        this.ensureWizardIsRunning();
        this.handleFinished(WizardResult.CANCELLED);
    }

    public void addResultListener(@NotNull WizardListener listener) {
        if (listener == null) {
            ModelWizard.$$$reportNull$$$0(9);
        }
        this.myWizardListeners.add(listener);
    }

    public void removeResultListener(@NotNull WizardListener listener) {
        if (listener == null) {
            ModelWizard.$$$reportNull$$$0(10);
        }
        this.myWizardListeners.remove(listener);
    }

    public boolean isFinished() {
        return this.myCurrIndex >= this.mySteps.size();
    }

    private void ensureWizardIsRunning() {
        if (this.isFinished()) {
            throw new IllegalStateException("Invalid operation attempted after wizard already finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinished(@NotNull WizardResult result) {
        if (result == null) {
            ModelWizard.$$$reportNull$$$0(11);
        }
        try {
            if (result == WizardResult.FINISHED) {
                Object model;
                HashSet seenModels = Sets.newHashSet();
                for (ModelWizardStep step : this.myPrevSteps) {
                    model = step.getModel();
                    if (seenModels.contains(model)) continue;
                    seenModels.add(model);
                    ((WizardModel)model).handleFinished();
                }
                for (ModelWizardStep step : this.mySteps) {
                    model = step.getModel();
                    if (seenModels.contains(model)) continue;
                    seenModels.add(model);
                    ((WizardModel)model).handleSkipped();
                }
            }
        }
        finally {
            this.myCurrIndex = this.mySteps.size();
            this.myPrevSteps.clear();
            this.myCanGoBack.set(false);
            this.myCanGoForward.set(false);
            this.myOnLastStep.set(false);
            for (WizardListener listener : this.getListeners()) {
                listener.onWizardFinished(result);
            }
        }
    }

    private void showCurrentStep() {
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myTitleHeader.title().set(step.getTitle());
        this.myTitleHeader.stepIcon().setNullableValue(step.getIcon());
        this.myExtraAction.setNullableValue(step.getExtraAction());
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, Integer.toString(this.myCurrIndex));
        JComponent focusedComponent = step.getPreferredFocusComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    private void updateNavigationProperties() {
        this.myOnLastStep.set(this.isOnLastVisibleStep());
        ModelWizardStep step = this.mySteps.get(this.myCurrIndex);
        this.myBindings.bind(this.myCanGoForward, step.canGoForward());
        this.myCanGoBack.set(!this.myPrevSteps.empty() && step.canGoBack());
    }

    private boolean shouldShowStep(ModelWizardStep step) {
        ModelWizardStep currStep = step;
        do {
            if (currStep.shouldShow()) continue;
            return false;
        } while ((currStep = this.myStepOwners.get(currStep)) != null);
        return true;
    }

    private boolean isOnLastVisibleStep() {
        float size = this.mySteps.size();
        boolean currPageIsLast = true;
        int i = this.myCurrIndex + 1;
        while ((float)i < size) {
            ModelWizardStep step = this.mySteps.get(i);
            if (this.shouldShowStep(step)) {
                currPageIsLast = false;
                break;
            }
            ++i;
        }
        return currPageIsLast;
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myWizardListeners.clear();
    }

    private Iterable<WizardListener> getListeners() {
        return Lists.newArrayList(this.myWizardListeners);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "steps";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/model/ModelWizard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/model/ModelWizard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoBack";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "onLastStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleHeader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addStep";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addResultListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeResultListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public final class Facade {
        public void updateNavigationProperties() {
            if (ModelWizard.this.myCurrIndex < 0) {
                return;
            }
            ModelWizard.this.updateNavigationProperties();
        }

        public boolean goForward() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to goForward before the wizard has even started");
            }
            if (((Boolean)ModelWizard.this.canGoForward().get()).booleanValue()) {
                ModelWizard.this.goForward();
                return true;
            }
            return false;
        }

        public void cancel() {
            if (ModelWizard.this.myCurrIndex < 0) {
                throw new IllegalStateException("Attempting to cancel before the wizard has even started");
            }
            ModelWizard.this.cancel();
        }
    }

    public static final class TitleHeader {
        private final StringProperty myTitle = new StringValueProperty();
        private final OptionalValueProperty<Icon> myStepIcon = new OptionalValueProperty();

        @NotNull
        public StringProperty title() {
            StringProperty stringProperty = this.myTitle;
            if (stringProperty == null) {
                TitleHeader.$$$reportNull$$$0(0);
            }
            return stringProperty;
        }

        @NotNull
        public OptionalValueProperty<Icon> stepIcon() {
            OptionalValueProperty<Icon> optionalValueProperty = this.myStepIcon;
            if (optionalValueProperty == null) {
                TitleHeader.$$$reportNull$$$0(1);
            }
            return optionalValueProperty;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/wizard/model/ModelWizard$TitleHeader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stepIcon";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class Builder {
        private final List<ModelWizardStep> mySteps;

        public Builder(ModelWizardStep ... steps) {
            if (steps == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.mySteps = Lists.newArrayList((Object[])steps);
        }

        public Builder addStep(@NotNull ModelWizardStep step) {
            if (step == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.mySteps.add(step);
            return this;
        }

        public ModelWizard build() {
            return new ModelWizard(this.mySteps);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "steps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/wizard/model/ModelWizard$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStep";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface WizardListener {
        default public void onWizardFinished(@NotNull WizardResult result) {
            if (result == null) {
                WizardListener.$$$reportNull$$$0(0);
            }
        }

        default public void onWizardAdvanceError(@NotNull Exception e) {
            if (e == null) {
                WizardListener.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/wizard/model/ModelWizard$WizardListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onWizardFinished";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onWizardAdvanceError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum WizardResult {
        FINISHED,
        CANCELLED;


        public boolean isFinished() {
            return this == FINISHED;
        }
    }
}

