/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.sdklib.IAndroidTarget;
import com.intellij.ProjectTopics;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPropertyFilesUpdater
extends AbstractProjectComponent {
    private static final NotificationGroup PROPERTY_FILES_UPDATING_NOTIFICATION = NotificationGroup.balloonGroup((String)"Android Property Files Updating");
    private static final Key<List<Object>> ANDROID_PROPERTIES_STATE_KEY = Key.create((String)"ANDROID_PROPERTIES_STATE");
    private Notification myNotification;
    private final SingleAlarm myAlarm;

    protected AndroidPropertyFilesUpdater(Project project) {
        super(project);
        this.myAlarm = new SingleAlarm(() -> TransactionGuard.submitTransaction((Disposable)project, this::updatePropertyFilesIfNecessary), 50, (Disposable)project);
    }

    public void initComponent() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.addProjectPropertiesUpdatingListener();
        }
    }

    public void disposeComponent() {
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            this.myNotification.expire();
        }
        this.myAlarm.cancel();
    }

    private void addProjectPropertiesUpdatingListener() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                StartupManager.getInstance((Project)AndroidPropertyFilesUpdater.this.myProject).runWhenProjectIsInitialized(() -> ((SingleAlarm)AndroidPropertyFilesUpdater.this.myAlarm).cancelAndRequest());
            }
        });
    }

    private void updatePropertyFilesIfNecessary() {
        if (this.myProject.isDisposed()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final ArrayList<Object> toAskFiles = new ArrayList<Object>();
        final ArrayList<AndroidFacet> toAskFacets = new ArrayList<AndroidFacet>();
        final ArrayList toAskChanges = new ArrayList();
        ArrayList<Object> files = new ArrayList<Object>();
        final ArrayList changes = new ArrayList();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            Pair<VirtualFile, List<Runnable>> pair;
            String updatePropertyFiles;
            boolean ask;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || facet.requiresAndroidModel() || !(ask = (updatePropertyFiles = facet.getProperties().UPDATE_PROPERTY_FILES).isEmpty()) && !Boolean.parseBoolean(updatePropertyFiles) || (pair = AndroidPropertyFilesUpdater.updateProjectPropertiesIfNecessary(facet)) == null) continue;
            if (ask) {
                toAskFacets.add(facet);
                toAskFiles.add(pair.getFirst());
                toAskChanges.addAll((Collection)pair.getSecond());
                continue;
            }
            files.add(pair.getFirst());
            changes.addAll((Collection)pair.getSecond());
        }
        if (this.myNotification != null && !this.myNotification.isExpired()) {
            this.myNotification.expire();
        }
        if (!changes.isEmpty() || !toAskChanges.isEmpty()) {
            if (!toAskChanges.isEmpty()) {
                this.askUserIfUpdatePropertyFile(this.myProject, toAskFacets, new Processor<MyResult>(){

                    public boolean process(MyResult result) {
                        if (result == MyResult.NEVER) {
                            for (AndroidFacet facet : toAskFacets) {
                                facet.getProperties().UPDATE_PROPERTY_FILES = Boolean.FALSE.toString();
                            }
                            return true;
                        }
                        if (result == MyResult.ALWAYS) {
                            for (AndroidFacet facet : toAskFacets) {
                                facet.getProperties().UPDATE_PROPERTY_FILES = Boolean.TRUE.toString();
                            }
                        }
                        if (ReadonlyStatusHandler.ensureFilesWritable((Project)AndroidPropertyFilesUpdater.this.myProject, (VirtualFile[])toAskFiles.toArray(new VirtualFile[toAskFiles.size()]))) {
                            CommandProcessor.getInstance().executeCommand(AndroidPropertyFilesUpdater.this.myProject, new Runnable(){

                                @Override
                                public void run() {
                                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                        @Override
                                        public void run() {
                                            for (Runnable change : toAskChanges) {
                                                change.run();
                                            }
                                        }
                                    });
                                }
                            }, "Update Android property files", null);
                        }
                        return true;
                    }
                });
            }
            if (!changes.isEmpty() && ReadonlyStatusHandler.ensureFilesWritable((Project)this.myProject, (VirtualFile[])files.toArray(new VirtualFile[files.size()]))) {
                CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                for (Runnable change : changes) {
                                    change.run();
                                }
                            }
                        });
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(AndroidPropertyFilesUpdater.this.myProject);
                    }
                }, "Update Android property files", null);
            }
        }
    }

    @Nullable
    private static Pair<VirtualFile, List<Runnable>> updateProjectPropertiesIfNecessary(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(0);
        }
        if (facet.isDisposed()) {
            return null;
        }
        Module module = facet.getModule();
        Pair<PropertiesFile, VirtualFile> pair = AndroidRootUtil.findPropertyFile(module, "project.properties");
        if (pair == null) {
            return null;
        }
        PropertiesFile projectProperties = (PropertiesFile)pair.getFirst();
        VirtualFile projectPropertiesVFile = (VirtualFile)pair.getSecond();
        Pair<Properties, VirtualFile> localProperties = AndroidRootUtil.readPropertyFile(module, "local.properties");
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        IAndroidTarget androidTarget = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
        String androidTargetHashString = androidTarget != null ? androidTarget.hashString() : null;
        VirtualFile[] dependencies2 = AndroidPropertyFilesUpdater.collectDependencies(module);
        String[] dependencyPaths = AndroidPropertyFilesUpdater.toSortedPaths(dependencies2);
        List<Object> newState = Arrays.asList(androidTargetHashString, facet.getProjectType(), Arrays.asList(dependencyPaths), facet.getProperties().ENABLE_MANIFEST_MERGING, facet.getProperties().ENABLE_PRE_DEXING);
        List state = (List)facet.getUserData(ANDROID_PROPERTIES_STATE_KEY);
        if (state == null || !Comparing.equal((Object)state, newState)) {
            AndroidPropertyFilesUpdater.updateTargetProperty(facet, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateProjectTypeProperty(facet, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateManifestMergerProperty(facet, projectProperties, changes);
            AndroidPropertyFilesUpdater.updateDependenciesInPropertyFile(projectProperties, localProperties, dependencies2, changes);
            facet.putUserData(ANDROID_PROPERTIES_STATE_KEY, newState);
        }
        return !changes.isEmpty() ? Pair.create((Object)projectPropertiesVFile, changes) : null;
    }

    private static void updateDependenciesInPropertyFile(final @NotNull PropertiesFile projectProperties, @Nullable Pair<Properties, VirtualFile> localProperties, @NotNull VirtualFile[] dependencies2, @NotNull List<Runnable> changes) {
        VirtualFile vFile;
        if (projectProperties == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(1);
        }
        if (dependencies2 == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(3);
        }
        if ((vFile = projectProperties.getVirtualFile()) == null) {
            return;
        }
        Set<Object> localDependencies = localProperties != null ? ImportDependenciesUtil.getLibDirs(localProperties) : Collections.emptySet();
        VirtualFile baseDir = vFile.getParent();
        String baseDirPath = baseDir.getPath();
        final ArrayList<String> newDepValues = new ArrayList<String>();
        for (VirtualFile dependency : dependencies2) {
            if (localDependencies.contains(dependency)) continue;
            String relPath = FileUtil.getRelativePath((String)baseDirPath, (String)dependency.getPath(), (char)'/');
            String value = relPath != null ? relPath : dependency.getPath();
            newDepValues.add(value);
        }
        HashSet oldDepValues = new HashSet();
        for (IProperty property : projectProperties.getProperties()) {
            String name = property.getName();
            if (name == null || !name.startsWith("android.library.reference.")) continue;
            oldDepValues.add(property.getValue());
        }
        if (!new HashSet(newDepValues).equals((Object)oldDepValues)) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    for (IProperty property : projectProperties.getProperties()) {
                        String name = property.getName();
                        if (name == null || !name.startsWith("android.library.reference.")) continue;
                        property.getPsiElement().delete();
                    }
                    for (int i = 0; i < newDepValues.size(); ++i) {
                        String value = (String)newDepValues.get(i);
                        projectProperties.addProperty("android.library.reference." + Integer.toString(i + 1), value);
                    }
                }
            });
        }
    }

    @NotNull
    private static VirtualFile[] collectDependencies(@NotNull Module module) {
        if (module == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(4);
        }
        ArrayList<VirtualFile> dependenciesList = new ArrayList<VirtualFile>();
        for (AndroidFacet depFacet : AndroidUtils.getAndroidLibraryDependencies(module)) {
            Module depModule = depFacet.getModule();
            VirtualFile libDir = AndroidPropertyFilesUpdater.getBaseAndroidContentRoot(depModule);
            if (libDir == null) continue;
            dependenciesList.add(libDir);
        }
        VirtualFile[] virtualFileArray = dependenciesList.toArray(new VirtualFile[dependenciesList.size()]);
        if (virtualFileArray == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    private static void updateTargetProperty(@NotNull AndroidFacet facet, final @NotNull PropertiesFile propertiesFile, @NotNull List<Runnable> changes) {
        if (facet == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(6);
        }
        if (propertiesFile == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(7);
        }
        if (changes == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(8);
        }
        final Project project = facet.getModule().getProject();
        IAndroidTarget androidTarget = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
        if (androidTarget != null) {
            PsiElement element;
            final String targetPropertyValue = androidTarget.hashString();
            IProperty property = propertiesFile.findPropertyByKey("target");
            if (property == null) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        propertiesFile.addProperty(AndroidPropertyFilesUpdater.createProperty(project, targetPropertyValue));
                    }
                });
            } else if (!Comparing.equal((String)property.getValue(), (String)targetPropertyValue) && (element = property.getPsiElement()) != null) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        element.replace(AndroidPropertyFilesUpdater.createProperty(project, targetPropertyValue).getPsiElement());
                    }
                });
            }
        }
    }

    public static void updateProjectTypeProperty(@NotNull AndroidFacet facet, @NotNull PropertiesFile propertiesFile, @NotNull List<Runnable> changes) {
        if (facet == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(9);
        }
        if (propertiesFile == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(10);
        }
        if (changes == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(11);
        }
        IProperty property = propertiesFile.findPropertyByKey("project.type");
        String value = Integer.toString(facet.getProjectType());
        if (property != null) {
            if (!value.equals(property.getValue())) {
                changes.add(() -> property.setValue(value));
            }
        } else {
            changes.add(() -> {
                if (propertiesFile == null) {
                    AndroidPropertyFilesUpdater.$$$reportNull$$$0(24);
                }
                propertiesFile.addProperty("project.type", value);
            });
        }
    }

    public static void updateManifestMergerProperty(@NotNull AndroidFacet facet, final @NotNull PropertiesFile propertiesFile, @NotNull List<Runnable> changes) {
        IProperty property;
        if (facet == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(12);
        }
        if (propertiesFile == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(13);
        }
        if (changes == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(14);
        }
        if ((property = propertiesFile.findPropertyByKey("manifestmerger.enabled")) != null) {
            final String value = Boolean.toString(facet.getProperties().ENABLE_MANIFEST_MERGING);
            if (!value.equals(property.getValue())) {
                changes.add(new Runnable(){

                    @Override
                    public void run() {
                        property.setValue(value);
                    }
                });
            }
        } else if (facet.getProperties().ENABLE_MANIFEST_MERGING) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("manifestmerger.enabled", Boolean.TRUE.toString());
                }
            });
        } else if (!facet.getProperties().ENABLE_PRE_DEXING) {
            changes.add(new Runnable(){

                @Override
                public void run() {
                    propertiesFile.addProperty("dex.disable.merger", Boolean.TRUE.toString());
                }
            });
        }
    }

    @Nullable
    private static VirtualFile getBaseAndroidContentRoot(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(15);
        }
        VirtualFile manifestFile = (facet = AndroidFacet.getInstance(module)) != null ? AndroidRootUtil.getManifestFile(facet) : null;
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (manifestFile != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)manifestFile, (boolean)true)) continue;
                return contentRoot;
            }
        }
        return contentRoots.length > 0 ? contentRoots[0] : null;
    }

    @NotNull
    private static IProperty createProperty(@NotNull Project project, @NotNull String targetPropertyValue) {
        if (project == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(16);
        }
        if (targetPropertyValue == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(17);
        }
        String text = "target=" + targetPropertyValue;
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile((Project)project, (String)text);
        IProperty iProperty = (IProperty)dummyFile.getProperties().get(0);
        if (iProperty == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(18);
        }
        return iProperty;
    }

    @NotNull
    private static String[] toSortedPaths(@NotNull VirtualFile[] files) {
        if (files == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(19);
        }
        Object[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getPath();
        }
        Arrays.sort(result);
        if (result == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(20);
        }
        return result;
    }

    private void askUserIfUpdatePropertyFile(@NotNull Project project, @NotNull Collection<AndroidFacet> facets, final @NotNull Processor<MyResult> callback) {
        if (project == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(21);
        }
        if (facets == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(22);
        }
        if (callback == null) {
            AndroidPropertyFilesUpdater.$$$reportNull$$$0(23);
        }
        StringBuilder moduleList = new StringBuilder();
        for (AndroidFacet facet : facets) {
            moduleList.append(facet.getModule().getName()).append("<br>");
        }
        this.myNotification = PROPERTY_FILES_UPDATING_NOTIFICATION.createNotification(AndroidBundle.message("android.update.project.properties.dialog.title", new Object[0]), AndroidBundle.message("android.update.project.properties.dialog.text", moduleList.toString()), NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                String desc;
                if (notification == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    10.$$$reportNull$$$0(1);
                }
                if ("once".equals(desc = event.getDescription())) {
                    callback.process((Object)MyResult.ONCE);
                } else if ("never".equals(desc)) {
                    callback.process((Object)MyResult.NEVER);
                } else {
                    callback.process((Object)MyResult.ALWAYS);
                }
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/AndroidPropertyFilesUpdater$10";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myNotification.notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/AndroidPropertyFilesUpdater";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPropertyValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/AndroidPropertyFilesUpdater";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDependencies";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperty";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toSortedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectPropertiesIfNecessary";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesInPropertyFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 5: 
            case 18: 
            case 20: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateTargetProperty";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectTypeProperty";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateManifestMergerProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBaseAndroidContentRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toSortedPaths";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "askUserIfUpdatePropertyFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateProjectTypeProperty$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MyResult {
        ONCE,
        NEVER,
        ALWAYS;

    }
}

