/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.ddms.adb.AdbService;
import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.actions.AndroidRunSdkToolAction;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunDdmsAction
extends AndroidRunSdkToolAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.AndroidRunDdmsAction");
    private static volatile OSProcessHandler ourProcessHandler;

    public AndroidRunDdmsAction() {
        super(AndroidBundle.message("android.launch.ddms.title", new Object[0]));
    }

    @Override
    protected void doRunTool(final @NotNull Project project, @NotNull String sdkPath) {
        if (project == null) {
            AndroidRunDdmsAction.$$$reportNull$$$0(0);
        }
        if (sdkPath == null) {
            AndroidRunDdmsAction.$$$reportNull$$$0(1);
        }
        if (AndroidRunDdmsAction.getDdmsProcessHandler() != null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("android.launch.ddms.already.launched.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        final boolean adbServiceEnabled = AndroidEnableAdbServiceAction.isAdbServiceEnabled();
        if (adbServiceEnabled && !AndroidEnableAdbServiceAction.disableAdbService(project)) {
            return;
        }
        String toolPath = sdkPath + File.separator + AndroidCommonUtils.toolPath((String)AndroidRunDdmsAction.getDdmsCmdName());
        final GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(toolPath);
        LOG.info(commandLine.getCommandLineString());
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidRunDdmsAction.doLaunchDdms(commandLine, project, adbServiceEnabled);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doLaunchDdms(GeneralCommandLine commandLine, Project project, boolean adbServiceWasEnabled) {
        try {
            ourProcessHandler = new OSProcessHandler(commandLine);
            ourProcessHandler.startNotify();
            ourProcessHandler.waitFor();
            ourProcessHandler = null;
            if (!adbServiceWasEnabled) return;
        }
        catch (ExecutionException e) {
            try {
                LOG.info((Throwable)e);
                ourProcessHandler = null;
                if (!adbServiceWasEnabled) return;
            }
            catch (Throwable throwable) {
                ourProcessHandler = null;
                if (!adbServiceWasEnabled) throw throwable;
                ApplicationManager.getApplication().invokeLater(new Runnable(project){
                    final /* synthetic */ Project val$project;
                    {
                        this.val$project = project;
                    }

                    @Override
                    public void run() {
                        if (this.val$project.isDisposed()) {
                            return;
                        }
                        AndroidEnableAdbServiceAction.setAdbServiceEnabled(this.val$project, true);
                        File adb = AndroidSdkUtils.getAdb(this.val$project);
                        if (adb != null) {
                            AdbService.getInstance().getDebugBridge(adb);
                        }
                    }
                });
                throw throwable;
            }
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
        return;
    }

    @Nullable
    public static OSProcessHandler getDdmsProcessHandler() {
        return ourProcessHandler;
    }

    @NotNull
    private static String getDdmsCmdName() {
        String archName = SystemInfo.OS_ARCH.equalsIgnoreCase("x86_64") || SystemInfo.OS_ARCH.equalsIgnoreCase("amd64") ? "x86_64" : "x86";
        String dir = "lib/monitor-" + archName + "/";
        if (SystemInfo.isMac) {
            String string = dir + "monitor.app/Contents/MacOS/monitor";
            if (string == null) {
                AndroidRunDdmsAction.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = dir + (SystemInfo.isWindows ? "monitor.exe" : "monitor");
        if (string == null) {
            AndroidRunDdmsAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/AndroidRunDdmsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/AndroidRunDdmsAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdmsCmdName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRunTool";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

