/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.DynamicResourceValueItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceReferenceBase
extends PsiReferenceBase.Poly<XmlElement> {
    protected final AndroidFacet myFacet;
    protected final ResourceValue myResourceValue;

    public AndroidResourceReferenceBase(@NotNull GenericDomValue value, @Nullable TextRange range, @NotNull ResourceValue resourceValue, @NotNull AndroidFacet facet) {
        if (value == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(0);
        }
        if (resourceValue == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(2);
        }
        super((PsiElement)DomUtil.getValueElement((GenericDomValue)value), range, true);
        this.myResourceValue = resourceValue;
        this.myFacet = facet;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public ResourceValue getResourceValue() {
        ResourceValue resourceValue = this.myResourceValue;
        if (resourceValue == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(4);
        }
        return resourceValue;
    }

    @NotNull
    public PsiElement[] computeTargetElements() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof LazyValueResourceElementWrapper) {
                element = ((LazyValueResourceElementWrapper)element).computeElement();
            }
            if (element instanceof ResourceElementWrapper) {
                element = ((ResourceElementWrapper)element).getWrappee();
            }
            if (element == null) continue;
            results.add(element);
        }
        PsiElement[] psiElementArray = results.toArray(new PsiElement[results.size()]);
        if (psiElementArray == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((XmlElement)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (reference, incompleteCode1) -> this.resolveInner(), false, incompleteCode);
        if (resolveResultArray == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] resolveInner() {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        boolean attrReference = this.myResourceValue.getPrefix() == '?';
        this.collectTargets(this.myFacet, this.myResourceValue, elements, attrReference);
        ArrayList<Object> result = new ArrayList<Object>();
        if (elements.isEmpty() && this.myResourceValue.getResourceName() != null && !"android".equals(this.myResourceValue.getNamespace())) {
            AppResourceRepository resources = AppResourceRepository.getOrCreateInstance(this.myFacet.getModule());
            ResourceType resourceType = this.myResourceValue.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                List items;
                assert (resources != null);
                String resourceName = this.myResourceValue.getResourceName();
                if (resourceType == ResourceType.SAMPLE_DATA) {
                    resourceName = SampleDataManager.getResourceNameFromSampleReference((String)resourceName);
                    if (this.myResourceValue.getNamespace() != null) {
                        resourceName = this.myResourceValue.getNamespace() + ":" + resourceName;
                    }
                }
                if ((items = resources.getResourceItem(resourceType, resourceName)) != null) {
                    XmlAttribute attribute;
                    if (FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                        for (ResourceItem item : items) {
                            XmlTag tag = LocalResourceRepository.getItemTag(this.myFacet.getModule().getProject(), item);
                            if (tag != null) {
                                elements.add((PsiElement)tag);
                                continue;
                            }
                            if (!(item instanceof DynamicResourceValueItem)) continue;
                            result.add(((DynamicResourceValueItem)item).createResolveResult());
                        }
                    } else if (resourceType == ResourceType.SAMPLE_DATA && ((XmlElement)this.myElement).getParent() instanceof XmlAttribute && "http://schemas.android.com/tools".equals((attribute = (XmlAttribute)((XmlElement)this.myElement).getParent()).getNamespace())) {
                        items.stream().filter(SampleDataResourceItem.class::isInstance).map(SampleDataResourceItem.class::cast).forEach(sampleDataItem -> result.add(new ResolveResult((SampleDataResourceItem)((Object)sampleDataItem)){
                            final /* synthetic */ SampleDataResourceItem val$sampleDataItem;
                            {
                                this.val$sampleDataItem = sampleDataResourceItem;
                            }

                            @Nullable
                            public PsiElement getElement() {
                                return this.val$sampleDataItem.getPsiElement();
                            }

                            public boolean isValidResult() {
                                return true;
                            }
                        }));
                    }
                }
            }
        }
        if (elements.size() > 1) {
            elements.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result.add(new PsiElementResolveResult(target));
        }
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    private void collectTargets(AndroidFacet facet, ResourceValue resValue, List<PsiElement> elements, boolean attrReference) {
        String resName;
        ResourceType resType = resValue.getType();
        if (resType == null) {
            return;
        }
        ResourceManager manager = ModuleResourceManagers.getInstance(facet).getResourceManager(resValue.getNamespace(), this.myElement);
        if (manager != null && (resName = resValue.getResourceName()) != null) {
            manager.collectLazyResourceElements(resType.getName(), resName, attrReference, this.myElement, elements);
        }
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper && (element = ((LazyValueResourceElementWrapper)element).computeElement()) == null) {
            return false;
        }
        ResolveResult[] results = this.multiResolve(false);
        PsiFile psiFile = element.getContainingFile();
        VirtualFile vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        for (ResolveResult result : results) {
            ValueResourceInfo info;
            PsiElement target = result.getElement();
            if (element.getManager().areElementsEquivalent(target, element)) {
                return true;
            }
            if (!(target instanceof LazyValueResourceElementWrapper) || vFile == null || !(info = ((LazyValueResourceElementWrapper)target).getResourceInfo()).getContainingFile().equals(vFile)) continue;
            XmlAttributeValue realTarget = info.computeXmlElement();
            if (!element.getManager().areElementsEquivalent((PsiElement)realTarget, element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            AndroidResourceReferenceBase.$$$reportNull$$$0(8);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidResourceReferenceBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTargetElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

