/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.AndroidGotoRelatedProvider;
import org.jetbrains.android.dom.AndroidCreateOnClickHandlerAction;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.menu.MenuDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidMissingOnClickHandlerInspection
extends LocalInspectionTool {
    @NotNull
    private static Collection<PsiClass> findRelatedActivities(@NotNull XmlFile file, @NotNull AndroidFacet facet, @NotNull DomFileDescription<?> description) {
        if (file == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(1);
        }
        if (description == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(2);
        }
        if (description instanceof LayoutDomFileDescription) {
            Computable<List<GotoRelatedItem>> computable = AndroidGotoRelatedProvider.getLazyItemsForXmlFile(file, facet);
            if (computable == null) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(3);
                }
                return list;
            }
            List items = (List)computable.compute();
            if (items.isEmpty()) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(4);
                }
                return list;
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(facet.getModule());
            if (activityClass == null) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(5);
                }
                return list;
            }
            ArrayList<PsiClass> result = new ArrayList<PsiClass>();
            for (GotoRelatedItem item : items) {
                PsiClass aClass;
                PsiElement element = item.getElement();
                if (!(element instanceof PsiClass) || !(aClass = (PsiClass)element).isInheritor(activityClass, true)) continue;
                result.add(aClass);
            }
            ArrayList<PsiClass> arrayList = result;
            if (arrayList == null) {
                AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        Set<PsiClass> set = AndroidMissingOnClickHandlerInspection.findRelatedActivitiesForMenu(file, facet);
        if (set == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private static Set<PsiClass> findRelatedActivitiesForMenu(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        String resourceName;
        String resType;
        PsiField[] fields;
        if (file == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(8);
        }
        if (facet == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(9);
        }
        if ((fields = AndroidResourceUtil.findResourceFields(facet, resType = ResourceType.MENU.getName(), resourceName = AndroidCommonUtils.getResourceName((String)resType, (String)file.getName()), true)).length == 0) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(10);
            }
            return set;
        }
        Module module = facet.getModule();
        GlobalSearchScope scope = module.getModuleScope(false);
        PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
        if (activityClass == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(11);
            }
            return set;
        }
        HashSet result = new HashSet();
        ReferencesSearch.search((PsiElement)fields[0], (SearchScope)scope).forEach((Processor)new Processor<PsiReference>((Set)result, activityClass){
            final /* synthetic */ Set val$result;
            final /* synthetic */ PsiClass val$activityClass;
            {
                this.val$result = set;
                this.val$activityClass = psiClass;
            }

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (element == null) {
                    return true;
                }
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                if (aClass != null && !this.val$result.contains(aClass) && aClass.isInheritor(this.val$activityClass, true)) {
                    this.val$result.add(aClass);
                }
                return true;
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Nullable
    public static PsiClass findActivityClass(@NotNull Module module) {
        if (module == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(13);
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(14);
        }
        if (manager == null) {
            AndroidMissingOnClickHandlerInspection.$$$reportNull$$$0(15);
        }
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DomFileDescription description = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file);
        if (!(description instanceof LayoutDomFileDescription) && !(description instanceof MenuDomFileDescription)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Collection<PsiClass> activities = AndroidMissingOnClickHandlerInspection.findRelatedActivities((XmlFile)file, facet, description);
        MyVisitor visitor = new MyVisitor(manager, isOnTheFly, activities);
        file.accept((PsiElementVisitor)visitor);
        return visitor.myResult.toArray(new ProblemDescriptor[visitor.myResult.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedActivities";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedActivitiesForMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedActivities";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedActivitiesForMenu";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findActivityClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyQuickFix
    extends AbstractIntentionAction
    implements LocalQuickFix {
        private final String myMethodName;
        private final OnClickConverter myConverter;
        private final PsiClass myClass;

        private MyQuickFix(@NotNull String methodName, @NotNull OnClickConverter converter, @NotNull PsiClass aClass) {
            if (methodName == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (converter == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (aClass == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            this.myMethodName = methodName;
            this.myConverter = converter;
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            String string = "Create '" + this.myMethodName + "(" + this.myConverter.getShortParameterName() + ")' in '" + this.myClass.getName() + "'";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, this.myClass, this.myMethodName, paramType);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(7);
            }
            this.doApplyFix(project);
        }

        public void doApplyFix(@NotNull Project project) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(8);
            }
            String paramType = this.myConverter.getDefaultMethodParameterType(this.myClass);
            AndroidCreateOnClickHandlerAction.addHandlerMethod(project, this.myClass, this.myMethodName, paramType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection$MyQuickFix";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection$MyQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        private final Collection<PsiClass> myRelatedActivities;
        final List<ProblemDescriptor> myResult;

        private MyVisitor(@NotNull InspectionManager inspectionManager, boolean onTheFly, @NotNull Collection<PsiClass> relatedActivities) {
            if (inspectionManager == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (relatedActivities == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myResult = new ArrayList<ProblemDescriptor>();
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
            this.myRelatedActivities = relatedActivities;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            for (PsiReference reference : value.getReferences()) {
                OnClickConverter.MyReference ref;
                String methodName;
                if (!(reference instanceof OnClickConverter.MyReference) || (methodName = (ref = (OnClickConverter.MyReference)reference).getValue()).isEmpty()) continue;
                ResolveResult[] results = ref.multiResolve(false);
                HashSet resolvedClasses = new HashSet();
                HashSet resolvedClassesWithMistake = new HashSet();
                for (ResolveResult result : results) {
                    PsiClass aClass;
                    PsiElement element;
                    if (!(result instanceof OnClickConverter.MyResolveResult) || (element = result.getElement()) == null || (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) continue;
                    resolvedClasses.add(aClass);
                    if (((OnClickConverter.MyResolveResult)result).hasCorrectSignature()) continue;
                    resolvedClassesWithMistake.add(aClass);
                }
                PsiClass activity = null;
                for (PsiClass relatedActivity : this.myRelatedActivities) {
                    if (!MyVisitor.containsOrExtends((Set<PsiClass>)resolvedClasses, relatedActivity)) {
                        activity = relatedActivity;
                        break;
                    }
                    if (activity != null || !MyVisitor.containsOrExtends((Set<PsiClass>)resolvedClassesWithMistake, relatedActivity)) continue;
                    activity = relatedActivity;
                }
                if (activity != null) {
                    this.reportMissingOnClickProblem(ref, activity, methodName, resolvedClassesWithMistake.contains(activity));
                    continue;
                }
                if (results.length == 0) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)value, reference.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, new LocalQuickFix[0]));
                    continue;
                }
                if (resolvedClassesWithMistake.isEmpty()) continue;
                this.reportMissingOnClickProblem(ref, (PsiClass)resolvedClassesWithMistake.iterator().next(), methodName, true);
            }
        }

        private static boolean containsOrExtends(@NotNull Set<PsiClass> resolvedClasses, @NotNull PsiClass relatedActivity) {
            if (resolvedClasses == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (relatedActivity == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (resolvedClasses.contains(relatedActivity)) {
                return true;
            }
            for (PsiClass resolvedClass : resolvedClasses) {
                if (!relatedActivity.isInheritor(resolvedClass, false)) continue;
                return true;
            }
            return false;
        }

        private void reportMissingOnClickProblem(OnClickConverter.MyReference reference, PsiClass activity, String methodName, boolean incorrectSignature) {
            LocalQuickFix[] localQuickFixArray;
            String message;
            String activityName = activity.getName();
            if (activityName == null) {
                activityName = "";
            }
            String string = message = incorrectSignature ? AndroidBundle.message("android.inspections.on.click.missing.incorrect.signature", methodName, activityName) : AndroidBundle.message("android.inspections.on.click.missing.problem", methodName, activityName);
            if (StringUtil.isJavaIdentifier((String)methodName)) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MyQuickFix(methodName, reference.getConverter(), activity);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            this.myResult.add(this.myInspectionManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relatedActivities";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedClasses";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relatedActivity";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/inspections/AndroidMissingOnClickHandlerInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsOrExtends";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

