/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class GroovyGStringKeyInspection
extends BaseInspection {
    private static final String PUT_METHOD = "put";

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "GString is used as map's key #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            GroovyGStringKeyInspection.$$$reportNull$$$0(0);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection", "buildVisitor"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument namedArgument) {
            PsiElement parent;
            if (namedArgument == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (!((parent = namedArgument.getParent()) instanceof GrListOrMap) || !((GrListOrMap)parent).isMap()) {
                return;
            }
            GrArgumentLabel argumentLabel = namedArgument.getLabel();
            if (argumentLabel == null) {
                return;
            }
            GrExpression labelExpression = argumentLabel.getExpression();
            if (labelExpression == null) {
                return;
            }
            if (Visitor.isGStringType(labelExpression)) {
                this.registerError(argumentLabel);
            }
        }

        @Override
        public void visitExpression(@NotNull GrExpression grExpression) {
            PsiElement gstringParent;
            if (grExpression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (!((gstringParent = grExpression.getParent()) instanceof GrArgumentList)) {
                return;
            }
            GrExpression[] arguments = ((GrArgumentList)gstringParent).getExpressionArguments();
            if (arguments.length != 2 || !arguments[0].equals(grExpression)) {
                return;
            }
            PsiElement grandparent = gstringParent.getParent();
            if (!(grandparent instanceof GrMethodCall)) {
                return;
            }
            if (!Visitor.isGStringType(grExpression)) {
                return;
            }
            if (!this.isMapPutMethod((GrMethodCall)grandparent)) {
                return;
            }
            this.registerError(grExpression);
        }

        boolean isMapPutMethod(@NotNull GrMethodCall grMethodCall) {
            PsiMethod[] methods;
            PsiMethod method;
            if (grMethodCall == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((method = grMethodCall.resolveMethod()) == null) {
                return false;
            }
            if (!GroovyGStringKeyInspection.PUT_METHOD.equals(method.getName())) {
                return false;
            }
            PsiClass mapClass = JavaPsiFacade.getInstance((Project)grMethodCall.getProject()).findClass("java.util.Map", grMethodCall.getResolveScope());
            if (mapClass == null) {
                return false;
            }
            for (PsiMethod superMethod : methods = mapClass.findMethodsByName(GroovyGStringKeyInspection.PUT_METHOD, false)) {
                if (!superMethod.equals(method) && !PsiSuperMethodUtil.isSuperMethod((PsiMethod)method, (PsiMethod)superMethod)) continue;
                return true;
            }
            return false;
        }

        private static boolean isGStringType(@NotNull GrExpression expression) {
            PsiType expressionType;
            if (expression == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return (expressionType = expression.getType()) != null && expressionType.equalsToText("groovy.lang.GString");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namedArgument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grMethodCall";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyGStringKeyInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNamedArgument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMapPutMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isGStringType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

