/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Function;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerInfo<T extends PsiElement> {
    private static final Logger LOG = Logger.getInstance(LineMarkerInfo.class);
    protected final Icon myIcon;
    private final SmartPsiElementPointer<T> elementRef;
    public final int startOffset;
    public final int endOffset;
    public Color separatorColor;
    public SeparatorPlacement separatorPlacement;
    public RangeHighlighter highlighter;
    public final int updatePass;
    @Nullable
    private final Function<? super T, String> myTooltipProvider;
    private AnAction myNavigateAction;
    @NotNull
    private final GutterIconRenderer.Alignment myIconAlignment;
    @Nullable
    private final GutterIconNavigationHandler<T> myNavigationHandler;

    public LineMarkerInfo(@NotNull T element, @NotNull TextRange range, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        PsiElement firstChild;
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(2);
        }
        this.myNavigateAction = new NavigateAction(this);
        this.myIcon = icon;
        this.myTooltipProvider = tooltipProvider;
        this.myIconAlignment = alignment;
        this.elementRef = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myNavigationHandler = navHandler;
        this.startOffset = range.getStartOffset();
        this.endOffset = range.getEndOffset();
        this.updatePass = 11;
        if (!(element instanceof PsiFile) && (firstChild = element.getFirstChild()) != null) {
            String msg = "Performance warning: LineMarker is supposed to be registered for leaf elements only, but got: " + element + " (" + element.getClass() + ") instead. First child: " + firstChild + " (" + firstChild.getClass() + ")\nPlease see LineMarkerProvider#getLineMarkerInfo(PsiElement) javadoc for detailed explanations.";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(msg);
            } else {
                LOG.warn(msg);
            }
        }
    }

    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(3);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(4);
        }
        this((T)element, new TextRange(startOffset, startOffset), icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler) {
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(5);
        }
        this((T)element, startOffset, icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    @Nullable
    public GutterIconRenderer createGutterRenderer() {
        if (this.myIcon == null) {
            return null;
        }
        return new LineMarkerGutterIconRenderer(this);
    }

    @Nullable
    public String getLineMarkerTooltip() {
        if (this.myTooltipProvider == null) {
            return null;
        }
        T element = this.getElement();
        return element == null || !element.isValid() ? null : (String)this.myTooltipProvider.fun(element);
    }

    @Nullable
    public T getElement() {
        return this.elementRef.getElement();
    }

    void setNavigateAction(@NotNull AnAction navigateAction) {
        if (navigateAction == null) {
            LineMarkerInfo.$$$reportNull$$$0(6);
        }
        this.myNavigateAction = navigateAction;
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = MarkupEditorFilter.EMPTY;
        if (markupEditorFilter == null) {
            LineMarkerInfo.$$$reportNull$$$0(7);
        }
        return markupEditorFilter;
    }

    @Nullable
    public GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.myNavigationHandler;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ") -> " + this.elementRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/LineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/LineMarkerInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateAction";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineMarkerGutterIconRenderer<T extends PsiElement>
    extends GutterIconRenderer {
        private final LineMarkerInfo<T> myInfo;

        public LineMarkerGutterIconRenderer(@NotNull LineMarkerInfo<T> info) {
            if (info == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(0);
            }
            this.myInfo = info;
        }

        public LineMarkerInfo<T> getLineMarkerInfo() {
            return this.myInfo;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.myInfo.myIcon;
            if (icon == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @Override
        public AnAction getClickAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigateAction;
        }

        @Override
        public boolean isNavigateAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigationHandler != null;
        }

        @Override
        public String getTooltipText() {
            try {
                return this.myInfo.getLineMarkerTooltip();
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @Override
        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = ((LineMarkerInfo)this.myInfo).myIconAlignment;
            if (alignment == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return alignment;
        }

        protected boolean looksTheSameAs(@NotNull LineMarkerGutterIconRenderer renderer) {
            if (renderer == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return this.myInfo.getElement() != null && renderer.myInfo.getElement() != null && this.myInfo.getElement() == renderer.myInfo.getElement() && Comparing.equal((Object)((LineMarkerInfo)this.myInfo).myTooltipProvider, (Object)((LineMarkerInfo)renderer.myInfo).myTooltipProvider) && Comparing.equal((Object)this.myInfo.myIcon, (Object)renderer.myInfo.myIcon);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LineMarkerGutterIconRenderer && this.looksTheSameAs((LineMarkerGutterIconRenderer)obj);
        }

        @Override
        public int hashCode() {
            T element = this.myInfo.getElement();
            return element == null ? 0 : element.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "looksTheSameAs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

