/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConsoleViewContentType {
    private final String myName;
    private final TextAttributes myTextAttributes;
    private final TextAttributesKey myTextAttributesKey;
    private static final Map<Key, ConsoleViewContentType> ourRegisteredTypes = new HashMap<Key, ConsoleViewContentType>();
    public static final ColorKey CONSOLE_BACKGROUND_KEY = ColorKey.createColorKey("CONSOLE_BACKGROUND_KEY");
    public static final TextAttributesKey NORMAL_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_NORMAL_OUTPUT");
    public static final TextAttributesKey LOG_WARNING_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("LOG_WARNING_OUTPUT");
    public static final TextAttributesKey ERROR_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_ERROR_OUTPUT");
    public static final TextAttributesKey LOG_ERROR_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("LOG_ERROR_OUTPUT");
    public static final TextAttributesKey LOG_EXPIRED_ENTRY = TextAttributesKey.createTextAttributesKey("LOG_EXPIRED_ENTRY");
    public static final TextAttributesKey USER_INPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_USER_INPUT");
    public static final TextAttributesKey SYSTEM_OUTPUT_KEY = TextAttributesKey.createTextAttributesKey("CONSOLE_SYSTEM_OUTPUT");
    public static final ConsoleViewContentType NORMAL_OUTPUT = new ConsoleViewContentType("NORMAL_OUTPUT", NORMAL_OUTPUT_KEY);
    public static final ConsoleViewContentType LOG_WARNING_OUTPUT = new ConsoleViewContentType("LOG_WARNING_OUTPUT", LOG_WARNING_OUTPUT_KEY);
    public static final ConsoleViewContentType ERROR_OUTPUT = new ConsoleViewContentType("ERROR_OUTPUT", ERROR_OUTPUT_KEY);
    public static final ConsoleViewContentType USER_INPUT = new ConsoleViewContentType("USER_INPUT", USER_INPUT_KEY);
    public static final ConsoleViewContentType SYSTEM_OUTPUT = new ConsoleViewContentType("SYSTEM_OUTPUT", SYSTEM_OUTPUT_KEY);
    public static final ConsoleViewContentType[] OUTPUT_TYPES = new ConsoleViewContentType[]{NORMAL_OUTPUT, ERROR_OUTPUT, USER_INPUT, SYSTEM_OUTPUT};

    public ConsoleViewContentType(@NonNls String name, TextAttributes textAttributes) {
        this.myName = name;
        this.myTextAttributes = textAttributes;
        this.myTextAttributesKey = null;
    }

    public ConsoleViewContentType(@NonNls String name, TextAttributesKey textAttributesKey) {
        this.myName = name;
        this.myTextAttributes = null;
        this.myTextAttributesKey = textAttributesKey;
    }

    public String toString() {
        return this.myName;
    }

    public TextAttributes getAttributes() {
        if (this.myTextAttributesKey != null) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myTextAttributesKey);
        }
        return this.myTextAttributes;
    }

    public static ConsoleViewContentType registerNewConsoleViewType(@NotNull Key key, @NotNull TextAttributesKey attributesKey) {
        if (key == null) {
            ConsoleViewContentType.$$$reportNull$$$0(0);
        }
        if (attributesKey == null) {
            ConsoleViewContentType.$$$reportNull$$$0(1);
        }
        ConsoleViewContentType type = new ConsoleViewContentType(key.toString(), attributesKey);
        ConsoleViewContentType.registerNewConsoleViewType(key, type);
        return type;
    }

    public static synchronized void registerNewConsoleViewType(Key processOutputType, ConsoleViewContentType attributes) {
        ourRegisteredTypes.put(processOutputType, attributes);
    }

    public static synchronized ConsoleViewContentType getConsoleViewType(Key processOutputType) {
        return ourRegisteredTypes.getOrDefault(processOutputType, SYSTEM_OUTPUT);
    }

    public static synchronized Collection<ConsoleViewContentType> getRegisteredTypes() {
        return ourRegisteredTypes.values();
    }

    static {
        ourRegisteredTypes.put(ProcessOutputTypes.SYSTEM, SYSTEM_OUTPUT);
        ourRegisteredTypes.put(ProcessOutputTypes.STDOUT, NORMAL_OUTPUT);
        ourRegisteredTypes.put(ProcessOutputTypes.STDERR, ERROR_OUTPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "attributesKey";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/ui/ConsoleViewContentType";
        objectArray[2] = "registerNewConsoleViewType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

