/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class InsertPathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.InsertPathAction");
    protected final JTextComponent myTextField;
    protected static final CustomShortcutSet CTRL_F = new CustomShortcutSet(KeyStroke.getKeyStroke(70, 128));
    protected final FileChooserDescriptor myDescriptor;
    private MouseListener myPopupHandler;
    protected static final Key INSERT_PATH_ACTION = Key.create((String)"insertPathAction");

    private InsertPathAction(JTextComponent textField) {
        this(textField, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
    }

    private InsertPathAction(JTextComponent textField, FileChooserDescriptor descriptor) {
        super(UIBundle.message((String)"insert.file.path.to.text.action.name", (Object[])new Object[0]));
        this.myTextField = textField;
        this.registerCustomShortcutSet(CTRL_F, this.myTextField);
        this.myDescriptor = descriptor;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        String selectedText = this.myTextField.getSelectedText();
        VirtualFile virtualFile2 = selectedText != null ? LocalFileSystem.getInstance().findFileByPath(selectedText.replace(File.separatorChar, '/')) : null;
        VirtualFile[] files = FileChooser.chooseFiles(this.myDescriptor, this.myTextField, InsertPathAction.getEventProject(e), virtualFile2);
        if (files.length != 0) {
            this.myTextField.replaceSelection(files[0].getPresentableUrl());
        }
    }

    private void uninstall() {
        this.uninstallPopupHandler();
        this.myTextField.putClientProperty(INSERT_PATH_ACTION, null);
    }

    private void savePopupHandler(MouseListener popupHandler) {
        if (this.myPopupHandler != null) {
            LOG.error("Installed twice");
            this.uninstallPopupHandler();
        }
        this.myPopupHandler = popupHandler;
    }

    private void uninstallPopupHandler() {
        if (this.myPopupHandler == null) {
            return;
        }
        this.myTextField.removeMouseListener(this.myPopupHandler);
        this.myPopupHandler = null;
    }

    public static void addTo(JTextComponent textField) {
        InsertPathAction.addTo(textField, null);
    }

    public static void addTo(JTextComponent textField, FileChooserDescriptor descriptor) {
        if (ApplicationManager.getApplication() != null) {
            InsertPathAction.removeFrom(textField);
            if (textField.getClientProperty(INSERT_PATH_ACTION) != null) {
                return;
            }
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            InsertPathAction action = descriptor != null ? new InsertPathAction(textField, descriptor) : new InsertPathAction(textField);
            actionGroup.add(action);
            MouseListener popupHandler = PopupHandler.installUnknownPopupHandler(textField, actionGroup, ActionManager.getInstance());
            action.savePopupHandler(popupHandler);
            textField.putClientProperty(INSERT_PATH_ACTION, action);
        }
    }

    public static void removeFrom(JTextComponent textComponent) {
        InsertPathAction action = InsertPathAction.getFrom(textComponent);
        if (action == null) {
            return;
        }
        action.uninstall();
    }

    public static void copyFromTo(JTextComponent original, JTextComponent target) {
        InsertPathAction action = InsertPathAction.getFrom(original);
        if (action == null) {
            return;
        }
        InsertPathAction.removeFrom(target);
        InsertPathAction.addTo(target, action.myDescriptor);
    }

    private static InsertPathAction getFrom(JTextComponent textComponent) {
        Object property2 = textComponent.getClientProperty(INSERT_PATH_ACTION);
        if (!(property2 instanceof InsertPathAction)) {
            return null;
        }
        return (InsertPathAction)property2;
    }
}

