/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet<String>();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = path2 -> StandardFileSystems.local().findFileByPath(path2.replace(File.separatorChar, '/'));
    private static final Function<VirtualFile, String> LOCAL_PATH = file -> PathUtil.getLocalPath(file);
    private static final Function<String, VirtualFile> PATH_TO_DIR = s -> {
        VirtualFile file = (VirtualFile)PATH_TO_LOCAL_VFILE.fun(s);
        if (file == null) {
            return null;
        }
        if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName()) == ArchiveFileType.INSTANCE) {
            return StandardFileSystems.jar().findFileByPath(file.getPath() + "!/");
        }
        return file;
    };

    public boolean isEmpty() {
        return this.myPathSet.isEmpty();
    }

    public void add(String path2) {
        this.addAllLast(this.chooseFirstTimeItems(path2), this.myPath);
    }

    public void remove(@NotNull String path2) {
        if (path2 == null) {
            PathsList.$$$reportNull$$$0(0);
        }
        this.myPath.remove(path2);
        this.myPathTail.remove(path2);
        this.myPathSet.remove(path2);
    }

    public void clear() {
        this.myPath.clear();
        this.myPathTail.clear();
        this.myPathSet.clear();
    }

    public void add(VirtualFile file) {
        this.add((String)LOCAL_PATH.fun((Object)file));
    }

    public void addFirst(String path2) {
        int index = 0;
        for (String element : this.chooseFirstTimeItems(path2)) {
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path2) {
        this.addAllLast(this.chooseFirstTimeItems(path2), this.myPathTail);
    }

    private Iterable<String> chooseFirstTimeItems(String path2) {
        if (path2 == null) {
            return Collections.emptyList();
        }
        return JBIterable.from((Iterable)StringUtil.tokenize((String)path2, (String)File.pathSeparator)).filter(element -> !(element = element.trim()).isEmpty() && !this.myPathSet.contains(element));
    }

    private void addAllLast(Iterable<String> elements, List<String> toArray) {
        for (String element : elements) {
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    @NotNull
    public String getPathsString() {
        String string = StringUtil.join(this.getPathList(), (String)File.pathSeparator);
        if (string == null) {
            PathsList.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<String> getPathList() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.addAll(this.myPath);
        result2.addAll(this.myPathTail);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PathsList.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public List<VirtualFile> getVirtualFiles() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_LOCAL_VFILE).toList();
    }

    public List<VirtualFile> getRootDirs() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_DIR).toList();
    }

    public void addAll(List<String> allClasspath) {
        for (String path2 : allClasspath) {
            this.add(path2);
        }
    }

    public void addAllFiles(File[] files) {
        this.addAllFiles(Arrays.asList(files));
    }

    public void addAllFiles(List<File> files) {
        for (File file : files) {
            this.add(file);
        }
    }

    public void add(File file) {
        this.add(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addVirtualFiles(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            this.add(file);
        }
    }

    public void addVirtualFiles(VirtualFile[] files) {
        this.addVirtualFiles(Arrays.asList(files));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

