/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.hchart.DefaultHTreeChartReducer;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChartReducer;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DefaultHNode;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTreeChart<T>
extends AnimatedComponent {
    private static final String NO_HTREE = "No data available.";
    private static final String NO_RANGE = "X range width is zero: Please use a wider range.";
    private static final int ZOOM_FACTOR = 20;
    private static final String ACTION_ZOOM_IN = "zoom in";
    private static final String ACTION_ZOOM_OUT = "zoom out";
    private static final String ACTION_MOVE_LEFT = "move left";
    private static final String ACTION_MOVE_RIGHT = "move right";
    private static final int ACTION_MOVEMENT_FACTOR = 5;
    private static final int BORDER_PLUS_PADDING = 2;
    private final Orientation mOrientation;
    @Nullable
    private HRenderer<T> mHRenderer;
    @Nullable
    private HNode<T> mRoot;
    @NotNull
    private final Range mXRange;
    @NotNull
    private final Range mYRange;
    @NotNull
    private final List<Rectangle2D.Float> mRectangles;
    @NotNull
    private final List<HNode<T>> mNodes;
    @NotNull
    private final List<Rectangle2D.Float> mDrawnRectangles;
    @NotNull
    private final List<HNode<T>> mDrawnNodes;
    @NotNull
    private final HTreeChartReducer<T> mReducer;
    private boolean mRender;
    @Nullable
    private Image myCanvas;

    public HTreeChart(@NotNull Range xRange, Orientation orientation, @NotNull HTreeChartReducer<T> reducer) {
        if (xRange == null) {
            HTreeChart.$$$reportNull$$$0(0);
        }
        if (reducer == null) {
            HTreeChart.$$$reportNull$$$0(1);
        }
        this.mRectangles = new ArrayList<Rectangle2D.Float>();
        this.mNodes = new ArrayList<HNode<T>>();
        this.mDrawnNodes = new ArrayList<HNode<T>>();
        this.mDrawnRectangles = new ArrayList<Rectangle2D.Float>();
        this.mXRange = xRange;
        this.mRoot = new DefaultHNode();
        this.mReducer = reducer;
        this.mYRange = new Range(0.0, 0.0);
        this.mOrientation = orientation;
        this.setFocusable(true);
        this.initializeInputMap();
        this.initializeMouseEvents();
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        xRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::changed);
        this.mYRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::changed);
        this.changed();
    }

    public HTreeChart(Range xRange, Orientation orientation) {
        this(xRange, orientation, new DefaultHTreeChartReducer());
    }

    private void changed() {
        this.mRender = true;
        this.opaqueRepaint();
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        long startTime = System.nanoTime();
        if (this.mRender) {
            this.render();
            this.mRender = false;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mRoot == null || this.mRoot.getChildCount() == 0) {
            g.drawString(NO_HTREE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_HTREE), dim.height / 2);
            return;
        }
        if (this.mXRange.getLength() == 0.0) {
            g.drawString(NO_RANGE, dim.width / 2 - this.mDefaultFontMetrics.stringWidth(NO_RANGE), dim.height / 2);
            return;
        }
        if (this.myCanvas == null || (double)this.myCanvas.getHeight(null) != dim.getHeight() || (double)this.myCanvas.getWidth(null) != dim.getWidth()) {
            this.redrawToCanvas(dim);
        }
        g.drawImage(this.myCanvas, 0, 0, null);
        this.addDebugInfo("Draw time %.2fms", (double)(System.nanoTime() - startTime) / 1000000.0);
        this.addDebugInfo("# of nodes %d", this.mNodes.size());
        this.addDebugInfo("# of reduced nodes %d", this.mDrawnNodes.size());
    }

    private void redrawToCanvas(@NotNull Dimension dim) {
        Graphics2D g;
        if (dim == null) {
            HTreeChart.$$$reportNull$$$0(2);
        }
        if (this.myCanvas != null && this.myCanvas.getWidth(null) >= dim.width && this.myCanvas.getHeight(null) >= dim.height) {
            g = (Graphics2D)this.myCanvas.getGraphics();
            g.clearRect(0, 0, dim.width, dim.height);
        } else {
            this.myCanvas = this.createImage(dim.width, dim.height);
            g = (Graphics2D)this.myCanvas.getGraphics();
        }
        this.mDrawnNodes.clear();
        this.mDrawnNodes.addAll(this.mNodes);
        this.mDrawnRectangles.clear();
        for (Rectangle2D.Float rect : this.mRectangles) {
            Rectangle2D.Float newRect = new Rectangle2D.Float();
            newRect.x = rect.x * (float)dim.getWidth();
            newRect.y = rect.y;
            newRect.width = Math.max(0.0f, rect.width * (float)dim.getWidth() - 2.0f);
            newRect.height = rect.height;
            if (this.mOrientation == Orientation.BOTTOM_UP) {
                newRect.y = (float)(dim.getHeight() - (double)newRect.y - newRect.getHeight());
            }
            this.mDrawnRectangles.add(newRect);
        }
        this.mReducer.reduce(this.mDrawnRectangles, this.mDrawnNodes);
        assert (this.mDrawnRectangles.size() == this.mDrawnNodes.size());
        assert (this.mHRenderer != null);
        for (int i = 0; i < this.mDrawnNodes.size(); ++i) {
            this.mHRenderer.render(g, this.mDrawnNodes.get(i).getData(), this.mDrawnRectangles.get(i));
        }
        g.dispose();
    }

    protected void render() {
        this.mNodes.clear();
        this.mRectangles.clear();
        this.myCanvas = null;
        if (this.mRoot == null) {
            return;
        }
        if (this.inRange(this.mRoot)) {
            this.mNodes.add(this.mRoot);
            this.mRectangles.add(this.createRectangle(this.mRoot));
        }
        int head = 0;
        while (head < this.mNodes.size()) {
            HNode<T> curNode = this.mNodes.get(head++);
            for (int i = 0; i < curNode.getChildCount(); ++i) {
                HNode<T> child = curNode.getChildAt(i);
                if (!this.inRange(child)) continue;
                this.mNodes.add(child);
                this.mRectangles.add(this.createRectangle(child));
            }
        }
    }

    private boolean inRange(@NotNull HNode<T> node) {
        if (node == null) {
            HTreeChart.$$$reportNull$$$0(3);
        }
        return (double)node.getStart() <= this.mXRange.getMax() && (double)node.getEnd() >= this.mXRange.getMin();
    }

    @NotNull
    private Rectangle2D.Float createRectangle(@NotNull HNode<T> node) {
        if (node == null) {
            HTreeChart.$$$reportNull$$$0(4);
        }
        float left = (float)Math.max(0.0, ((double)node.getStart() - this.mXRange.getMin()) / this.mXRange.getLength());
        float right = (float)Math.min(1.0, ((double)node.getEnd() - this.mXRange.getMin()) / this.mXRange.getLength());
        Rectangle2D.Float rect = new Rectangle2D.Float();
        rect.x = left;
        rect.y = (float)((double)((this.mDefaultFontMetrics.getHeight() + 2) * node.getDepth()) - this.getYRange().getMin());
        rect.width = right - left;
        rect.height = this.mDefaultFontMetrics.getHeight();
        Rectangle2D.Float float_ = rect;
        if (float_ == null) {
            HTreeChart.$$$reportNull$$$0(5);
        }
        return float_;
    }

    private double positionToRange(double x) {
        return x / (double)this.getWidth() * this.getXRange().getLength() + this.getXRange().getMin();
    }

    public void setHRenderer(@NotNull HRenderer<T> r) {
        if (r == null) {
            HTreeChart.$$$reportNull$$$0(6);
        }
        this.mHRenderer = r;
        if (this.getFont() != null) {
            this.mHRenderer.setFont(this.getFont());
        } else {
            this.mHRenderer.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        }
    }

    public void setHTree(@Nullable HNode<T> root) {
        this.mRoot = root;
        this.changed();
    }

    public Range getXRange() {
        return this.mXRange;
    }

    @Nullable
    public HNode<T> getNodeAt(Point point) {
        if (point != null) {
            for (int i = 0; i < this.mDrawnNodes.size(); ++i) {
                if (!HTreeChart.contains(this.mDrawnRectangles.get(i), point)) continue;
                return this.mDrawnNodes.get(i);
            }
        }
        return null;
    }

    private static boolean contains(@NotNull Rectangle2D rectangle, @NotNull Point p) {
        if (rectangle == null) {
            HTreeChart.$$$reportNull$$$0(7);
        }
        if (p == null) {
            HTreeChart.$$$reportNull$$$0(8);
        }
        return rectangle.getMinX() <= p.getX() && p.getX() <= rectangle.getMaxX() && rectangle.getMinY() <= p.getY() && p.getY() <= rectangle.getMaxY();
    }

    @NotNull
    public Orientation getOrientation() {
        Orientation orientation = this.mOrientation;
        if (orientation == null) {
            HTreeChart.$$$reportNull$$$0(9);
        }
        return orientation;
    }

    private void initializeInputMap() {
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), ACTION_ZOOM_IN);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_ZOOM_OUT);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), ACTION_MOVE_LEFT);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), ACTION_MOVE_RIGHT);
        this.getActionMap().put(ACTION_ZOOM_IN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() + delta, HTreeChart.this.mXRange.getMax() - delta);
            }
        });
        this.getActionMap().put(ACTION_ZOOM_OUT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() - delta, HTreeChart.this.mXRange.getMax() + delta);
            }
        });
        this.getActionMap().put(ACTION_MOVE_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() - delta, HTreeChart.this.mXRange.getMax() - delta);
            }
        });
        this.getActionMap().put(ACTION_MOVE_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double delta = HTreeChart.this.mXRange.getLength() / 5.0;
                HTreeChart.this.mXRange.set(HTreeChart.this.mXRange.getMin() + delta, HTreeChart.this.mXRange.getMax() + delta);
            }
        });
    }

    private void initializeMouseEvents() {
        MouseAdapter adapter = new MouseAdapter(){
            private Point myLastPoint;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!HTreeChart.this.hasFocus()) {
                    HTreeChart.this.requestFocusInWindow();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.myLastPoint = e.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                double deltaX = e.getPoint().x - this.myLastPoint.x;
                double deltaY = e.getPoint().y - this.myLastPoint.y;
                HTreeChart.this.getYRange().shift(HTreeChart.this.getOrientation() == Orientation.BOTTOM_UP ? deltaY : -deltaY);
                HTreeChart.this.getXRange().shift(HTreeChart.this.mXRange.getLength() / (double)HTreeChart.this.getWidth() * -deltaX);
                this.myLastPoint = e.getPoint();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double cursorRange = HTreeChart.this.positionToRange(e.getX());
                double leftDelta = (cursorRange - HTreeChart.this.getXRange().getMin()) / 20.0 * (double)e.getWheelRotation();
                double rightDelta = (HTreeChart.this.getXRange().getMax() - cursorRange) / 20.0 * (double)e.getWheelRotation();
                HTreeChart.this.getXRange().setMin(HTreeChart.this.getXRange().getMin() - leftDelta);
                HTreeChart.this.getXRange().setMax(HTreeChart.this.getXRange().getMax() + rightDelta);
            }
        };
        this.addMouseWheelListener(adapter);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    public Range getYRange() {
        return this.mYRange;
    }

    public int getMaximumHeight() {
        if (this.mRoot == null) {
            return 0;
        }
        int maxDepth = -1;
        LinkedList queue = new LinkedList();
        queue.add(this.mRoot);
        while (!queue.isEmpty()) {
            HNode n = (HNode)queue.poll();
            if (n.getDepth() > maxDepth) {
                maxDepth = n.getDepth();
            }
            for (int i = 0; i < n.getChildCount(); ++i) {
                queue.add(n.getChildAt(i));
            }
        }
        return (this.mDefaultFontMetrics.getHeight() + 2) * ++maxDepth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dim";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/hchart/HTreeChart";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/hchart/HTreeChart";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRectangle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "redrawToCanvas";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRectangle";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setHRenderer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Orientation {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

