/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DurationDataRenderer<E extends DurationData>
extends AspectObserver
implements LineChartCustomRenderer {
    static final float EPSILON = 1.0E-6f;
    private static final int CLICK_REGION_PADDING_Y = 2;
    private static final int CLICK_REGION_PADDING_X = 4;
    @NotNull
    private DurationDataModel<E> myModel;
    @NotNull
    private final Color myColor;
    @Nullable
    private final Color myDurationBgColor;
    @Nullable
    private Icon myIcon;
    @Nullable
    private Stroke myStroke;
    @Nullable
    private Function<E, String> myLabelProvider;
    @Nullable
    private Consumer<E> myClickHandler;
    @Nullable
    private Color myLabelBgColor;
    @Nullable
    private Color myLabelHoveredBgColor;
    @Nullable
    private Color myLabelClickedBgColor;
    @Nullable
    private Color myLabelTextColor;
    private float myLineStrokeOffset;
    private float myLabelXOffset;
    private float myLabelYOffset;
    @NotNull
    private final List<Rectangle2D.Float> myPathCache;
    @NotNull
    private final List<E> myDataCache;
    @NotNull
    private final List<JLabel> myLabelCache;
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myCustomLineConfigs;
    @NotNull
    private final List<Rectangle2D.Float> myClickRegionCache;
    private Point myMousePosition;
    private boolean myClick;

    public DurationDataRenderer(@NotNull DurationDataModel<E> model, @NotNull Builder builder) {
        if (model == null) {
            DurationDataRenderer.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DurationDataRenderer.$$$reportNull$$$0(1);
        }
        this.myIcon = null;
        this.myStroke = null;
        this.myLabelProvider = null;
        this.myClickHandler = null;
        this.myLabelBgColor = null;
        this.myLabelHoveredBgColor = null;
        this.myLabelClickedBgColor = null;
        this.myLabelTextColor = null;
        this.myPathCache = new ArrayList<Rectangle2D.Float>();
        this.myDataCache = new ArrayList();
        this.myLabelCache = new ArrayList<JLabel>();
        this.myCustomLineConfigs = new HashMap<RangedContinuousSeries, LineConfig>();
        this.myClickRegionCache = new ArrayList<Rectangle2D.Float>();
        this.myModel = model;
        this.myColor = builder.myColor;
        this.myDurationBgColor = builder.myDurationBgColor;
        this.myIcon = builder.myIcon;
        this.myStroke = builder.myStroke;
        this.myLabelProvider = builder.myLabelProvider;
        this.myClickHandler = builder.myClickHandler;
        this.myLabelBgColor = builder.myLabelBgColor;
        this.myLabelHoveredBgColor = builder.myLabelHoveredBgColor;
        this.myLabelClickedBgColor = builder.myLabelClickedBgColor;
        this.myLabelTextColor = builder.myLabelTextColor;
        this.myLabelXOffset = builder.myLabelXOffset;
        this.myLabelYOffset = builder.myLabelYOffset;
        if (this.myStroke instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)this.myStroke;
            this.myLineStrokeOffset = stroke.getLineWidth() / 2.0f;
        } else {
            this.myLineStrokeOffset = 0.0f;
        }
        this.myModel.addDependency(this).onChange(DurationDataModel.Aspect.DURATION_DATA, this::modelChanged);
    }

    public void addCustomLineConfig(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        if (series == null) {
            DurationDataRenderer.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DurationDataRenderer.$$$reportNull$$$0(3);
        }
        this.myCustomLineConfigs.put(series, config);
    }

    LineConfig getCustomLineConfig(@NotNull RangedContinuousSeries series) {
        if (series == null) {
            DurationDataRenderer.$$$reportNull$$$0(4);
        }
        return this.myCustomLineConfigs.get(series);
    }

    private void modelChanged() {
        this.myDataCache.clear();
        this.myClickRegionCache.clear();
        this.myPathCache.clear();
        this.myLabelCache.clear();
        RangedSeries<E> series = this.myModel.getSeries();
        RangedContinuousSeries attached = this.myModel.getAttachedSeries();
        double xMin = series.getXRange().getMin();
        double xLength = series.getXRange().getLength();
        List<SeriesData<E>> seriesList = series.getSeries();
        List attachedSeriesList = attached != null ? attached.getSeries() : null;
        int j = 0;
        SeriesData lastFoundData = null;
        for (int i = 0; i < seriesList.size(); ++i) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            SeriesData<E> data = seriesList.get(i);
            double yStart = 1.0;
            double xStart = ((double)data.x - xMin) / xLength;
            double xDuration = (double)((DurationData)data.value).getDuration() / xLength;
            rect.setRect(xStart, 0.0, xDuration, 1.0);
            this.myPathCache.add(rect);
            this.myDataCache.add(data.value);
            Rectangle2D.Float clickRegion = new Rectangle2D.Float();
            this.myClickRegionCache.add(clickRegion);
            if (attachedSeriesList != null) {
                double yMin = attached.getYRange().getMin();
                double yMax = attached.getYRange().getMax();
                while (j < attachedSeriesList.size()) {
                    SeriesData seriesData = attachedSeriesList.get(j);
                    if ((float)(seriesData.x - data.x) > 1.0E-6f) {
                        if (lastFoundData == null) break;
                        assert (this.myModel.getInterpolatable() != null);
                        double adjustedY = this.myModel.getInterpolatable().interpolate(lastFoundData, seriesData, data.x);
                        yStart = 1.0 - (adjustedY - yMin) / (yMax - yMin);
                        break;
                    }
                    lastFoundData = seriesData;
                    ++j;
                }
            }
            double regionWidth = 0.0;
            double regionHeight = 0.0;
            if (this.myIcon != null) {
                regionWidth += (double)this.myIcon.getIconWidth();
                regionHeight += (double)this.myIcon.getIconHeight();
            }
            if (this.myLabelProvider != null) {
                JLabel label = new JLabel(this.myLabelProvider.apply(data.value));
                label.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(9.0f));
                label.setForeground(this.myLabelTextColor);
                Dimension size = label.getPreferredSize();
                label.setBounds(0, 0, size.width, size.height);
                this.myLabelCache.add(label);
                regionWidth += size.getWidth();
                regionHeight = Math.max(regionHeight, size.getHeight());
            }
            if (!(regionWidth > 0.0)) continue;
            clickRegion.setRect(xStart, yStart, regionWidth, regionHeight);
        }
    }

    @Override
    public void renderLines(@NotNull LineChart lineChart, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<RangedContinuousSeries> series) {
        if (lineChart == null) {
            DurationDataRenderer.$$$reportNull$$$0(5);
        }
        if (g2d == null) {
            DurationDataRenderer.$$$reportNull$$$0(6);
        }
        if (transformedPaths == null) {
            DurationDataRenderer.$$$reportNull$$$0(7);
        }
        if (series == null) {
            DurationDataRenderer.$$$reportNull$$$0(8);
        }
        if (this.myDurationBgColor != null || !this.myCustomLineConfigs.isEmpty()) {
            Shape originalClip = g2d.getClip();
            Dimension dim = lineChart.getSize();
            Rectangle2D.Float clipRect = new Rectangle2D.Float();
            ArrayList<LineConfig> configs = new ArrayList<LineConfig>(series.size());
            for (RangedContinuousSeries rangedSeries : series) {
                LineConfig config = lineChart.getLineConfig(rangedSeries);
                if (this.myCustomLineConfigs.containsKey(rangedSeries)) {
                    LineConfig customConfig = this.myCustomLineConfigs.get(rangedSeries);
                    if (config.isAdjustDash() && customConfig.isAdjustDash()) {
                        customConfig.setAdjustedDashPhase(config.getAdjustedDashPhase());
                    }
                    config = customConfig;
                }
                configs.add(config);
            }
            for (Rectangle2D.Float rect : this.myPathCache) {
                double scaledXStart = (double)rect.x * dim.getWidth();
                double scaledXDuration = (double)rect.width * dim.getWidth();
                double newX = Math.max(scaledXStart, originalClip.getBounds().getX());
                ((Rectangle2D)clipRect).setRect(newX, 0.0, Math.min(scaledXDuration + scaledXStart - newX, originalClip.getBounds().getX() + originalClip.getBounds().getWidth() - newX), dim.getHeight());
                g2d.setColor(this.myDurationBgColor == null ? lineChart.getBackground() : this.myDurationBgColor);
                g2d.fill(clipRect);
                g2d.setClip(clipRect);
                LineChart.drawLines(g2d, transformedPaths, configs);
                g2d.setClip(originalClip);
            }
        }
        if (this.myStroke != null) {
            g2d.setColor(this.myColor);
            g2d.setStroke(this.myStroke);
            Line2D.Float eventLine = new Line2D.Float();
            for (int i = 0; i < this.myPathCache.size(); ++i) {
                Rectangle2D.Float rect = this.myPathCache.get(i);
                double scaledXStart = rect.x * (float)lineChart.getWidth();
                double scaledXDuration = rect.width * (float)lineChart.getWidth();
                g2d.translate(scaledXStart, 0.0);
                ((Line2D)eventLine).setLine(0.0, 0.0, 0.0, lineChart.getHeight());
                g2d.draw(eventLine);
                ((Line2D)eventLine).setLine(scaledXDuration, 0.0, scaledXDuration, lineChart.getHeight());
                g2d.draw(eventLine);
                g2d.translate(-scaledXStart, 0.0);
            }
        }
    }

    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        if (host == null) {
            DurationDataRenderer.$$$reportNull$$$0(9);
        }
        if (g2d == null) {
            DurationDataRenderer.$$$reportNull$$$0(10);
        }
        assert (this.myClickRegionCache.size() == this.myDataCache.size());
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            float paddedHeight = rect.height + 4.0f;
            float paddedWidth = rect.width + 8.0f;
            float scaledStartX = rect.x * (float)host.getWidth() + this.myLabelXOffset + this.myLineStrokeOffset;
            float scaledStartY = this.getClampedLabelY(rect.y, paddedHeight, host.getHeight());
            if (this.myLabelBgColor != null) {
                g2d.setColor(this.myLabelBgColor);
                Rectangle2D.Float scaledRect = new Rectangle2D.Float(scaledStartX, scaledStartY, paddedWidth, paddedHeight);
                if (this.myMousePosition != null && scaledRect.contains(this.myMousePosition)) {
                    g2d.setColor(this.myClick && this.myClickHandler != null ? this.myLabelClickedBgColor : this.myLabelHoveredBgColor);
                }
                g2d.fill(scaledRect);
            }
            g2d.translate(scaledStartX += 4.0f, scaledStartY += 2.0f);
            if (this.myIcon != null) {
                this.myIcon.paintIcon(host, g2d, 0, 0);
                float shift = this.myIcon.getIconWidth();
                g2d.translate(shift, 0.0);
                scaledStartX += shift;
            }
            if (this.myLabelProvider != null) {
                this.myLabelCache.get(i).paint(g2d);
            }
            g2d.translate(-scaledStartX, -scaledStartY);
        }
        this.myClick = false;
    }

    public boolean handleMouseEvent(@NotNull MouseEvent event) {
        if (event == null) {
            DurationDataRenderer.$$$reportNull$$$0(11);
        }
        this.myMousePosition = event.getPoint();
        boolean bl = this.myClick = event.getClickCount() > 0;
        if (this.myClickHandler == null || !this.myClick) {
            return false;
        }
        assert (this.myDataCache.size() == this.myClickRegionCache.size());
        DurationData hitData = null;
        Dimension dim = event.getComponent().getSize();
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            float paddedHeight = rect.height + 4.0f;
            float paddedWidth = rect.width + 8.0f;
            float scaledY = this.getClampedLabelY(rect.y, paddedHeight, dim.height);
            Rectangle2D.Float scaledRect = new Rectangle2D.Float(rect.x * (float)dim.width + this.myLabelXOffset + this.myLineStrokeOffset, scaledY, paddedWidth, paddedWidth);
            if (!scaledRect.contains(this.myMousePosition)) continue;
            hitData = (DurationData)this.myDataCache.get(i);
            break;
        }
        if (hitData != null) {
            this.myClickHandler.accept(hitData);
            return true;
        }
        return false;
    }

    private float getClampedLabelY(float normalizedY, float height, int hostHeight) {
        float maxScaledY = (float)hostHeight - height;
        float scaledY = normalizedY * (float)hostHeight - height + this.myLabelYOffset;
        return Math.max(0.0f, Math.min(scaledY, maxScaledY));
    }

    List<Rectangle2D.Float> GetDurationDataRegions() {
        return this.myClickRegionCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "series";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineChart";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedPaths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/chart/linechart/DurationDataRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomLineConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomLineConfig";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "renderLines";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "renderOverlay";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMouseEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Builder<E extends DurationData> {
        @NotNull
        private final DurationDataModel<E> myModel;
        @NotNull
        private final Color myColor;
        @Nullable
        private Color myDurationBgColor;
        @Nullable
        private Icon myIcon;
        @Nullable
        private Stroke myStroke;
        @Nullable
        private Function<E, String> myLabelProvider;
        @Nullable
        private Consumer<E> myClickHandler;
        @Nullable
        private Color myLabelBgColor;
        @Nullable
        private Color myLabelHoveredBgColor;
        @Nullable
        private Color myLabelClickedBgColor;
        @Nullable
        private Color myLabelTextColor;
        private float myLabelXOffset;
        private float myLabelYOffset;

        public Builder(@NotNull DurationDataModel<E> model, @NotNull Color color) {
            if (model == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (color == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myIcon = null;
            this.myStroke = null;
            this.myLabelProvider = null;
            this.myClickHandler = null;
            this.myLabelBgColor = null;
            this.myLabelHoveredBgColor = null;
            this.myLabelClickedBgColor = null;
            this.myLabelTextColor = null;
            this.myModel = model;
            this.myColor = color;
        }

        public Builder<E> setDurationBg(@NotNull Color durationBgColor) {
            if (durationBgColor == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myDurationBgColor = durationBgColor;
            return this;
        }

        public Builder<E> setIcon(@NotNull Icon icon) {
            if (icon == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myIcon = icon;
            return this;
        }

        public Builder<E> setStroke(@NotNull Stroke stroke) {
            if (stroke == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myStroke = stroke;
            return this;
        }

        public Builder<E> setLabelProvider(@NotNull Function<E, String> provider) {
            if (provider == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myLabelProvider = provider;
            return this;
        }

        public Builder<E> setClickHander(@NotNull Consumer<E> handler) {
            if (handler == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myClickHandler = handler;
            return this;
        }

        public Builder<E> setLabelColors(@NotNull Color bgColor, @NotNull Color hoveredColor, @NotNull Color clickedColor, @NotNull Color color) {
            if (bgColor == null) {
                Builder.$$$reportNull$$$0(7);
            }
            if (hoveredColor == null) {
                Builder.$$$reportNull$$$0(8);
            }
            if (clickedColor == null) {
                Builder.$$$reportNull$$$0(9);
            }
            if (color == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myLabelBgColor = bgColor;
            this.myLabelHoveredBgColor = hoveredColor;
            this.myLabelClickedBgColor = clickedColor;
            this.myLabelTextColor = color;
            return this;
        }

        public Builder<E> setLabelOffsets(float xOffset, float yOffset) {
            this.myLabelXOffset = xOffset;
            this.myLabelYOffset = yOffset;
            return this;
        }

        @NotNull
        public DurationDataRenderer<E> build() {
            DurationDataRenderer<E> durationDataRenderer = new DurationDataRenderer<E>(this.myModel, this);
            if (durationDataRenderer == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return durationDataRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "durationBgColor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stroke";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bgColor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hoveredColor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickedColor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setDurationBg";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setStroke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setLabelProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setClickHander";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setLabelColors";
                    break;
                }
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

