/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.flat;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class FlatUiUtils {
    public static void paintBackground(Graphics graphics, JComponent component) {
        Graphics2D g = (Graphics2D)graphics;
        Dimension size = component.getSize();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Component opaque = UIUtil.findNearestOpaque((Component)component);
        Color bg = opaque != null ? opaque.getBackground() : component.getBackground();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 4.0, 4.0);
        if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            Color darker = ColorUtil.darker((Color)bg, (int)1);
            g.setColor(darker);
            g.fill(rect);
            g.setColor((Color)Gray.xCC);
            g.draw(rect);
        } else {
            boolean dark = UIUtil.isUnderDarcula();
            Gray color = UIUtil.isUnderWin10LookAndFeel() ? Gray.xE6 : (dark ? ColorUtil.shift((Color)bg, (double)1.4285714285714286) : Gray.xD0);
            g.setColor((Color)color);
            g.fill(rect);
            double shift = UIUtil.isUnderDarcula() ? 2.0408163265306123 : 0.49;
            g.setColor(ColorUtil.shift((Color)UIUtil.getPanelBackground(), (double)shift));
            g.draw(rect);
        }
        config.restore();
    }
}

