/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;

public class ExceptionRangeCFG {
    private final List<BasicBlock> protectedRange;
    private BasicBlock handler;
    private List<String> exceptionTypes;

    public ExceptionRangeCFG(List<BasicBlock> protectedRange, BasicBlock handler, List<String> exceptionType) {
        this.protectedRange = protectedRange;
        this.handler = handler;
        if (exceptionType != null) {
            this.exceptionTypes = new ArrayList<String>(exceptionType);
        }
    }

    public boolean isCircular() {
        return this.protectedRange.contains(this.handler);
    }

    public BasicBlock getHandler() {
        return this.handler;
    }

    public void setHandler(BasicBlock handler) {
        this.handler = handler;
    }

    public List<BasicBlock> getProtectedRange() {
        return this.protectedRange;
    }

    public List<String> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void addExceptionType(String exceptionType) {
        if (this.exceptionTypes == null) {
            return;
        }
        if (exceptionType == null) {
            this.exceptionTypes = null;
        } else {
            this.exceptionTypes.add(exceptionType);
        }
    }

    public String getUniqueExceptionsString() {
        return this.exceptionTypes != null ? this.exceptionTypes.stream().distinct().collect(Collectors.joining(":")) : null;
    }
}

