/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.DataBindingCompilerArgs;
import android.databinding.tool.util.L;
import android.databinding.tool.util.LoggedErrorException;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class GenerationalClassUtil {
    private static List[] sCache = null;
    private static List<File> sInputDirs = new ArrayList<File>();
    private static File sIncrementalOutDir;

    public static void init(DataBindingCompilerArgs args) {
        sIncrementalOutDir = StringUtils.isNotBlank(args.getAarOutFolder()) ? new File(args.getAarOutFolder(), "bin-files") : null;
        sInputDirs = new ArrayList<File>();
        if (StringUtils.isNotBlank(args.getBuildFolder())) {
            sInputDirs.add(new File(args.getBuildFolder(), "dependent-lib-artifacts"));
        }
    }

    public static <T extends Serializable> List<T> loadObjects(ExtensionFilter filter) {
        if (sCache == null) {
            GenerationalClassUtil.buildCache();
        }
        return sCache[filter.ordinal()];
    }

    private static void buildCache() {
        L.d("building generational class cache", new Object[0]);
        sCache = new List[ExtensionFilter.values().length];
        for (ExtensionFilter filter : ExtensionFilter.values()) {
            GenerationalClassUtil.sCache[filter.ordinal()] = new ArrayList();
        }
        GenerationalClassUtil.loadFromBuildInfo();
    }

    private static void loadFromBuildInfo() {
        sInputDirs.forEach(GenerationalClassUtil::loadFromDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromDirectory(File directory) {
        if (directory == null || !directory.canRead() || !directory.isDirectory()) {
            return;
        }
        for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            for (ExtensionFilter filter : ExtensionFilter.values()) {
                if (!filter.accept(file.getName())) continue;
                FileInputStream inputStream = null;
                try {
                    inputStream = FileUtils.openInputStream((File)file);
                    Serializable item = GenerationalClassUtil.fromInputStream(inputStream);
                    if (item == null) continue;
                    sCache[filter.ordinal()].add(item);
                    L.d("loaded item %s from file", item);
                }
                catch (IOException e) {
                    L.e(e, "Could not merge in Bindables from %s", file.getAbsolutePath());
                }
                catch (ClassNotFoundException e) {
                    L.e(e, "Could not read Binding properties intermediate file. %s", file.getAbsolutePath());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
    }

    private static Serializable fromInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(inputStream);
        return (Serializable)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIntermediateFile(String packageName, String fileName, Serializable object) {
        block7: {
            ObjectOutputStream oos = null;
            FileOutputStream ios = null;
            try {
                try {
                    Preconditions.checkNotNull(sIncrementalOutDir, "incremental out directory should be set to aar output directory.", new Object[0]);
                    sIncrementalOutDir.mkdirs();
                    File out = new File(sIncrementalOutDir, packageName + "-" + fileName);
                    ios = new FileOutputStream(out);
                    oos = new ObjectOutputStream(ios);
                    oos.writeObject(object);
                    oos.close();
                    L.d("wrote intermediate bindable file %s %s", packageName, fileName);
                    IOUtils.closeQuietly((OutputStream)oos);
                }
                catch (IOException e) {
                    L.e(e, "Could not write to intermediate file: %s", fileName);
                    break block7;
                }
                finally {
                    IOUtils.closeQuietly(oos);
                    IOUtils.closeQuietly(ios);
                }
                IOUtils.closeQuietly((OutputStream)ios);
            }
            catch (LoggedErrorException loggedErrorException) {
                // empty catch block
            }
        }
    }

    public static enum ExtensionFilter {
        BR("-br.bin"),
        LAYOUT("-layoutinfo.bin"),
        SETTER_STORE("-setter_store.bin");

        private final String mExtension;

        private ExtensionFilter(String extension) {
            this.mExtension = extension;
        }

        public boolean accept(String entryName) {
            return entryName.endsWith(this.mExtension);
        }

        public String getExtension() {
            return this.mExtension;
        }
    }
}

