/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageParser;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;

@VisibleForTesting
public class PackageBackwardCompatibility {
    private static final String ANDROID_TEST_MOCK = "android.test.mock";
    private static final String ANDROID_TEST_RUNNER = "android.test.runner";
    private static final String APACHE_HTTP_LEGACY = "org.apache.http.legacy";

    @VisibleForTesting
    public static void modifySharedLibraries(PackageParser.Package pkg) {
        boolean apacheHttpLegacyPresent;
        ArrayList<String> usesLibraries = pkg.usesLibraries;
        ArrayList<String> usesOptionalLibraries = pkg.usesOptionalLibraries;
        if (PackageBackwardCompatibility.apkTargetsApiLevelLessThanOrEqualToOMR1(pkg) && !(apacheHttpLegacyPresent = PackageBackwardCompatibility.isLibraryPresent(usesLibraries, usesOptionalLibraries, APACHE_HTTP_LEGACY))) {
            usesLibraries = ArrayUtils.add(usesLibraries, APACHE_HTTP_LEGACY);
        }
        boolean androidTestMockPresent = PackageBackwardCompatibility.isLibraryPresent(usesLibraries, usesOptionalLibraries, ANDROID_TEST_MOCK);
        if (ArrayUtils.contains(usesLibraries, ANDROID_TEST_RUNNER) && !androidTestMockPresent) {
            usesLibraries.add(ANDROID_TEST_MOCK);
        }
        if (ArrayUtils.contains(usesOptionalLibraries, ANDROID_TEST_RUNNER) && !androidTestMockPresent) {
            usesOptionalLibraries.add(ANDROID_TEST_MOCK);
        }
        pkg.usesLibraries = usesLibraries;
        pkg.usesOptionalLibraries = usesOptionalLibraries;
    }

    private static boolean apkTargetsApiLevelLessThanOrEqualToOMR1(PackageParser.Package pkg) {
        int targetSdkVersion = pkg.applicationInfo.targetSdkVersion;
        return targetSdkVersion <= 27;
    }

    private static boolean isLibraryPresent(ArrayList<String> usesLibraries, ArrayList<String> usesOptionalLibraries, String apacheHttpLegacy) {
        return ArrayUtils.contains(usesLibraries, apacheHttpLegacy) || ArrayUtils.contains(usesOptionalLibraries, apacheHttpLegacy);
    }
}

