/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.FontResourcesParser;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.graphics.Typeface_Delegate;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.provider.FontRequest;
import android.provider.FontsContract;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface {
    private static String TAG = "Typeface";
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    @GuardedBy(value="sStyledCacheLock")
    private static final LongSparseArray<SparseArray<Typeface>> sStyledTypefaceCache;
    private static final Object sStyledCacheLock;
    @GuardedBy(value="sWeightCacheLock")
    private static final LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static final Object sWeightCacheLock;
    @GuardedBy(value="sDynamicCacheLock")
    public static final LruCache<String, Typeface> sDynamicTypefaceCache;
    private static final Object sDynamicCacheLock;
    static Typeface sDefaultTypeface;
    static final Map<String, Typeface> sSystemFontMap;
    static final Map<String, FontFamily[]> sSystemFallbackMap;
    public long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    public static final int STYLE_MASK = 3;
    private int mStyle = 0;
    private int mWeight = 0;
    public static final int RESOLVE_BY_FONT_TABLE = -1;
    private static final String DEFAULT_FAMILY = "sans-serif";
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_ITALIC = 1;
    private int[] mSupportedAxes;
    private static final int[] EMPTY_AXES;

    private static void setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    @VisibleForTesting
    public int getWeight() {
        return this.mWeight;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(AssetManager mgr, String path, int cookie) {
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, DEFAULT_FAMILY);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
            FontFamily fontFamily = new FontFamily();
            if (fontFamily.addFontFromAssetManager(mgr, path, cookie, false, 0, -1, -1, null)) {
                if (!fontFamily.freeze()) {
                    return null;
                }
                FontFamily[] families = new FontFamily[]{fontFamily};
                typeface = Typeface.createFromFamiliesWithDefault(families, DEFAULT_FAMILY, -1, -1);
                sDynamicTypefaceCache.put(key, typeface);
                return typeface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(FontResourcesParser.FamilyResourceEntry entry, AssetManager mgr, String path) {
        if (entry instanceof FontResourcesParser.ProviderResourceEntry) {
            FontRequest request;
            Typeface typeface;
            FontResourcesParser.ProviderResourceEntry providerEntry = (FontResourcesParser.ProviderResourceEntry)entry;
            List<List<String>> givenCerts = providerEntry.getCerts();
            ArrayList<List<byte[]>> certs = new ArrayList<List<byte[]>>();
            if (givenCerts != null) {
                for (int i = 0; i < givenCerts.size(); ++i) {
                    List<String> certSet = givenCerts.get(i);
                    ArrayList<byte[]> byteArraySet = new ArrayList<byte[]>();
                    for (int j = 0; j < certSet.size(); ++j) {
                        byteArraySet.add(Base64.decode(certSet.get(j), 0));
                    }
                    certs.add(byteArraySet);
                }
            }
            return (typeface = FontsContract.getFontSync(request = new FontRequest(providerEntry.getAuthority(), providerEntry.getPackage(), providerEntry.getQuery(), certs))) == null ? DEFAULT : typeface;
        }
        Typeface typeface = Typeface.findFromCache(mgr, path);
        if (typeface != null) {
            return typeface;
        }
        FontResourcesParser.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParser.FontFamilyFilesResourceEntry)entry;
        FontFamily fontFamily = new FontFamily();
        for (FontResourcesParser.FontFileResourceEntry fontFile : filesEntry.getEntries()) {
            if (fontFamily.addFontFromAssetManager(mgr, fontFile.getFileName(), 0, false, 0, fontFile.getWeight(), fontFile.getItalic(), null)) continue;
            return null;
        }
        if (!fontFamily.freeze()) {
            return null;
        }
        FontFamily[] familyChain = new FontFamily[]{fontFamily};
        typeface = Typeface.createFromFamiliesWithDefault(familyChain, DEFAULT_FAMILY, -1, -1);
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, DEFAULT_FAMILY);
            sDynamicTypefaceCache.put(key, typeface);
        }
        return typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface findFromCache(AssetManager mgr, String path) {
        Object object = sDynamicCacheLock;
        synchronized (object) {
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, DEFAULT_FAMILY);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    public static Typeface create_Original(String familyName, int style2) {
        return Typeface.create(sSystemFontMap.get(familyName), style2);
    }

    @LayoutlibDelegate
    public static Typeface create(String string2, int n) {
        return Typeface_Delegate.create(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface create_Original(Typeface family, int style2) {
        Typeface typeface;
        if ((style2 & 0xFFFFFFFC) != 0) {
            style2 = 0;
        }
        if (family == null) {
            family = sDefaultTypeface;
        }
        if (family.mStyle == style2) {
            return family;
        }
        long ni = family.native_instance;
        Object object = sStyledCacheLock;
        synchronized (object) {
            SparseArray<Typeface> styles = sStyledTypefaceCache.get(ni);
            if (styles == null) {
                styles = new SparseArray(4);
                sStyledTypefaceCache.put(ni, styles);
            } else {
                typeface = styles.get(style2);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
            styles.put(style2, typeface);
        }
        return typeface;
    }

    @LayoutlibDelegate
    public static Typeface create(Typeface typeface, int n) {
        return Typeface_Delegate.create(typeface, n);
    }

    public static Typeface create_Original(Typeface family, int weight, boolean italic) {
        Preconditions.checkArgumentInRange(weight, 0, 1000, "weight");
        if (family == null) {
            family = sDefaultTypeface;
        }
        return Typeface.createWeightStyle(family, weight, italic);
    }

    @LayoutlibDelegate
    public static Typeface create(Typeface typeface, int n, boolean bl) {
        return Typeface_Delegate.create(typeface, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Typeface createWeightStyle(Typeface base, int weight, boolean italic) {
        Typeface typeface;
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            SparseArray<Typeface> innerCache = sWeightTypefaceCache.get(base.native_instance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(base.native_instance, innerCache);
            } else {
                typeface = innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = new Typeface(Typeface.nativeCreateFromTypefaceWithExactStyle(base.native_instance, weight, italic));
            innerCache.put(key, typeface);
        }
        return typeface;
    }

    public static Typeface createFromTypefaceWithVariation(Typeface family, List<FontVariationAxis> axes) {
        long ni = family == null ? 0L : family.native_instance;
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(ni, axes));
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromAsset(AssetManager mgr, String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        Object object = sDynamicCacheLock;
        synchronized (object) {
            Typeface typeface = new Builder(mgr, path).build();
            if (typeface != null) {
                return typeface;
            }
            String key = Builder.createAssetUid(mgr, path, 0, null, -1, -1, DEFAULT_FAMILY);
            typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
            FontFamily fontFamily = new FontFamily();
            if (fontFamily.addFontFromAssetManager(mgr, path, 0, true, 0, -1, -1, null)) {
                fontFamily.allowUnsupportedFont();
                fontFamily.freeze();
                FontFamily[] families = new FontFamily[]{fontFamily};
                typeface = Typeface.createFromFamiliesWithDefault(families, DEFAULT_FAMILY, -1, -1);
                sDynamicTypefaceCache.put(key, typeface);
                return typeface;
            }
            fontFamily.abortCreation();
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    private static String createProviderUid(String authority, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("provider:");
        builder.append(authority);
        builder.append("-");
        builder.append(query);
        return builder.toString();
    }

    public static Typeface createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    public static Typeface createFromFile(String path) {
        FontFamily fontFamily = new FontFamily();
        if (fontFamily.addFont(path, 0, null, -1, -1)) {
            fontFamily.allowUnsupportedFont();
            fontFamily.freeze();
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families, DEFAULT_FAMILY, -1, -1);
        }
        fontFamily.abortCreation();
        throw new RuntimeException("Font not found " + path);
    }

    private static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1));
    }

    private static Typeface createFromFamiliesWithDefault(FontFamily[] families, String fallbackName, int weight, int italic) {
        int i;
        FontFamily[] fallback = sSystemFallbackMap.get(fallbackName);
        if (fallback == null) {
            fallback = sSystemFallbackMap.get(DEFAULT_FAMILY);
        }
        long[] ptrArray = new long[families.length + fallback.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < fallback.length; ++i) {
            ptrArray[i + families.length] = fallback[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray, weight, italic));
    }

    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
        this.mWeight = Typeface.nativeGetWeight(ni);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ByteBuffer mmap(String fullPath) {
        try (FileInputStream file = new FileInputStream(fullPath);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            return mappedByteBuffer;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + fullPath);
            return null;
        }
    }

    static FontFamily createFontFamily_Original(String familyName, List<FontConfig.Font> fonts, String[] languageTags, int variant, Map<String, ByteBuffer> cache, String fontDir) {
        FontFamily family = new FontFamily(languageTags, variant);
        for (int i = 0; i < fonts.size(); ++i) {
            FontConfig.Font font = fonts.get(i);
            String fullPath = fontDir + font.getFontName();
            ByteBuffer buffer = cache.get(fullPath);
            if (buffer == null) {
                if (cache.containsKey(fullPath)) continue;
                buffer = Typeface.mmap(fullPath);
                cache.put(fullPath, buffer);
                if (buffer == null) continue;
            }
            if (family.addFontFromBuffer(buffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0)) continue;
            Log.e(TAG, "Error creating font " + fullPath + "#" + font.getTtcIndex());
        }
        if (!family.freeze()) {
            Log.e(TAG, "Unable to load Family: " + familyName + " : " + Arrays.toString(languageTags));
            return null;
        }
        return family;
    }

    @LayoutlibDelegate
    private static FontFamily createFontFamily(String string2, List<FontConfig.Font> list, String[] stringArray, int n, Map<String, ByteBuffer> map, String string3) {
        return Typeface_Delegate.createFontFamily(string2, list, stringArray, n, map, string3);
    }

    private static void pushFamilyToFallback(FontConfig.Family xmlFamily, ArrayMap<String, ArrayList<FontFamily>> fallbackMap, Map<String, ByteBuffer> cache, String fontDir) {
        String[] languageTags = xmlFamily.getLanguages();
        int variant = xmlFamily.getVariant();
        ArrayList<FontConfig.Font> defaultFonts = new ArrayList<FontConfig.Font>();
        ArrayMap<String, ArrayList<FontConfig.Font>> specificFallbackFonts = new ArrayMap<String, ArrayList<FontConfig.Font>>();
        for (FontConfig.Font font : xmlFamily.getFonts()) {
            String fallbackName = font.getFallbackFor();
            if (fallbackName == null) {
                defaultFonts.add(font);
                continue;
            }
            ArrayList<FontConfig.Font> fallback = (ArrayList<FontConfig.Font>)specificFallbackFonts.get(fallbackName);
            if (fallback == null) {
                fallback = new ArrayList<FontConfig.Font>();
                specificFallbackFonts.put(fallbackName, fallback);
            }
            fallback.add(font);
        }
        FontFamily defaultFamily = defaultFonts.isEmpty() ? null : Typeface.createFontFamily(xmlFamily.getName(), defaultFonts, languageTags, variant, cache, fontDir);
        for (int i = 0; i < fallbackMap.size(); ++i) {
            ArrayList fallback = (ArrayList)specificFallbackFonts.get(fallbackMap.keyAt(i));
            if (fallback == null) {
                if (defaultFamily == null) continue;
                fallbackMap.valueAt(i).add(defaultFamily);
                continue;
            }
            FontFamily family = Typeface.createFontFamily(xmlFamily.getName(), fallback, languageTags, variant, cache, fontDir);
            if (family == null) continue;
            fallbackMap.valueAt(i).add(family);
        }
    }

    @VisibleForTesting
    public static void buildSystemFallback_Original(String xmlPath, String fontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, FontFamily[]> fallbackMap) {
        try {
            int i;
            FileInputStream fontsIn = new FileInputStream(xmlPath);
            FontConfig fontConfig = FontListParser.parse(fontsIn);
            HashMap<String, ByteBuffer> bufferCache = new HashMap<String, ByteBuffer>();
            FontConfig.Family[] xmlFamilies = fontConfig.getFamilies();
            ArrayMap<String, ArrayList<FontFamily>> fallbackListMap = new ArrayMap<String, ArrayList<FontFamily>>();
            for (FontConfig.Family xmlFamily : xmlFamilies) {
                FontFamily family;
                String familyName = xmlFamily.getName();
                if (familyName == null || (family = Typeface.createFontFamily(xmlFamily.getName(), Arrays.asList(xmlFamily.getFonts()), xmlFamily.getLanguages(), xmlFamily.getVariant(), bufferCache, fontDir)) == null) continue;
                ArrayList<FontFamily> fallback = new ArrayList<FontFamily>();
                fallback.add(family);
                fallbackListMap.put(familyName, fallback);
            }
            for (i = 0; i < xmlFamilies.length; ++i) {
                FontConfig.Family xmlFamily = xmlFamilies[i];
                if (i != 0 && xmlFamily.getName() != null) continue;
                Typeface.pushFamilyToFallback(xmlFamily, fallbackListMap, bufferCache, fontDir);
            }
            for (i = 0; i < fallbackListMap.size(); ++i) {
                String fallbackName = (String)fallbackListMap.keyAt(i);
                List familyList = fallbackListMap.valueAt(i);
                FontFamily[] families = familyList.toArray(new FontFamily[familyList.size()]);
                fallbackMap.put(fallbackName, families);
                long[] ptrArray = new long[families.length];
                for (int j = 0; j < families.length; ++j) {
                    ptrArray[j] = families[j].mNativePtr;
                }
                fontMap.put(fallbackName, new Typeface(Typeface.nativeCreateFromArray(ptrArray, -1, -1)));
            }
            for (FontConfig.Alias alias : fontConfig.getAliases()) {
                Typeface base;
                Typeface newFace = base = fontMap.get(alias.getToName());
                int weight = alias.getWeight();
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                fontMap.put(alias.getName(), newFace);
            }
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + xmlPath, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + xmlPath, e);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + xmlPath, e);
        }
    }

    @LayoutlibDelegate
    public static void buildSystemFallback(String string2, String string3, ArrayMap<String, Typeface> arrayMap, ArrayMap<String, FontFamily[]> arrayMap2) {
        Typeface_Delegate.buildSystemFallback(string2, string3, arrayMap, arrayMap2);
    }

    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
            this.native_instance = 0L;
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedAxes(int axis) {
        if (this.mSupportedAxes == null) {
            Typeface typeface = this;
            synchronized (typeface) {
                if (this.mSupportedAxes == null) {
                    this.mSupportedAxes = Typeface.nativeGetSupportedAxes(this.native_instance);
                    if (this.mSupportedAxes == null) {
                        this.mSupportedAxes = EMPTY_AXES;
                    }
                }
            }
        }
        return Arrays.binarySearch(this.mSupportedAxes, axis) >= 0;
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypeface(long l, int n) {
        return Typeface_Delegate.nativeCreateFromTypeface(l, n);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypefaceWithExactStyle(long l, int n, boolean bl) {
        return Typeface_Delegate.nativeCreateFromTypefaceWithExactStyle(l, n, bl);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromTypefaceWithVariation(long l, List<FontVariationAxis> list) {
        return Typeface_Delegate.nativeCreateFromTypefaceWithVariation(l, list);
    }

    @LayoutlibDelegate
    private static long nativeCreateWeightAlias(long l, int n) {
        return Typeface_Delegate.nativeCreateWeightAlias(l, n);
    }

    @LayoutlibDelegate
    private static void nativeUnref(long l) {
        Typeface_Delegate.nativeUnref(l);
    }

    @LayoutlibDelegate
    private static int nativeGetStyle(long l) {
        return Typeface_Delegate.nativeGetStyle(l);
    }

    @LayoutlibDelegate
    private static int nativeGetWeight(long l) {
        return Typeface_Delegate.nativeGetWeight(l);
    }

    @LayoutlibDelegate
    private static long nativeCreateFromArray(long[] lArray, int n, int n2) {
        return Typeface_Delegate.nativeCreateFromArray(lArray, n, n2);
    }

    @LayoutlibDelegate
    private static void nativeSetDefault(long l) {
        Typeface_Delegate.nativeSetDefault(l);
    }

    @LayoutlibDelegate
    private static int[] nativeGetSupportedAxes(long l) {
        return Typeface_Delegate.nativeGetSupportedAxes(l);
    }

    static {
        sStyledTypefaceCache = new LongSparseArray(3);
        sStyledCacheLock = new Object();
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
        sDynamicTypefaceCache = new LruCache(16);
        sDynamicCacheLock = new Object();
        EMPTY_AXES = new int[0];
        ArrayMap<String, Typeface> systemFontMap = new ArrayMap<String, Typeface>();
        ArrayMap<String, FontFamily[]> systemFallbackMap = new ArrayMap<String, FontFamily[]>();
        Typeface.buildSystemFallback("/system/etc/fonts.xml", "/system/fonts/", systemFontMap, systemFallbackMap);
        sSystemFontMap = Collections.unmodifiableMap(systemFontMap);
        sSystemFallbackMap = Collections.unmodifiableMap(systemFallbackMap);
        Typeface.setDefault(sSystemFontMap.get(DEFAULT_FAMILY));
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create(DEFAULT_FAMILY, 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }

    public static class Builder {
        public static final int NORMAL_WEIGHT = 400;
        public static final int BOLD_WEIGHT = 700;
        private int mTtcIndex;
        private FontVariationAxis[] mAxes;
        private AssetManager mAssetManager;
        private String mPath;
        private FileDescriptor mFd;
        private FontsContract.FontInfo[] mFonts;
        private Map<Uri, ByteBuffer> mFontBuffers;
        private String mFallbackFamilyName;
        private int mWeight = -1;
        private int mItalic = -1;

        public Builder(File path) {
            this.mPath = path.getAbsolutePath();
        }

        public Builder(FileDescriptor fd) {
            this.mFd = fd;
        }

        public Builder(String path) {
            this.mPath = path;
        }

        public Builder(AssetManager assetManager, String path) {
            this.mAssetManager = Preconditions.checkNotNull(assetManager);
            this.mPath = Preconditions.checkStringNotEmpty(path);
        }

        public Builder(FontsContract.FontInfo[] fonts, Map<Uri, ByteBuffer> buffers) {
            this.mFonts = fonts;
            this.mFontBuffers = buffers;
        }

        public Builder setWeight(int weight) {
            this.mWeight = weight;
            return this;
        }

        public Builder setItalic(boolean italic) {
            this.mItalic = italic ? 1 : 0;
            return this;
        }

        public Builder setTtcIndex(int ttcIndex) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("TTC index can not be specified for FontResult source.");
            }
            this.mTtcIndex = ttcIndex;
            return this;
        }

        public Builder setFontVariationSettings(String variationSettings) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = FontVariationAxis.fromFontVariationSettings(variationSettings);
            return this;
        }

        public Builder setFontVariationSettings(FontVariationAxis[] axes) {
            if (this.mFonts != null) {
                throw new IllegalArgumentException("Font variation settings can not be specified for FontResult source.");
            }
            if (this.mAxes != null) {
                throw new IllegalStateException("Font variation settings are already set.");
            }
            this.mAxes = axes;
            return this;
        }

        public Builder setFallback(String familyName) {
            this.mFallbackFamilyName = familyName;
            return this;
        }

        private static String createAssetUid(AssetManager mgr, String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic, String fallback) {
            SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
            StringBuilder builder = new StringBuilder();
            int size = pkgs.size();
            for (int i = 0; i < size; ++i) {
                builder.append(pkgs.valueAt(i));
                builder.append("-");
            }
            builder.append(path);
            builder.append("-");
            builder.append(Integer.toString(ttcIndex));
            builder.append("-");
            builder.append(Integer.toString(weight));
            builder.append("-");
            builder.append(Integer.toString(italic));
            builder.append("--");
            builder.append(fallback);
            builder.append("--");
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    builder.append(axis.getTag());
                    builder.append("-");
                    builder.append(Float.toString(axis.getStyleValue()));
                }
            }
            return builder.toString();
        }

        private Typeface resolveFallbackTypeface() {
            int weight;
            if (this.mFallbackFamilyName == null) {
                return null;
            }
            Typeface base = sSystemFontMap.get(this.mFallbackFamilyName);
            if (base == null) {
                base = sDefaultTypeface;
            }
            if (this.mWeight == -1 && this.mItalic == -1) {
                return base;
            }
            int n = weight = this.mWeight == -1 ? base.mWeight : this.mWeight;
            boolean italic = this.mItalic == -1 ? (base.mStyle & 2) != 0 : this.mItalic == 1;
            return Typeface.createWeightStyle(base, weight, italic);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Typeface build() {
            if (this.mFd != null) {
                try (FileInputStream fis = new FileInputStream(this.mFd);){
                    FileChannel channel = fis.getChannel();
                    long size = channel.size();
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromBuffer(buffer, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                        fontFamily.abortCreation();
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    if (!fontFamily.freeze()) {
                        Typeface typeface = this.resolveFallbackTypeface();
                        return typeface;
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    Typeface typeface = Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
                    return typeface;
                }
                catch (IOException e) {
                    return this.resolveFallbackTypeface();
                }
            }
            if (this.mAssetManager != null) {
                String key = Builder.createAssetUid(this.mAssetManager, this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic, this.mFallbackFamilyName);
                Object object = sDynamicCacheLock;
                synchronized (object) {
                    Typeface typeface = (Typeface)sDynamicTypefaceCache.get(key);
                    if (typeface != null) {
                        return typeface;
                    }
                    FontFamily fontFamily = new FontFamily();
                    if (!fontFamily.addFontFromAssetManager(this.mAssetManager, this.mPath, this.mTtcIndex, true, this.mTtcIndex, this.mWeight, this.mItalic, this.mAxes)) {
                        fontFamily.abortCreation();
                        return this.resolveFallbackTypeface();
                    }
                    if (!fontFamily.freeze()) {
                        return this.resolveFallbackTypeface();
                    }
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
            if (this.mPath != null) {
                FontFamily fontFamily = new FontFamily();
                if (!fontFamily.addFont(this.mPath, this.mTtcIndex, this.mAxes, this.mWeight, this.mItalic)) {
                    fontFamily.abortCreation();
                    return this.resolveFallbackTypeface();
                }
                if (!fontFamily.freeze()) {
                    return this.resolveFallbackTypeface();
                }
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
            }
            if (this.mFonts == null) throw new IllegalArgumentException("No source was set.");
            FontFamily fontFamily = new FontFamily();
            boolean atLeastOneFont = false;
            for (FontsContract.FontInfo font : this.mFonts) {
                ByteBuffer fontBuffer = this.mFontBuffers.get(font.getUri());
                if (fontBuffer == null) continue;
                boolean success = fontFamily.addFontFromBuffer(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic() ? 1 : 0);
                if (!success) {
                    fontFamily.abortCreation();
                    return null;
                }
                atLeastOneFont = true;
            }
            if (!atLeastOneFont) {
                fontFamily.abortCreation();
                return null;
            }
            fontFamily.freeze();
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families, this.mFallbackFamilyName, this.mWeight, this.mItalic);
        }
    }
}

