/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Rect;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.OutputStream;

public class YuvImage {
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private int mFormat;
    private byte[] mData;
    private int[] mStrides;
    private int mWidth;
    private int mHeight;

    public YuvImage(byte[] yuv, int format, int width, int height, int[] strides) {
        if (format != 17 && format != 20) {
            throw new IllegalArgumentException("only support ImageFormat.NV21 and ImageFormat.YUY2 for now");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must large than 0");
        }
        if (yuv == null) {
            throw new IllegalArgumentException("yuv cannot be null");
        }
        this.mStrides = strides == null ? this.calculateStrides(width, format) : strides;
        this.mData = yuv;
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
    }

    public boolean compressToJpeg(Rect rectangle, int quality, OutputStream stream) {
        Rect wholeImage = new Rect(0, 0, this.mWidth, this.mHeight);
        if (!wholeImage.contains(rectangle)) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.adjustRectangle(rectangle);
        int[] offsets = this.calculateOffsets(rectangle.left, rectangle.top);
        return YuvImage.nativeCompressToJpeg(this.mData, this.mFormat, rectangle.width(), rectangle.height(), offsets, this.mStrides, quality, stream, new byte[4096]);
    }

    public byte[] getYuvData() {
        return this.mData;
    }

    public int getYuvFormat() {
        return this.mFormat;
    }

    public int[] getStrides() {
        return this.mStrides;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    int[] calculateOffsets(int left, int top) {
        int[] offsets = null;
        if (this.mFormat == 17) {
            offsets = new int[]{top * this.mStrides[0] + left, this.mHeight * this.mStrides[0] + top / 2 * this.mStrides[1] + left / 2 * 2};
            return offsets;
        }
        if (this.mFormat == 20) {
            offsets = new int[]{top * this.mStrides[0] + left / 2 * 4};
            return offsets;
        }
        return offsets;
    }

    private int[] calculateStrides(int width, int format) {
        int[] strides = null;
        if (format == 17) {
            strides = new int[]{width, width};
            return strides;
        }
        if (format == 20) {
            strides = new int[]{width * 2};
            return strides;
        }
        return strides;
    }

    private void adjustRectangle(Rect rect) {
        int width = rect.width();
        int height = rect.height();
        if (this.mFormat == 17) {
            rect.left &= 0xFFFFFFFE;
            rect.top &= 0xFFFFFFFE;
            rect.right = rect.left + (width &= 0xFFFFFFFE);
            rect.bottom = rect.top + (height &= 0xFFFFFFFE);
        }
        if (this.mFormat == 20) {
            rect.left &= 0xFFFFFFFE;
            rect.right = rect.left + (width &= 0xFFFFFFFE);
        }
    }

    private static boolean nativeCompressToJpeg(byte[] byArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, OutputStream outputStream, byte[] byArray2) {
        return OverrideMethod.invokeI("android.graphics.YuvImage#nativeCompressToJpeg([BIII[I[IILjava/io/OutputStream;[B)Z", true, null) != 0;
    }
}

