/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.AffixPatternUtils;
import android.icu.impl.number.Modifier;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.impl.number.formatters.PositiveNegativeAffixFormat;
import android.icu.impl.number.modifiers.ConstantAffixModifier;
import android.icu.impl.number.modifiers.ConstantMultiFieldModifier;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;

public class PNAffixGenerator {
    protected static final ThreadLocal<PNAffixGenerator> threadLocalInstance = new ThreadLocal<PNAffixGenerator>(){

        @Override
        protected PNAffixGenerator initialValue() {
            return new PNAffixGenerator();
        }
    };
    private Result resultInstance = new Result();
    private NumberStringBuilder sb1 = new NumberStringBuilder();
    private NumberStringBuilder sb2 = new NumberStringBuilder();
    private NumberStringBuilder sb3 = new NumberStringBuilder();
    private NumberStringBuilder sb4 = new NumberStringBuilder();
    private NumberStringBuilder sb5 = new NumberStringBuilder();
    private NumberStringBuilder sb6 = new NumberStringBuilder();

    public static PNAffixGenerator getThreadLocalInstance() {
        return threadLocalInstance.get();
    }

    public Result getModifiers(DecimalFormatSymbols symbols, PositiveNegativeAffixFormat.IProperties properties) {
        return this.getModifiers(symbols, symbols.getCurrencySymbol(), symbols.getInternationalCurrencySymbol(), symbols.getCurrencySymbol(), properties);
    }

    public Result getModifiers(DecimalFormatSymbols symbols, String currencySymbol, PositiveNegativeAffixFormat.IProperties properties) {
        return this.getModifiers(symbols, currencySymbol, currencySymbol, currencySymbol, properties);
    }

    public Result getModifiers(DecimalFormatSymbols symbols, String curr1, String curr2, String curr3, PositiveNegativeAffixFormat.IProperties properties) {
        if (properties.getSignAlwaysShown()) {
            return this.getModifiersWithPlusSign(symbols, curr1, curr2, curr3, properties);
        }
        String ppp = properties.getPositivePrefixPattern();
        String psp = properties.getPositiveSuffixPattern();
        String npp = properties.getNegativePrefixPattern();
        String nsp = properties.getNegativeSuffixPattern();
        this.sb1.clear();
        this.sb2.clear();
        AffixPatternUtils.unescape(ppp, symbols, curr1, curr2, curr3, null, this.sb1);
        AffixPatternUtils.unescape(psp, symbols, curr1, curr2, curr3, null, this.sb2);
        this.setPositiveResult(this.sb1, this.sb2, properties);
        if (npp == null && nsp == null) {
            this.sb1.insert(0, symbols.getMinusSignString(), NumberFormat.Field.SIGN);
        } else {
            this.sb1.clear();
            this.sb2.clear();
            AffixPatternUtils.unescape(npp, symbols, curr1, curr2, curr3, null, this.sb1);
            AffixPatternUtils.unescape(nsp, symbols, curr1, curr2, curr3, null, this.sb2);
        }
        this.setNegativeResult(this.sb1, this.sb2, properties);
        return this.resultInstance;
    }

    private Result getModifiersWithPlusSign(DecimalFormatSymbols symbols, String curr1, String curr2, String curr3, PositiveNegativeAffixFormat.IProperties properties) {
        String ppp = properties.getPositivePrefixPattern();
        String psp = properties.getPositiveSuffixPattern();
        String npp = properties.getNegativePrefixPattern();
        String nsp = properties.getNegativeSuffixPattern();
        if (npp != null || nsp != null) {
            this.sb1.clear();
            this.sb2.clear();
            this.sb3.clear();
            this.sb4.clear();
            AffixPatternUtils.unescape(npp, symbols, curr1, curr2, curr3, null, this.sb1);
            AffixPatternUtils.unescape(nsp, symbols, curr1, curr2, curr3, null, this.sb2);
            AffixPatternUtils.unescape(npp, symbols, curr1, curr2, curr3, symbols.getPlusSignString(), this.sb3);
            AffixPatternUtils.unescape(nsp, symbols, curr1, curr2, curr3, symbols.getPlusSignString(), this.sb4);
            if (!PNAffixGenerator.charSequenceEquals(this.sb1, this.sb3) || !PNAffixGenerator.charSequenceEquals(this.sb2, this.sb4)) {
                this.setPositiveResult(this.sb3, this.sb4, properties);
                this.setNegativeResult(this.sb1, this.sb2, properties);
                return this.resultInstance;
            }
            this.setNegativeResult(this.sb1, this.sb2, properties);
        }
        this.sb1.clear();
        this.sb2.clear();
        AffixPatternUtils.unescape(ppp, symbols, curr1, curr2, curr3, null, this.sb1);
        AffixPatternUtils.unescape(psp, symbols, curr1, curr2, curr3, null, this.sb2);
        if (npp == null && nsp == null) {
            this.sb3.clear();
            this.sb3.append(symbols.getMinusSignString(), NumberFormat.Field.SIGN);
            this.sb3.append(this.sb1);
            this.setNegativeResult(this.sb3, this.sb2, properties);
        }
        this.sb1.insert(0, symbols.getPlusSignString(), NumberFormat.Field.SIGN);
        this.setPositiveResult(this.sb1, this.sb2, properties);
        return this.resultInstance;
    }

    private void setPositiveResult(NumberStringBuilder prefix, NumberStringBuilder suffix, PositiveNegativeAffixFormat.IProperties properties) {
        String _prefix = properties.getPositivePrefix();
        String _suffix = properties.getPositiveSuffix();
        if (_prefix != null) {
            prefix = this.sb5.clear();
            prefix.append(_prefix, null);
        }
        if (_suffix != null) {
            suffix = this.sb6.clear();
            suffix.append(_suffix, null);
        }
        if (prefix.length() == 0 && suffix.length() == 0) {
            this.resultInstance.positive = ConstantAffixModifier.EMPTY;
            return;
        }
        if (this.resultInstance.positive != null && this.resultInstance.positive instanceof ConstantMultiFieldModifier && ((ConstantMultiFieldModifier)this.resultInstance.positive).contentEquals(prefix, suffix)) {
            return;
        }
        this.resultInstance.positive = new ConstantMultiFieldModifier(prefix, suffix, false);
    }

    private void setNegativeResult(NumberStringBuilder prefix, NumberStringBuilder suffix, PositiveNegativeAffixFormat.IProperties properties) {
        String _prefix = properties.getNegativePrefix();
        String _suffix = properties.getNegativeSuffix();
        if (_prefix != null) {
            prefix = this.sb5.clear();
            prefix.append(_prefix, null);
        }
        if (_suffix != null) {
            suffix = this.sb6.clear();
            suffix.append(_suffix, null);
        }
        if (prefix.length() == 0 && suffix.length() == 0) {
            this.resultInstance.negative = ConstantAffixModifier.EMPTY;
            return;
        }
        if (this.resultInstance.negative != null && this.resultInstance.negative instanceof ConstantMultiFieldModifier && ((ConstantMultiFieldModifier)this.resultInstance.negative).contentEquals(prefix, suffix)) {
            return;
        }
        this.resultInstance.negative = new ConstantMultiFieldModifier(prefix, suffix, false);
    }

    private static boolean charSequenceEquals(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static class Result {
        public Modifier.AffixModifier positive = null;
        public Modifier.AffixModifier negative = null;
    }
}

