/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number.formatters;

import android.icu.impl.number.Rounder;
import android.icu.impl.number.rounders.IncrementRounder;
import android.icu.impl.number.rounders.MagnitudeRounder;
import android.icu.impl.number.rounders.NoRounder;
import android.icu.impl.number.rounders.SignificantDigitsRounder;

public class RoundingFormat {
    public static Rounder getDefaultOrNoRounder(IProperties properties) {
        Rounder candidate = RoundingFormat.getDefaultOrNull(properties);
        if (candidate == null) {
            candidate = NoRounder.getInstance(properties);
        }
        return candidate;
    }

    public static Rounder getDefaultOrNull(IProperties properties) {
        if (SignificantDigitsRounder.useSignificantDigits(properties)) {
            return SignificantDigitsRounder.getInstance(properties);
        }
        if (IncrementRounder.useRoundingIncrement(properties)) {
            return IncrementRounder.getInstance(properties);
        }
        if (MagnitudeRounder.useFractionFormat(properties)) {
            return MagnitudeRounder.getInstance(properties);
        }
        return null;
    }

    public static interface IProperties
    extends Rounder.IBasicRoundingProperties,
    IncrementRounder.IProperties,
    MagnitudeRounder.IProperties,
    SignificantDigitsRounder.IProperties {
    }
}

