/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.euicc;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.UiccAccessRule;
import com.android.internal.util.Preconditions;

public class DownloadableSubscription
implements Parcelable {
    public static final Parcelable.Creator<DownloadableSubscription> CREATOR = new Parcelable.Creator<DownloadableSubscription>(){

        @Override
        public DownloadableSubscription createFromParcel(Parcel in) {
            return new DownloadableSubscription(in);
        }

        public DownloadableSubscription[] newArray(int size) {
            return new DownloadableSubscription[size];
        }
    };
    public final String encodedActivationCode;
    private String carrierName;
    private UiccAccessRule[] accessRules;

    private DownloadableSubscription(String encodedActivationCode) {
        this.encodedActivationCode = encodedActivationCode;
    }

    private DownloadableSubscription(Parcel in) {
        this.encodedActivationCode = in.readString();
        this.carrierName = in.readString();
        this.accessRules = in.createTypedArray(UiccAccessRule.CREATOR);
    }

    public static DownloadableSubscription forActivationCode(String encodedActivationCode) {
        Preconditions.checkNotNull(encodedActivationCode, "Activation code may not be null");
        return new DownloadableSubscription(encodedActivationCode);
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public UiccAccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public void setAccessRules(UiccAccessRule[] accessRules) {
        this.accessRules = accessRules;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.encodedActivationCode);
        dest.writeString(this.carrierName);
        dest.writeTypedArray(this.accessRules, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

