/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebViewFactory;
import com.android.server.LocalServices;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class WebViewLibraryLoader {
    private static final String LOGTAG = WebViewLibraryLoader.class.getSimpleName();
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    private static final long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static final boolean DEBUG = false;
    private static boolean sAddressSpaceReserved = false;

    WebViewLibraryLoader() {
    }

    static void createRelroFile(boolean is64Bit, String[] nativeLibraryPaths) {
        final String abi = is64Bit ? _Original_Build.SUPPORTED_64_BIT_ABIS[0] : _Original_Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.e(LOGTAG, "relro file creator for " + abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }
        };
        try {
            if (nativeLibraryPaths == null || nativeLibraryPaths[0] == null || nativeLibraryPaths[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            int pid = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), nativeLibraryPaths, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (pid <= 0) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    static String[] updateWebViewZygoteVmSize(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        String[] nativeLibs = WebViewLibraryLoader.getWebViewNativeLibraryPaths(packageInfo);
        if (nativeLibs != null) {
            long newVmSize = 0L;
            for (String path : nativeLibs) {
                String[] split;
                if (path == null || TextUtils.isEmpty(path)) continue;
                File f = new File(path);
                if (f.exists()) {
                    newVmSize = Math.max(newVmSize, f.length());
                    continue;
                }
                if (path.contains("!/") && (split = TextUtils.split(path, "!/")).length == 2) {
                    try (ZipFile z = new ZipFile(split[0]);){
                        ZipEntry e = z.getEntry(split[1]);
                        if (e != null && e.getMethod() == 0) {
                            newVmSize = Math.max(newVmSize, e.getSize());
                            continue;
                        }
                    }
                    catch (IOException e) {
                        Log.e(LOGTAG, "error reading APK file " + split[0] + ", ", e);
                    }
                }
                Log.e(LOGTAG, "error sizing load for " + path);
            }
            newVmSize = Math.max(2L * newVmSize, 0x6400000L);
            Log.d(LOGTAG, "Setting new address space to " + newVmSize);
            WebViewLibraryLoader.setWebViewZygoteVmSize(newVmSize);
        }
        return nativeLibs;
    }

    static void reserveAddressSpaceInZygote() {
        System.loadLibrary("webviewchromium_loader");
        long addressSpaceToReserve = SystemProperties.getLong("persist.sys.webview.vmsize", 0x6400000L);
        sAddressSpaceReserved = WebViewLibraryLoader.nativeReserveAddressSpace(addressSpaceToReserve);
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "reserving " + addressSpaceToReserve + " bytes of address space failed");
        }
    }

    static int loadNativeLibrary(ClassLoader clazzLoader, PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return 2;
        }
        String libraryFileName = WebViewFactory.getWebViewLibrary(packageInfo.applicationInfo);
        int result = WebViewLibraryLoader.nativeLoadWithRelroFile(libraryFileName, CHROMIUM_WEBVIEW_NATIVE_RELRO_32, CHROMIUM_WEBVIEW_NATIVE_RELRO_64, clazzLoader);
        if (result != 0) {
            Log.w(LOGTAG, "failed to load with relro file, proceeding without");
        }
        return result;
    }

    static String[] getWebViewNativeLibraryPaths(PackageInfo packageInfo) throws WebViewFactory.MissingWebViewPackageException {
        File f;
        String path32;
        String path64;
        ApplicationInfo ai = packageInfo.applicationInfo;
        String nativeLibFileName = WebViewFactory.getWebViewLibrary(ai);
        boolean primaryArchIs64bit = VMRuntime.is64BitAbi(ai.primaryCpuAbi);
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            if (primaryArchIs64bit) {
                path64 = ai.nativeLibraryDir;
                path32 = ai.secondaryNativeLibraryDir;
            } else {
                path64 = ai.secondaryNativeLibraryDir;
                path32 = ai.nativeLibraryDir;
            }
        } else if (primaryArchIs64bit) {
            path64 = ai.nativeLibraryDir;
            path32 = "";
        } else {
            path32 = ai.nativeLibraryDir;
            path64 = "";
        }
        if (!TextUtils.isEmpty(path32) && !(f = new File(path32 = path32 + "/" + nativeLibFileName)).exists()) {
            path32 = WebViewLibraryLoader.getLoadFromApkPath(ai.sourceDir, _Original_Build.SUPPORTED_32_BIT_ABIS, nativeLibFileName);
        }
        if (!TextUtils.isEmpty(path64) && !(f = new File(path64 = path64 + "/" + nativeLibFileName)).exists()) {
            path64 = WebViewLibraryLoader.getLoadFromApkPath(ai.sourceDir, _Original_Build.SUPPORTED_64_BIT_ABIS, nativeLibFileName);
        }
        return new String[]{path32, path64};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLoadFromApkPath(String apkPath, String[] abiList, String nativeLibFileName) throws WebViewFactory.MissingWebViewPackageException {
        try (ZipFile z = new ZipFile(apkPath);){
            String[] stringArray = abiList;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String abi = stringArray[n2];
                String entry = "lib/" + abi + "/" + nativeLibFileName;
                ZipEntry e = z.getEntry(entry);
                if (e != null && e.getMethod() == 0) {
                    String string2 = apkPath + "!/" + entry;
                    return string2;
                }
                ++n2;
            }
            return "";
        }
        catch (IOException e) {
            throw new WebViewFactory.MissingWebViewPackageException(e);
        }
    }

    private static void setWebViewZygoteVmSize(long vmSize) {
        SystemProperties.set("persist.sys.webview.vmsize", Long.toString(vmSize));
    }

    static boolean nativeReserveAddressSpace(long l) {
        return OverrideMethod.invokeI("android.webkit.WebViewLibraryLoader#nativeReserveAddressSpace(J)Z", true, null) != 0;
    }

    static boolean nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return OverrideMethod.invokeI("android.webkit.WebViewLibraryLoader#nativeCreateRelroFile(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", true, null) != 0;
    }

    static int nativeLoadWithRelroFile(String string2, String string3, String string4, ClassLoader classLoader) {
        return OverrideMethod.invokeI("android.webkit.WebViewLibraryLoader#nativeLoadWithRelroFile(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;)I", true, null);
    }

    private static class RelroFileCreator {
        private RelroFileCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 2 || args[0] == null || args[1] == null) {
                    Log.e(LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v(LOGTAG, "RelroFileCreator (64bit = " + is64Bit + "),  32-bit lib: " + args[0] + ", 64-bit lib: " + args[1]);
                if (!sAddressSpaceReserved) {
                    Log.e(LOGTAG, "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewLibraryLoader.nativeCreateRelroFile(args[0], args[1], WebViewLibraryLoader.CHROMIUM_WEBVIEW_NATIVE_RELRO_32, WebViewLibraryLoader.CHROMIUM_WEBVIEW_NATIVE_RELRO_64);
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(LOGTAG, "error notifying update service", e);
                }
                if (!result) {
                    Log.e(LOGTAG, "failed to create relro file");
                }
                System.exit(0);
            }
        }
    }
}

