/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Config {
    private static final String GINGERBREAD_DIR = "/bars/v9/";
    private static final String JELLYBEAN_DIR = "/bars/v18/";
    private static final String KITKAT_DIR = "/bars/v19/";
    private static final String DEFAULT_RESOURCE_DIR = "/bars/v21/";
    private static final List<String> sDefaultResourceDir = Collections.singletonList("/bars/v21/");
    private static final int WHITE = -1;
    private static final int BLACK = -16777216;

    public static boolean showOnScreenNavBar(int platformVersion) {
        return Config.isGreaterOrEqual(platformVersion, 14);
    }

    public static int getStatusBarColor(int platformVersion) {
        return Config.isGreaterOrEqual(platformVersion, 9) ? -16777216 : -1;
    }

    public static List<String> getResourceDirs(int platformVersion) {
        if (platformVersion == 0) {
            return sDefaultResourceDir;
        }
        ArrayList<String> list = new ArrayList<String>(4);
        if (platformVersion <= 9) {
            list.add(GINGERBREAD_DIR);
        }
        if (platformVersion <= 18) {
            list.add(JELLYBEAN_DIR);
        }
        if (platformVersion <= 19) {
            list.add(KITKAT_DIR);
        }
        list.add(DEFAULT_RESOURCE_DIR);
        return Collections.unmodifiableList(list);
    }

    public static String getTime(int platformVersion) {
        if (Config.isGreaterOrEqual(platformVersion, 26)) {
            return "8:00";
        }
        if (platformVersion < 9) {
            return "2:20";
        }
        if (platformVersion < 14) {
            return "2:30";
        }
        if (platformVersion < 16) {
            return "4:00";
        }
        if (platformVersion < 19) {
            return "4:30";
        }
        if (platformVersion < 21) {
            return "4:40";
        }
        if (platformVersion < 22) {
            return "5:00";
        }
        if (platformVersion < 23) {
            return "5:10";
        }
        if (platformVersion < 24) {
            return "6:00";
        }
        if (platformVersion < 26) {
            return "7:00";
        }
        return "4:04";
    }

    public static int getTimeColor(int platformVersion) {
        if (Config.isGreaterOrEqual(platformVersion, 19) || platformVersion > 8 && platformVersion < 11) {
            return -1;
        }
        if (platformVersion < 9) {
            return -16777216;
        }
        if (platformVersion < 19) {
            return -13388315;
        }
        return -1;
    }

    public static String getWifiIconType(int platformVersion) {
        return Config.isGreaterOrEqual(platformVersion, 21) ? "xml" : "png";
    }

    public static boolean isGreaterOrEqual(int platformVersion, int code) {
        return platformVersion == 0 || platformVersion >= code;
    }
}

