/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001a"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectData", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "createBranch", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "createBranchStartingFrom", "repository", "commit", "Lcom/intellij/vcs/log/Hash;", "initialName", "", "suggestBranchName", "branches", "Lcom/intellij/vcs/log/VcsRef;", "update", "Data", "intellij.vcs.git"})
public final class GitCreateNewBranchAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Data data;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Data data2 = data = this.collectData(e);
        if (data2 instanceof Data.WithCommit) {
            this.createBranchStartingFrom(((Data.WithCommit)data).getRepository(), ((Data.WithCommit)data).getHash(), ((Data.WithCommit)data).getName());
        } else if (data2 instanceof Data.NoCommit) {
            this.createBranch(((Data.NoCommit)data).getProject(), ((Data.NoCommit)data).getRepositories());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Data data;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Data data2 = data = this.collectData(e);
        if (data2 instanceof Data.Invisible) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
        } else if (data2 instanceof Data.Disabled) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setVisible(true);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(false);
        } else {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(true);
        }
    }

    private final Data collectData(AnActionEvent e) {
        List repositories;
        Project project;
        block21: {
            block20: {
                boolean bl;
                block19: {
                    List list;
                    GitRepositoryManager manager;
                    Project project2 = e.getProject();
                    if (project2 == null) {
                        return new Data.Invisible();
                    }
                    project = project2;
                    GitRepositoryManager gitRepositoryManager = manager = GitUtil.getRepositoryManager(project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gitRepositoryManager), (String)"manager");
                    if (gitRepositoryManager.getRepositories().isEmpty()) {
                        return new Data.Invisible();
                    }
                    VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
                    if (log != null) {
                        CommitId commit2;
                        List commits2 = log.getSelectedCommits();
                        if (commits2.isEmpty()) {
                            return new Data.Invisible();
                        }
                        if (commits2.size() > 1) {
                            return new Data.Disabled();
                        }
                        List list2 = commits2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"commits");
                        CommitId commitId = commit2 = (CommitId)CollectionsKt.first((List)list2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)commitId, (String)"commit");
                        GitRepository repository = (GitRepository)manager.getRepositoryForRootQuick(commitId.getRoot());
                        if (repository != null) {
                            String initialName = this.suggestBranchName(repository, (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES));
                            Hash hash = commit2.getHash();
                            Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"commit.hash");
                            return new Data.WithCommit(repository, hash, initialName);
                        }
                    }
                    if (manager.moreThanOneRoot()) {
                        GitVcsSettings gitVcsSettings = GitVcsSettings.getInstance(project);
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitVcsSettings, (String)"GitVcsSettings.getInstance(project)");
                        if (Intrinsics.areEqual((Object)gitVcsSettings.getSyncSetting(), (Object)DvcsSyncSettings.Value.SYNC)) {
                            list = manager.getRepositories();
                        } else {
                            GitRepository repository;
                            GitRepository gitRepository = repository = (GitRepository)manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot((Project)project, (VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE))));
                            if (gitRepository != null) {
                                Object object;
                                Object it = object = gitRepository;
                                list = CollectionsKt.listOf((Object)repository);
                            } else {
                                list = null;
                            }
                        }
                    } else {
                        List<GitRepository> list3 = manager.getRepositories();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"manager.repositories");
                        list = repositories = CollectionsKt.listOf((Object)CollectionsKt.first(list3));
                    }
                    if (repositories == null) break block20;
                    Iterable $receiver$iv = repositories;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            GitRepository it;
                            GitRepository gitRepository = it = (GitRepository)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"it");
                            if (!gitRepository.isFresh()) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block21;
            }
            return new Data.Invisible();
        }
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        return new Data.NoCommit(project3, repositories);
    }

    /*
     * WARNING - void declaration
     */
    private final String suggestBranchName(GitRepository repository, List<? extends VcsRef> branches) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv;
        Iterable iterable = branches;
        List list = iterable;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        iterable = list;
        void var5_4 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            VcsRef it = (VcsRef)element$iv$iv;
            VcsRefType vcsRefType = it.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsRefType, (String)"it.type");
            if (!vcsRefType.isBranch()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingBranches = (List)destination$iv$iv;
        Iterable $receiver$iv2 = existingBranches;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            void it;
            VcsRef $i$a$1$filter = (VcsRef)item$iv$iv;
            Collection collection = destination$iv$iv2;
            if (repository.getBranches().findBranchByName(it.getName()) == null) {
                string = null;
            } else {
                GitBranch branch;
                GitBranch gitBranch = branch;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitBranch, (String)"branch");
                string = gitBranch.isRemote() ? ((GitRemoteBranch)branch).getNameForRemoteOperations() : branch.getName();
            }
            String string2 = string;
            collection.add(string2);
        }
        List suggestedNames = (List)destination$iv$iv2;
        return (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)suggestedNames));
    }

    /*
     * WARNING - void declaration
     */
    private final void createBranch(Project project, List<? extends GitRepository> repositories) {
        GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(project, (Collection<GitRepository>)repositories, "Create New Branch", null);
        if (options != null) {
            GitBrancher brancher = GitBrancher.getInstance(project);
            if (options.shouldCheckout()) {
                brancher.checkoutNewBranch(options.getName(), repositories);
            } else {
                Collection<Pair> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = repositories;
                String string = options.getName();
                GitBrancher gitBrancher = brancher;
                void var6_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    GitRepository gitRepository = (GitRepository)item$iv$iv;
                    collection = destination$iv$iv;
                    Pair pair = TuplesKt.to((Object)it, (Object)"HEAD");
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                gitBrancher.createBranch(string, MapsKt.toMap((Iterable)collection));
            }
        }
    }

    private final void createBranchStartingFrom(GitRepository repository, Hash commit2, String initialName) {
        Project project = repository.getProject();
        GitNewBranchOptions options = GitBranchUtil.getNewBranchNameFromUser(project, SetsKt.setOf((Object)repository), "Create New Branch From " + commit2.toShortString(), initialName);
        if (options != null) {
            GitBrancher brancher = GitBrancher.getInstance(project);
            if (options.shouldCheckout()) {
                brancher.checkoutNewBranchStartingFrom(options.getName(), commit2.asString(), CollectionsKt.listOf((Object)repository), null);
            } else {
                brancher.createBranch(options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)repository, (Object)commit2.asString())));
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data;", "", "()V", "Disabled", "Invisible", "NoCommit", "WithCommit", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "intellij.vcs.git"})
    private static abstract class Data {
        private Data() {
        }

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "()V", "intellij.vcs.git"})
        public static final class Invisible
        extends Data {
            public Invisible() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "()V", "intellij.vcs.git"})
        public static final class Disabled
        extends Data {
            public Disabled() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "repository", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "name", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/Hash;Ljava/lang/String;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getName", "()Ljava/lang/String;", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
        public static final class WithCommit
        extends Data {
            @NotNull
            private final GitRepository repository;
            @NotNull
            private final Hash hash;
            @Nullable
            private final String name;

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            public WithCommit(@NotNull GitRepository repository, @NotNull Hash hash, @Nullable String name) {
                Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
                Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
                super(null);
                this.repository = repository;
                this.hash = hash;
                this.name = name;
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepositories", "()Ljava/util/List;", "intellij.vcs.git"})
        public static final class NoCommit
        extends Data {
            @NotNull
            private final Project project;
            @NotNull
            private final List<GitRepository> repositories;

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final List<GitRepository> getRepositories() {
                return this.repositories;
            }

            public NoCommit(@NotNull Project project, @NotNull List<? extends GitRepository> repositories) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
                super(null);
                this.project = project;
                this.repositories = repositories;
            }
        }
    }
}

