/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitChangesCollector;
import git4idea.status.GitNewChangesCollector;
import git4idea.status.GitOldChangesCollector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)"#GitStatus");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;

    public GitChangeProvider(@NotNull Project project, @NotNull Git git, @NotNull ChangeListManager changeListManager, @NotNull FileDocumentManager fileDocumentManager, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            GitChangeProvider.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitChangeProvider.$$$reportNull$$$0(1);
        }
        if (changeListManager == null) {
            GitChangeProvider.$$$reportNull$$$0(2);
        }
        if (fileDocumentManager == null) {
            GitChangeProvider.$$$reportNull$$$0(3);
        }
        if (vcsManager == null) {
            GitChangeProvider.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myGit = git;
        this.myChangeListManager = changeListManager;
        this.myFileDocumentManager = fileDocumentManager;
        this.myVcsManager = vcsManager;
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            GitChangeProvider.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            GitChangeProvider.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            GitChangeProvider.$$$reportNull$$$0(7);
        }
        if (addGate == null) {
            GitChangeProvider.$$$reportNull$$$0(8);
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (LOG.isDebugEnabled()) {
            LOG.debug("initial dirty scope: " + dirtyScope);
        }
        GitChangeProvider.appendNestedVcsRootsToDirt(dirtyScope, vcs, this.myVcsManager);
        if (LOG.isDebugEnabled()) {
            LOG.debug("after adding nested vcs roots to dirt: " + dirtyScope);
        }
        Collection affected = dirtyScope.getAffectedContentRoots();
        Set<VirtualFile> roots = GitUtil.gitRootsForPaths(affected);
        try {
            MyNonChangedHolder holder = new MyNonChangedHolder(this.myProject, addGate, this.myFileDocumentManager, this.myVcsManager);
            for (VirtualFile root : roots) {
                LOG.debug("checking root: " + root.getPath());
                GitOldChangesCollector collector = this.isNewGitChangeProviderAvailable() ? GitNewChangesCollector.collect(this.myProject, this.myGit, this.myChangeListManager, this.myVcsManager, vcs, dirtyScope, root) : GitOldChangesCollector.collect(this.myProject, this.myChangeListManager, this.myVcsManager, vcs, dirtyScope, root);
                Collection<Change> changes = ((GitChangesCollector)collector).getChanges();
                holder.changed(changes);
                for (Change file : changes) {
                    LOG.debug("process change: " + ChangesUtil.getFilePath((Change)file).getPath());
                    builder.processChange(file, GitVcs.getKey());
                }
                for (VirtualFile f : ((GitChangesCollector)collector).getUnversionedFiles()) {
                    builder.processUnversionedFile(f);
                    holder.unversioned(f);
                }
                holder.feedBuilder(builder);
            }
        }
        catch (ProcessCanceledException pce) {
            if (pce.getCause() != null) {
                throw new VcsException(pce.getCause().getMessage(), pce.getCause());
            }
            throw new VcsException("Cannot get changes from Git", (Throwable)pce);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    private static void appendNestedVcsRootsToDirt(VcsDirtyScope dirtyScope, GitVcs vcs, ProjectLevelVcsManager vcsManager) {
        Set recursivelyDirtyDirectories = dirtyScope.getRecursivelyDirtyDirectories();
        if (recursivelyDirtyDirectories.isEmpty()) {
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        HashSet<VirtualFile> rootsUnderGit = new HashSet<VirtualFile>(Arrays.asList(vcsManager.getRootsUnderVcs((AbstractVcs)vcs)));
        HashSet<VirtualFile> inputColl = new HashSet<VirtualFile>(rootsUnderGit);
        HashSet<VirtualFile> existingInScope = new HashSet<VirtualFile>();
        for (FilePath dir : recursivelyDirtyDirectories) {
            VirtualFile vf = dir.getVirtualFile();
            if (vf == null) {
                vf = lfs.findFileByIoFile(dir.getIOFile());
            }
            if (vf == null) {
                vf = lfs.refreshAndFindFileByIoFile(dir.getIOFile());
            }
            if (vf == null) continue;
            existingInScope.add(vf);
        }
        inputColl.addAll(existingInScope);
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendNestedVcsRoots. collection to remove ancestors: " + inputColl);
        }
        FileUtil.removeAncestors(inputColl, o -> o.getPath(), (parent, child) -> {
            if (!existingInScope.contains(child) && existingInScope.contains(parent)) {
                LOG.debug("adding git root for check. child: " + child.getPath() + ", parent: " + parent.getPath());
                ((VcsModifiableDirtyScope)dirtyScope).addDirtyDirRecursively(VcsUtil.getFilePath((VirtualFile)child));
            }
            return true;
        });
    }

    private boolean isNewGitChangeProviderAvailable() {
        return GitVersionSpecialty.KNOWS_STATUS_PORCELAIN.existsIn(GitVcs.getInstance(this.myProject).getVersion());
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
        }
        objectArray2[1] = "git4idea/status/GitChangeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNonChangedHolder {
        private final Project myProject;
        private final Set<FilePath> myProcessedPaths;
        private final ChangeListManagerGate myAddGate;
        private final FileDocumentManager myFileDocumentManager;
        private final ProjectLevelVcsManager myVcsManager;

        private MyNonChangedHolder(Project project, ChangeListManagerGate addGate, FileDocumentManager fileDocumentManager, ProjectLevelVcsManager vcsManager) {
            this.myProject = project;
            this.myProcessedPaths = new HashSet<FilePath>();
            this.myAddGate = addGate;
            this.myFileDocumentManager = fileDocumentManager;
            this.myVcsManager = vcsManager;
        }

        public void changed(Collection<Change> changes) {
            for (Change change : changes) {
                FilePath afterPath;
                FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                if (beforePath != null) {
                    this.myProcessedPaths.add(beforePath);
                }
                if ((afterPath = ChangesUtil.getAfterPath((Change)change)) == null) continue;
                this.myProcessedPaths.add(afterPath);
            }
        }

        public void unversioned(VirtualFile vf) {
            this.myProcessedPaths.add(VcsUtil.getFilePath((VirtualFile)vf));
        }

        public void feedBuilder(ChangelistBuilder builder) throws VcsException {
            VcsKey gitKey = GitVcs.getKey();
            HashMap<VirtualFile, GitRevisionNumber> baseRevisions = new HashMap<VirtualFile, GitRevisionNumber>();
            for (Document document : this.myFileDocumentManager.getUnsavedDocuments()) {
                GitRepository repository;
                FilePath filePath;
                VirtualFile vf = this.myFileDocumentManager.getFile(document);
                if (vf == null || !vf.isValid() || this.myAddGate.getStatus(vf) != null || !this.myFileDocumentManager.isFileModified(vf) || this.myProcessedPaths.contains(filePath = VcsUtil.getFilePath((VirtualFile)vf)) || (repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vf)) == null) continue;
                VirtualFile root = repository.getRoot();
                GitRevisionNumber beforeRevisionNumber = (GitRevisionNumber)baseRevisions.get(root);
                if (beforeRevisionNumber == null) {
                    beforeRevisionNumber = GitChangeUtils.resolveReference(this.myProject, root, "HEAD");
                    baseRevisions.put(root, beforeRevisionNumber);
                }
                builder.processChange(new Change(GitContentRevision.createRevision(vf, (VcsRevisionNumber)beforeRevisionNumber, this.myProject), GitContentRevision.createRevision(vf, null, this.myProject), FileStatus.MODIFIED), gitKey);
            }
        }
    }
}

