/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0014J\b\u0010)\u001a\u00020'H\u0004J\b\u0010*\u001a\u00020'H\u0014J\b\u0010+\u001a\u00020'H\u0002J\b\u0010,\u001a\u00020'H\u0002J\u001c\u0010-\u001a\u00020'2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/2\u0006\u00100\u001a\u00020\u0011H$J\u0018\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0011H\u0004R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0007\u001a\u00020\b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\t\u001a\u00020\n8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00110!8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/when/SwitchCodegen;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "isStatement", "", "isExhaustive", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "subjectType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;ZZLorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/org/objectweb/asm/Type;)V", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "defaultLabel", "Lorg/jetbrains/org/objectweb/asm/Label;", "getDefaultLabel", "()Lorg/jetbrains/org/objectweb/asm/Label;", "setDefaultLabel", "(Lorg/jetbrains/org/objectweb/asm/Label;)V", "elseLabel", "endLabel", "entryLabels", "", "()Z", "resultType", "getResultType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "switchCodegenProvider", "Lorg/jetbrains/kotlin/codegen/when/SwitchCodegenProvider;", "transitionsTable", "Ljava/util/NavigableMap;", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "findNullEntryIndex", "generate", "", "generateEntries", "generateNullCheckIfNeeded", "generateSubject", "generateSwitchInstructionByTransitionsTable", "prepareConfiguration", "processConstant", "constant", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entryLabel", "putTransitionOnce", "value", "backend"})
public abstract class SwitchCodegen {
    @NotNull
    private final BindingContext bindingContext;
    @JvmField
    @NotNull
    protected final Type subjectType;
    @NotNull
    private final Type resultType;
    @JvmField
    @NotNull
    protected final InstructionAdapter v;
    @JvmField
    @NotNull
    protected final NavigableMap<Integer, Label> transitionsTable;
    private final List<Label> entryLabels;
    private Label elseLabel;
    private Label endLabel;
    @NotNull
    protected Label defaultLabel;
    private final SwitchCodegenProvider switchCodegenProvider;
    @JvmField
    @NotNull
    protected final KtWhenExpression expression;
    private final boolean isStatement;
    private final boolean isExhaustive;
    @JvmField
    @NotNull
    protected final ExpressionCodegen codegen;

    @NotNull
    protected final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    protected final Type getResultType() {
        return this.resultType;
    }

    @NotNull
    protected final Label getDefaultLabel() {
        Label label2 = this.defaultLabel;
        if (label2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultLabel");
        }
        return label2;
    }

    protected final void setDefaultLabel(@NotNull Label label2) {
        Intrinsics.checkParameterIsNotNull((Object)label2, (String)"<set-?>");
        this.defaultLabel = label2;
    }

    public void generate() {
        this.prepareConfiguration();
        boolean hasElse = this.expression.getElseExpression() != null;
        this.defaultLabel = hasElse || !this.isStatement || this.isExhaustive ? this.elseLabel : this.endLabel;
        this.generateSubject();
        this.generateSwitchInstructionByTransitionsTable();
        this.generateEntries();
        if (!(hasElse || this.isStatement && !this.isExhaustive)) {
            this.v.visitLabel(this.elseLabel);
            this.codegen.putUnitInstanceOntoStackForNonExhaustiveWhen(this.expression, this.isStatement);
        }
        this.codegen.markLineNumber(this.expression, this.isStatement);
        this.v.mark(this.endLabel);
    }

    private final void prepareConfiguration() {
        for (KtWhenEntry entry : this.expression.getEntries()) {
            Label entryLabel = new Label();
            KtWhenEntry ktWhenEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            for (ConstantValue<?> constant : this.switchCodegenProvider.getConstantsFromEntry(ktWhenEntry)) {
                if (constant instanceof NullValue || constant == null) continue;
                this.processConstant(constant, entryLabel);
            }
            if (entry.isElse()) {
                this.elseLabel = entryLabel;
            }
            this.entryLabels.add(entryLabel);
        }
    }

    protected abstract void processConstant(@NotNull ConstantValue<?> var1, @NotNull Label var2);

    protected final void putTransitionOnce(int value2, @NotNull Label entryLabel) {
        Intrinsics.checkParameterIsNotNull((Object)entryLabel, (String)"entryLabel");
        if (!this.transitionsTable.containsKey(value2)) {
            Map map2 = this.transitionsTable;
            Integer n = value2;
            Label label2 = entryLabel;
            map2.put(n, label2);
        }
    }

    protected void generateSubject() {
        this.codegen.gen(this.expression.getSubjectExpression(), this.subjectType);
    }

    protected final void generateNullCheckIfNeeded() {
        boolean bl;
        boolean bl2 = bl = this.expression.getSubjectExpression() != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "subject expression can't be null";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtExpression ktExpression = this.expression.getSubjectExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType kotlinType = this.bindingContext.getType(ktExpression);
        if (kotlinType == null) {
            String $i$a$1$assert = "subject type can't be null (i.e. void)";
            throw (Throwable)new IllegalStateException($i$a$1$assert.toString());
        }
        KotlinType subjectJetType = kotlinType;
        if (TypeUtils.isNullableType(subjectJetType)) {
            InstructionAdapter instructionAdapter;
            Label label2;
            int nullEntryIndex = this.findNullEntryIndex(this.expression);
            if (nullEntryIndex == -1) {
                label2 = this.defaultLabel;
                if (label2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"defaultLabel");
                }
            } else {
                label2 = this.entryLabels.get(nullEntryIndex);
            }
            Label nullLabel = label2;
            Label notNullLabel = new Label();
            InstructionAdapter $receiver = instructionAdapter = this.v;
            $receiver.dup();
            $receiver.ifnonnull(notNullLabel);
            $receiver.pop();
            $receiver.goTo(nullLabel);
            $receiver.visitLabel(notNullLabel);
        }
    }

    private final int findNullEntryIndex(KtWhenExpression expression2) {
        Object v3;
        block5: {
            List<KtWhenEntry> list2 = expression2.getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.entries");
            Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)list2);
            for (Object element$iv : $receiver$iv) {
                boolean bl;
                block4: {
                    KtWhenEntry entry;
                    IndexedValue $$_$_entry = (IndexedValue)element$iv;
                    KtWhenEntry ktWhenEntry = entry = (KtWhenEntry)$$_$_entry.component2();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
                    Iterable<ConstantValue<?>> $receiver$iv2 = this.switchCodegenProvider.getConstantsFromEntry(ktWhenEntry);
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (ConstantValue<?> element$iv2 : $receiver$iv2) {
                            ConstantValue<?> it = element$iv2;
                            if (!(it instanceof NullValue)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        IndexedValue indexedValue = v3;
        return indexedValue != null ? indexedValue.getIndex() : -1;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSwitchInstructionByTransitionsTable() {
        Set set2 = this.transitionsTable.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"transitionsTable.keys");
        int[] keys2 = CollectionsKt.toIntArray((Collection)set2);
        int labelsNumber = keys2.length;
        int maxValue = ArraysKt.last((int[])keys2);
        int minValue = ArraysKt.first((int[])keys2);
        long rangeLength = (long)maxValue - (long)minValue + 1L;
        if (rangeLength > 2L * (long)labelsNumber || rangeLength > (long)Integer.MAX_VALUE) {
            Collection $receiver$iv;
            Collection collection = this.transitionsTable.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"transitionsTable.values");
            Collection collection2 = $receiver$iv = collection;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection2;
            Label[] labelArray = thisCollection$iv.toArray(new Label[0]);
            if (labelArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Label[] labels2 = labelArray;
            Label label2 = this.defaultLabel;
            if (label2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"defaultLabel");
            }
            this.v.lookupswitch(label2, keys2, labels2);
            return;
        }
        int size$iv = (int)rangeLength;
        Label[] result$iv = new Label[size$iv];
        int $i$f$toTypedArray = 0;
        int n = result$iv.length;
        while ($i$f$toTypedArray < n) {
            Label label3;
            void index2;
            void i$iv;
            void var12_14 = i$iv;
            void var16_16 = i$iv;
            Label[] labelArray = result$iv;
            Label label4 = (Label)this.transitionsTable.get((int)(index2 + minValue));
            if (label4 == null && (label4 = this.defaultLabel) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"defaultLabel");
            }
            labelArray[var16_16] = label3 = label4;
            ++i$iv;
        }
        Label[] sparseLabels = result$iv;
        Label label5 = this.defaultLabel;
        if (label5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultLabel");
        }
        this.v.tableswitch(minValue, maxValue, label5, Arrays.copyOf(sparseLabels, sparseLabels.length));
    }

    protected void generateEntries() {
        Iterator<Label> entryLabelsIterator = this.entryLabels.iterator();
        for (KtWhenEntry entry : this.expression.getEntries()) {
            this.v.visitLabel(entryLabelsIterator.next());
            FrameMap.Mark mark = this.codegen.myFrameMap.mark();
            KtWhenEntry ktWhenEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            this.codegen.gen(ktWhenEntry.getExpression(), this.resultType);
            mark.dropTo();
            if (entry.isElse()) continue;
            this.v.goTo(this.endLabel);
        }
    }

    protected final boolean isStatement() {
        return this.isStatement;
    }

    public SwitchCodegen(@NotNull KtWhenExpression expression2, boolean isStatement, boolean isExhaustive, @NotNull ExpressionCodegen codegen, @Nullable Type subjectType) {
        Type type2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)codegen, (String)"codegen");
        this.expression = expression2;
        this.isStatement = isStatement;
        this.isExhaustive = isExhaustive;
        this.codegen = codegen;
        BindingContext bindingContext2 = this.codegen.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"codegen.bindingContext");
        this.bindingContext = bindingContext2;
        Type type3 = subjectType;
        if (type3 == null) {
            Type type4 = this.codegen.expressionType(this.expression.getSubjectExpression());
            type3 = type4;
            Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"codegen.expressionType(e\u2026ession.subjectExpression)");
        }
        this.subjectType = type3;
        if (this.isStatement) {
            Type type5 = Type.VOID_TYPE;
            type2 = type5;
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"Type.VOID_TYPE");
        } else {
            Type type6 = this.codegen.expressionType(this.expression);
            type2 = type6;
            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"codegen.expressionType(expression)");
        }
        this.resultType = type2;
        InstructionAdapter instructionAdapter = this.codegen.v;
        Intrinsics.checkExpressionValueIsNotNull((Object)instructionAdapter, (String)"codegen.v");
        this.v = instructionAdapter;
        this.transitionsTable = new TreeMap();
        this.entryLabels = new ArrayList();
        this.elseLabel = new Label();
        this.endLabel = new Label();
        this.switchCodegenProvider = new SwitchCodegenProvider(this.codegen);
    }
}

