/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.common;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.common.FileWithMetadata;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/common/KotlinMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "version", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "readFile", "Lkotlin/Function2;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;", "(ILcom/intellij/openapi/fileTypes/FileType;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;Lkotlin/jvm/functions/Function2;)V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "idea-core"})
public class KotlinMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    private final FileType fileType;
    private final SerializerExtensionProtocol serializerProtocol;
    private final Function2<byte[], VirtualFile, FileWithMetadata> readFile;

    public int getStubVersion() {
        return 21 + this.version;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        FileWithMetadata file2;
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile3 = virtualFile2 = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
        boolean bl = Intrinsics.areEqual((Object)virtualFile3.getFileType(), (Object)this.fileType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Unexpected file type " + virtualFile2.getFileType();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        byte[] byArray = content2.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"content.content");
        FileWithMetadata fileWithMetadata = (FileWithMetadata)this.readFile.invoke((Object)byArray, (Object)virtualFile2);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata fileWithMetadata2 = file2 = fileWithMetadata;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            ProtoBuf.Package packageProto = ((FileWithMetadata.Compatible)file2).getProto().getPackage();
            FqName packageFqName = ((FileWithMetadata.Compatible)file2).getPackageFqName();
            NameResolverImpl nameResolver = ((FileWithMetadata.Compatible)file2).getNameResolver();
            ClsStubBuilderComponents components = new ClsStubBuilderComponents(new ProtoBasedClassDataFinder(((FileWithMetadata.Compatible)file2).getProto(), nameResolver, null, 4, null), new AnnotationLoaderForStubBuilderImpl(this.serializerProtocol), virtualFile2);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.Package package_ = packageProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageProto");
            ProtoBuf.TypeTable typeTable = package_.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            CallableClsStubBuilderKt.createDeclarationsStubs((StubElement<? extends PsiElement>)((StubElement)fileStub), context, new ProtoContainer.Package(packageFqName, context.getNameResolver(), context.getTypeTable(), null), packageProto);
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file2).getClassesToDecompile()) {
                ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)((StubElement)fileStub), classProto, nameResolver, nameResolver.getClassId(classProto.getFqName()), null, context);
            }
            return fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }

    public KotlinMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull SerializerExtensionProtocol serializerProtocol, @NotNull Function2<? super byte[], ? super VirtualFile, ? extends FileWithMetadata> readFile) {
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        Intrinsics.checkParameterIsNotNull((Object)serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkParameterIsNotNull(readFile, (String)"readFile");
        this.version = version;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }
}

