/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImplKt;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridingMethodsUpdater;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a6\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0000\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"buildNavigateToOverriddenMethodPopup", "Lorg/jetbrains/kotlin/idea/highlighter/markers/NavigationPopupDescriptor;", "e", "Ljava/awt/event/MouseEvent;", "element", "Lcom/intellij/psi/PsiElement;", "getOverriddenDeclarations", "", "T", "mappingToJava", "", "classes", "Lcom/intellij/psi/PsiClass;", "getOverriddenMethodTooltip", "", "method", "Lcom/intellij/psi/PsiMethod;", "isMethodWithDeclarationInOtherClass", "", "idea"})
public final class OverridenFunctionMarkerKt {
    private static final boolean isMethodWithDeclarationInOtherClass(@NotNull PsiMethod $receiver) {
        return $receiver instanceof KtLightMethod && KtLightMethodImplKt.isTraitFakeOverride((KtLightMethod)$receiver);
    }

    @NotNull
    public static final <T> Set<T> getOverriddenDeclarations(@NotNull Map<PsiElement, T> mappingToJava, @NotNull Set<? extends PsiClass> classes2) {
        Intrinsics.checkParameterIsNotNull(mappingToJava, (String)"mappingToJava");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        HashSet overridden = new HashSet();
        for (PsiClass psiClass2 : classes2) {
            OverridersSearchKt.forEachDeclaredMemberOverride(psiClass2, (Function2<? super PsiElement, ? super PsiElement, Boolean>)((Function2)new Function2<PsiElement, PsiElement, Boolean>(mappingToJava, overridden){
                final /* synthetic */ Map $mappingToJava;
                final /* synthetic */ HashSet $overridden;

                public final boolean invoke(@NotNull PsiElement superMember, @NotNull PsiElement overridingMember) {
                    V declaration2;
                    boolean bl;
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)superMember, (String)"superMember");
                        Intrinsics.checkParameterIsNotNull((Object)overridingMember, (String)"overridingMember");
                        ProgressManager.checkCanceled();
                        Iterable $receiver$iv = OverridersSearchKt.toPossiblyFakeLightMethods(overridingMember);
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                PsiMethod it = (PsiMethod)element$iv;
                                if (!(!OverridenFunctionMarkerKt.access$isMethodWithDeclarationInOtherClass(it))) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl && (declaration2 = this.$mappingToJava.get(superMember)) != null) {
                        this.$mappingToJava.remove(superMember);
                        this.$overridden.add(declaration2);
                    }
                    return !this.$mappingToJava.isEmpty();
                }
                {
                    this.$mappingToJava = map2;
                    this.$overridden = hashSet;
                    super(2);
                }
            }));
        }
        return overridden;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        OverridersSearchKt.forEachOverridingMethod$default(method, null, (Function1)new Function1<PsiMethod, Boolean>(new PsiElementProcessorAdapter((PsiElementProcessor)processor2)){

            public final boolean invoke(PsiMethod p1) {
                return ((PsiElementProcessorAdapter)this.receiver).process((Object)p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PsiElementProcessorAdapter.class);
            }

            public final String getName() {
                return "process";
            }

            public final String getSignature() {
                return "process(Ljava/lang/Object;)Z";
            }
        }, 1, null);
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return isAbstract ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]);
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Collection collection = processor2.getCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"processor.collection");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it;
            PsiMethod psiMethod = it = (PsiMethod)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"it");
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(psiMethod))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator comparator2 = comparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"comparator");
        List overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        String start = isAbstract ? DaemonBundle.message((String)"method.is.implemented.header", (Object[])new Object[0]) : DaemonBundle.message((String)"method.is.overriden.header", (Object[])new Object[0]);
        return GutterIconTooltipHelper.composeText((Iterable)overridingJavaMethods, (String)start, (String)"&nbsp;&nbsp;&nbsp;&nbsp;{1}");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final NavigationPopupDescriptor buildNavigateToOverriddenMethodPopup(@Nullable MouseEvent e, @Nullable PsiElement element3) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        PsiMethod psiMethod = JavaPsiUtilsKt.getPsiMethod(element3);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (DumbService.isDumb((Project)method.getProject())) {
            DumbService dumbService = DumbService.getInstance((Project)method.getProject());
            if (dumbService != null) {
                dumbService.showDumbModeNotification("Navigation to overriding classes is not possible during index update");
            }
            return null;
        }
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new THashSet());
        MouseEvent mouseEvent = e;
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(method, processor2){
            final /* synthetic */ PsiMethod $method;
            final /* synthetic */ PsiElementProcessor.CollectElementsWithLimit $processor;

            public final void run() {
                OverridersSearchKt.forEachOverridingMethod$default(this.$method, null, (Function1)new Function1<PsiMethod, Boolean>(this){
                    final /* synthetic */ buildNavigateToOverriddenMethodPopup.1 this$0;

                    public final boolean invoke(@NotNull PsiMethod it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this, it){
                            final /* synthetic */ buildNavigateToOverriddenMethodPopup.1 this$0;
                            final /* synthetic */ PsiMethod $it;

                            public final boolean invoke() {
                                return this.this$0.this$0.$processor.execute((PsiElement)this.$it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$it = psiMethod;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, 1, null);
            }
            {
                this.$method = psiMethod;
                this.$processor = collectElementsWithLimit;
            }
        }, "Searching for overriding declarations", true, method.getProject(), (JComponent)(mouseEvent != null ? mouseEvent.getComponent() : null))) {
            return null;
        }
        Collection collection = processor2.getCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"processor.collection");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiMethod it;
            PsiMethod psiMethod2 = it = (PsiMethod)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"it");
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(psiMethod2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overridingJavaMethods = (List)destination$iv$iv;
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        MethodCellRenderer renderer2 = new MethodCellRenderer(false);
        Iterable iterable2 = overridingJavaMethods;
        Comparator comparator = renderer2.getComparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"renderer.comparator");
        overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
        OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, (PsiElementListCellRenderer<? extends PsiElement>)((PsiElementListCellRenderer)renderer2));
        return new NavigationPopupDescriptor(overridingJavaMethods, methodsUpdater.getCaption(overridingJavaMethods.size()), "Overriding declarations of " + method.getName(), (ListCellRenderer)renderer2, methodsUpdater);
    }

    public static final /* synthetic */ boolean access$isMethodWithDeclarationInOtherClass(@NotNull PsiMethod $receiver) {
        return OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass($receiver);
    }
}

