/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.JavaCollectionsStaticMethodCallInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceWithStdLibFix;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaCollectionsStaticMethodInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "canReplaceWithStdLib", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "fqName", "", "args", "", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "checkApiVersion", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "idea"})
public final class JavaCollectionsStaticMethodInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.dotQualifiedExpressionVisitor((Function1<? super KtDotQualifiedExpression, Unit>)((Function1)new Function1<KtDotQualifiedExpression, Unit>(this, holder){
            final /* synthetic */ JavaCollectionsStaticMethodInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtDotQualifiedExpression expression2) {
                Object fqName2;
                List<KtValueArgument> args;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtCallExpression ktCallExpression = UtilsKt.getCallExpression(expression2);
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression callExpression2 = ktCallExpression;
                List<KtValueArgument> list2 = args = callExpression2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"args");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull(list2);
                if (ktValueArgument == null) {
                    return;
                }
                KtValueArgument firstArg = ktValueArgument;
                BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
                Object object = firstArg.getArgumentExpression();
                if (object == null || (object = CallUtilKt.getType((KtExpression)object, context)) == null || !JavaCollectionsStaticMethodCallInspectionKt.access$isMutableListOrSubtype((KotlinType)object)) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context);
                CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                if (!(callableDescriptor instanceof JavaMethodDescriptor)) {
                    callableDescriptor = null;
                }
                JavaMethodDescriptor javaMethodDescriptor = (JavaMethodDescriptor)callableDescriptor;
                if (javaMethodDescriptor == null) {
                    return;
                }
                JavaMethodDescriptor descriptor2 = javaMethodDescriptor;
                Object object2 = ImportsUtils.getImportableFqName(descriptor2);
                if (object2 == null || (object2 = ((FqName)object2).asString()) == null) {
                    return;
                }
                Object object3 = fqName2 = object2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"fqName");
                if (!JavaCollectionsStaticMethodInspection.access$canReplaceWithStdLib(this.this$0, expression2, (String)object3, args)) {
                    return;
                }
                String methodName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)fqName2), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
                PsiElement psiElement2 = (PsiElement)expression2;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                String string = firstArg.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"firstArg.text");
                localQuickFixArray[0] = new ReplaceWithStdLibFix(methodName, string);
                this.$holder.registerProblem(psiElement2, "Java Collections static method call should be replaced with Kotlin stdlib", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
            }
            {
                this.this$0 = javaCollectionsStaticMethodInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canReplaceWithStdLib(KtDotQualifiedExpression expression2, String fqName2, List<? extends KtValueArgument> args) {
        if (!StringsKt.startsWith$default((String)fqName2, (String)"java.util.Collections.", (boolean)false, (int)2, null)) {
            return false;
        }
        int size = args.size();
        switch (fqName2) {
            case "java.util.Collections.fill": {
                if (!this.checkApiVersion(ApiVersion.KOTLIN_1_2, expression2)) return false;
                if (size != 2) return false;
                return true;
            }
            case "java.util.Collections.reverse": {
                if (size != 1) return false;
                return true;
            }
            case "java.util.Collections.shuffle": {
                if (!this.checkApiVersion(ApiVersion.KOTLIN_1_2, expression2)) return false;
                if (size == 1) return true;
                if (size != 2) return false;
                return true;
            }
            case "java.util.Collections.sort": {
                if (size == 1) return true;
                if (size != 2) return false;
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull(args, (int)1);
                if (!((ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null) instanceof KtLambdaExpression)) return false;
                return true;
            }
            default: {
                return false;
            }
        }
    }

    private final boolean checkApiVersion(ApiVersion requiredVersion, KtDotQualifiedExpression expression2) {
        Module module;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)expression2));
        if (module2 == null) {
            return true;
        }
        Module module3 = module = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        return PlatformKt.getLanguageVersionSettings(module3).getApiVersion().compareTo(requiredVersion) >= 0;
    }

    public static final /* synthetic */ boolean access$canReplaceWithStdLib(JavaCollectionsStaticMethodInspection $this, @NotNull KtDotQualifiedExpression expression2, @NotNull String fqName2, @NotNull List args) {
        return $this.canReplaceWithStdLib(expression2, fqName2, args);
    }
}

