/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\u0017\u0018\u0019B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lorg/jetbrains/kotlin/idea/inspections/KotlinUniversalQuickFix;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "AddLateinitFactory", "Companion", "MakeClassOpenFactory", "idea"})
public class AddModifierFix
extends KotlinQuickFixAction<KtModifierListOwner>
implements KotlinUniversalQuickFix {
    @NotNull
    private final KtModifierKeywordToken modifier;
    private static final Set<KtModifierKeywordToken> modalityModifiers;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner == null) {
            return "";
        }
        KtModifierListOwner element3 = ktModifierListOwner;
        if (AddModifierFix.Companion.getModalityModifiers().contains((Object)this.modifier) || KtTokens.VISIBILITY_MODIFIERS.contains((IElementType)this.modifier) || Intrinsics.areEqual((Object)((Object)this.modifier), (Object)((Object)KtTokens.CONST_KEYWORD))) {
            return "Make " + Companion.getElementName(element3) + ' ' + this.modifier.getValue();
        }
        return "Add '" + this.modifier.getValue() + "' modifier";
    }

    @NotNull
    public String getFamilyName() {
        return "Add modifier";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block1: {
            KtModifierListOwner ktModifierListOwner;
            KtModifierListOwner $receiver;
            KtModifierListOwner ktModifierListOwner2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtModifierListOwner ktModifierListOwner3 = (KtModifierListOwner)this.getElement();
            if (ktModifierListOwner3 != null) {
                ktModifierListOwner3.addModifier(this.modifier);
            }
            if (!Intrinsics.areEqual((Object)((Object)this.modifier), (Object)((Object)KtTokens.ABSTRACT_KEYWORD)) || !(this.getElement() instanceof KtProperty) && !(this.getElement() instanceof KtNamedFunction) || (ktModifierListOwner2 = (KtModifierListOwner)this.getElement()) == null || (ktModifierListOwner2 = KtPsiUtilKt.containingClass(ktModifierListOwner2)) == null || ((KtModifierListOwnerStub)($receiver = (ktModifierListOwner = ktModifierListOwner2))).hasModifier(KtTokens.ABSTRACT_KEYWORD) || ((KtModifierListOwnerStub)$receiver).hasModifier(KtTokens.SEALED_KEYWORD)) break block1;
            ((KtModifierListOwnerStub)$receiver).addModifier(KtTokens.ABSTRACT_KEYWORD);
        }
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner == null) {
            return false;
        }
        KtModifierListOwner element3 = ktModifierListOwner;
        return KotlinRefactoringUtilKt.canRefactor(element3);
    }

    @NotNull
    protected final KtModifierKeywordToken getModifier() {
        return this.modifier;
    }

    public AddModifierFix(@NotNull KtModifierListOwner element3, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
        super((PsiElement)element3);
        this.modifier = modifier;
    }

    static {
        Companion = new Companion(null);
        modalityModifiers = SetsKt.setOf((Object[])new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.FINAL_KEYWORD});
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        KotlinUniversalQuickFix.DefaultImpls.applyFix(this, project, descriptor2);
    }

    @Override
    @NotNull
    public String getName() {
        return KotlinUniversalQuickFix.DefaultImpls.getName(this);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$MakeClassOpenFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class MakeClassOpenFactory
    extends KotlinSingleIntentionActionFactory {
        public static final MakeClassOpenFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeReference typeReference = (KtTypeReference)psiElement2;
            BindingContext bindingContext2 = ResolutionUtils.analyze(typeReference, BodyResolveMode.PARTIAL);
            KotlinType kotlinType = (KotlinType)bindingContext2.get(BindingContext.TYPE, typeReference);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor2);
            if (!(psiElement3 instanceof KtClass)) {
                psiElement3 = null;
            }
            KtClass ktClass2 = (KtClass)psiElement3;
            if (ktClass2 == null) {
                return null;
            }
            KtClass declaration2 = ktClass2;
            if (!KotlinRefactoringUtilKt.canRefactor(declaration2)) {
                return null;
            }
            if (declaration2.isEnum()) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.OPEN_KEYWORD");
            return new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken);
        }

        private MakeClassOpenFactory() {
        }

        static {
            MakeClassOpenFactory makeClassOpenFactory;
            INSTANCE = makeClassOpenFactory = new MakeClassOpenFactory();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$AddLateinitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class AddLateinitFactory
    extends KotlinSingleIntentionActionFactory {
        public static final AddLateinitFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Annotated annotated;
            KtProperty property2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.MUST_BE_INITIALIZ\u2026ABSTRACT.cast(diagnostic)");
            KtProperty ktProperty = property2 = (KtProperty)((SimpleDiagnostic)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"property");
            if (!ktProperty.isVar()) {
                return null;
            }
            BindingContext context = ResolutionUtils.analyze$default(property2, null, 1, null);
            DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            if (!(declarationDescriptor2 instanceof PropertyDescriptor)) {
                declarationDescriptor2 = null;
            }
            if ((annotated = (PropertyDescriptor)declarationDescriptor2) == null || (annotated = annotated.getType()) == null) {
                return null;
            }
            Annotated type2 = annotated;
            if (TypeUtils.isNullableType((KotlinType)type2)) {
                return null;
            }
            if (KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = property2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.LATEINIT_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.LATEINIT_KEYWORD");
            return new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken);
        }

        private AddLateinitFactory() {
        }

        static {
            AddLateinitFactory addLateinitFactory;
            INSTANCE = addLateinitFactory = new AddLateinitFactory();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J&\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Companion;", "", "()V", "modalityModifiers", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "getModalityModifiers", "()Ljava/util/Set;", "createFactory", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "modifier", "T", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierOwnerClass", "Ljava/lang/Class;", "createIfApplicable", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "modifierListOwner", "getElementName", "", "idea"})
    public static final class Companion {
        private final Set<KtModifierKeywordToken> getModalityModifiers() {
            return modalityModifiers;
        }

        @NotNull
        public final String getElementName(@NotNull KtModifierListOwner modifierListOwner) {
            Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
            String name2 = null;
            if (modifierListOwner instanceof PsiNameIdentifierOwner) {
                PsiElement nameIdentifier = ((PsiNameIdentifierOwner)modifierListOwner).getNameIdentifier();
                if (nameIdentifier != null) {
                    name2 = nameIdentifier.getText();
                }
            } else if (modifierListOwner instanceof KtPropertyAccessor) {
                PsiElement psiElement2 = ((KtPropertyAccessor)modifierListOwner).getNamePlaceholder();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"modifierListOwner.namePlaceholder");
                name2 = psiElement2.getText();
            }
            if (name2 == null) {
                name2 = modifierListOwner.getText();
            }
            return '\'' + name2 + '\'';
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory createFactory(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
            return this.createFactory(modifier, KtModifierListOwner.class);
        }

        @NotNull
        public final <T extends KtModifierListOwner> KotlinSingleIntentionActionFactory createFactory(@NotNull KtModifierKeywordToken modifier, @NotNull Class<T> modifierOwnerClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
            Intrinsics.checkParameterIsNotNull(modifierOwnerClass, (String)"modifierOwnerClass");
            return new KotlinSingleIntentionActionFactory(modifierOwnerClass, modifier){
                final /* synthetic */ Class $modifierOwnerClass;
                final /* synthetic */ KtModifierKeywordToken $modifier;

                @Nullable
                public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                    KtModifierListOwner modifierListOwner;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)QuickFixUtil.getParentElementOfType(diagnostic, this.$modifierOwnerClass);
                    if (ktModifierListOwner == null) {
                        return null;
                    }
                    KtModifierListOwner ktModifierListOwner2 = modifierListOwner = ktModifierListOwner;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierListOwner2, (String)"modifierListOwner");
                    return AddModifierFix.Companion.createIfApplicable(ktModifierListOwner2, this.$modifier);
                }
                {
                    this.$modifierOwnerClass = $captured_local_variable$0;
                    this.$modifier = $captured_local_variable$1;
                }
            };
        }

        @Nullable
        public final AddModifierFix createIfApplicable(@NotNull KtModifierListOwner modifierListOwner, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
            Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
            KtModifierKeywordToken ktModifierKeywordToken = modifier;
            if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.ABSTRACT_KEYWORD)) || Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.OPEN_KEYWORD))) {
                if (modifierListOwner instanceof KtObjectDeclaration) {
                    return null;
                }
                if (modifierListOwner instanceof KtEnumEntry) {
                    return null;
                }
                if (modifierListOwner instanceof KtDeclaration && !(modifierListOwner instanceof KtClass)) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)modifierListOwner);
                    if (ktClassOrObject == null) {
                        return null;
                    }
                    KtClassOrObject parentClassOrObject = ktClassOrObject;
                    if (parentClassOrObject instanceof KtObjectDeclaration) {
                        return null;
                    }
                    if (parentClassOrObject instanceof KtEnumEntry) {
                        return null;
                    }
                }
            } else if (Intrinsics.areEqual((Object)((Object)ktModifierKeywordToken), (Object)((Object)KtTokens.INNER_KEYWORD))) {
                if (modifierListOwner instanceof KtObjectDeclaration) {
                    return null;
                }
                if (modifierListOwner instanceof KtClass && (((KtClass)modifierListOwner).isInterface() || ((KtClass)modifierListOwner).isSealed() || ((KtClass)modifierListOwner).isEnum() || ((KtClass)modifierListOwner).isData() || ((KtClass)modifierListOwner).isAnnotation())) {
                    return null;
                }
            }
            return new AddModifierFix(modifierListOwner, modifier);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

